/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.owlapi.model.IRI;

public final class OWLOntologyID
implements Comparable<OWLOntologyID>,
Serializable {
    private static final long serialVersionUID = 30402L;
    private static final AtomicInteger counter = new AtomicInteger();
    private static final String ANON_PREFIX = "Anonymous-";
    private String internalID;
    private final IRI ontologyIRI;
    private final IRI versionIRI;
    private int hashCode;

    public OWLOntologyID(IRI ontologyIRI) {
        this(ontologyIRI, null);
    }

    public OWLOntologyID(IRI ontologyIRI, IRI versionIRI) {
        this.ontologyIRI = ontologyIRI;
        this.hashCode = 17;
        if (ontologyIRI != null) {
            this.internalID = null;
            this.hashCode += 37 * ontologyIRI.hashCode();
        }
        if (versionIRI != null) {
            if (ontologyIRI == null) {
                throw new IllegalArgumentException("If the ontology IRI is null then it is not possible to specify a version IRI");
            }
            this.versionIRI = versionIRI;
            this.hashCode += 37 * versionIRI.hashCode();
        } else {
            this.versionIRI = null;
        }
        if (ontologyIRI == null) {
            this.internalID = ANON_PREFIX + counter.getAndIncrement();
            this.hashCode += 37 * this.internalID.hashCode();
        }
    }

    public OWLOntologyID() {
        this(null, null);
    }

    public boolean isOWL2DLOntologyID() {
        return this.ontologyIRI == null || !this.ontologyIRI.isReservedVocabulary() && (this.versionIRI == null || !this.versionIRI.isReservedVocabulary());
    }

    @Override
    public int compareTo(OWLOntologyID o) {
        return this.toString().compareTo(o.toString());
    }

    public IRI getOntologyIRI() {
        return this.ontologyIRI;
    }

    public IRI getVersionIRI() {
        return this.versionIRI;
    }

    public IRI getDefaultDocumentIRI() {
        if (this.ontologyIRI != null) {
            if (this.versionIRI != null) {
                return this.versionIRI;
            }
            return this.ontologyIRI;
        }
        return null;
    }

    public boolean isAnonymous() {
        return this.ontologyIRI == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OntologyID(");
        if (this.ontologyIRI != null) {
            sb.append("OntologyIRI(");
            sb.append(this.ontologyIRI.toQuotedString());
            sb.append(")");
            if (this.versionIRI != null) {
                sb.append(" VersionIRI(");
                sb.append(this.versionIRI.toQuotedString());
                sb.append(")");
            }
        } else {
            sb.append(this.internalID);
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLOntologyID)) {
            return false;
        }
        OWLOntologyID other = (OWLOntologyID)obj;
        if (this.isAnonymous() && other.isAnonymous()) {
            return this.internalID.equals(other.internalID);
        }
        if (this.isAnonymous() != other.isAnonymous()) {
            return false;
        }
        if (!this.isAnonymous()) {
            boolean toReturn = this.ontologyIRI.equals(other.ontologyIRI);
            if (!toReturn) {
                return toReturn;
            }
            toReturn = this.versionIRI != null ? this.versionIRI.equals(other.versionIRI) : other.versionIRI == null;
            return toReturn;
        }
        return false;
    }
}

