/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraph<V, E>
implements Graph<V, E> {
    @Override
    public boolean containsEdge(V v, V v2) {
        return this.getEdge(v, v2) != null;
    }

    @Override
    public boolean removeAllEdges(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            bl |= this.removeEdge(e);
        }
        return bl;
    }

    @Override
    public Set<E> removeAllEdges(V v, V v2) {
        Set set = this.getAllEdges(v, v2);
        this.removeAllEdges(set);
        return set;
    }

    @Override
    public boolean removeAllVertices(Collection<? extends V> collection) {
        boolean bl = false;
        for (V v : collection) {
            bl |= this.removeVertex(v);
        }
        return bl;
    }

    public String toString() {
        return this.toStringFromSets(this.vertexSet(), this.edgeSet(), this instanceof DirectedGraph);
    }

    protected boolean assertVertexExist(V v) {
        if (this.containsVertex(v)) {
            return true;
        }
        if (v == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("no such vertex in graph");
    }

    protected boolean removeAllEdges(E[] EArray) {
        boolean bl = false;
        for (int i = 0; i < EArray.length; ++i) {
            bl |= this.removeEdge(EArray[i]);
        }
        return bl;
    }

    protected String toStringFromSets(Collection<? extends V> collection, Collection<? extends E> collection2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (E e : collection2) {
            if (e.getClass() != DefaultEdge.class && e.getClass() != DefaultWeightedEdge.class) {
                stringBuffer.append(e.toString());
                stringBuffer.append("=");
            }
            if (bl) {
                stringBuffer.append("(");
            } else {
                stringBuffer.append("{");
            }
            stringBuffer.append(this.getEdgeSource(e));
            stringBuffer.append(",");
            stringBuffer.append(this.getEdgeTarget(e));
            if (bl) {
                stringBuffer.append(")");
            } else {
                stringBuffer.append("}");
            }
            arrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        return "(" + collection + ", " + arrayList + ")";
    }
}

