/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.pellint.lintpattern.LintPattern;
import com.clarkparsia.pellint.lintpattern.LintPatternLoader;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.lintpattern.ontology.OntologyLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.OntologyLints;
import com.clarkparsia.pellint.model.Severity;
import com.clarkparsia.pellint.rdfxml.OWLSyntaxChecker;
import com.clarkparsia.pellint.rdfxml.RDFLints;
import com.clarkparsia.pellint.rdfxml.RDFModel;
import com.clarkparsia.pellint.rdfxml.RDFModelReader;
import com.clarkparsia.pellint.rdfxml.RDFModelWriter;
import com.clarkparsia.pellint.util.CollectionUtil;
import com.clarkparsia.pellint.util.IllegalPellintArgumentException;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.FileUtils;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.util.OWLOntologyImportsClosureSetProvider;
import org.semanticweb.owlapi.util.OWLOntologyMerger;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class Pellint
extends PelletCmdApp {
    private static final String CONFIGURATION_PROPERTY_NAME = "pellint.configuration";
    private static final String DEFAULT_CONFIGURATION_FILE_NAME = "pellint.properties";
    private static final IRI MERGED_ONTOLOGY_URI = IRI.create((String)"tag:clarkparsia.com,2008:pellint:merged");
    private static final Logger LOGGER = Logger.getLogger(Pellint.class.getName());
    private boolean m_DoRDF = true;
    private boolean m_DoOWL = true;
    private boolean m_DoRootOnly = false;
    private String m_InputOntologyPath;
    private String m_OutputOntologyPath;

    @Override
    public void parseArgs(String[] stringArray) {
        super.parseArgs(stringArray);
        String string = this.options.getOption("only").getValueAsString();
        if (string == null) {
            this.setDoRDF(true);
            this.setDoOWL(true);
        } else if (string.equalsIgnoreCase("RDF")) {
            this.setDoRDF(true);
            this.setDoOWL(false);
        } else if (string.equalsIgnoreCase("OWL")) {
            this.setDoRDF(false);
            this.setDoOWL(true);
        } else {
            throw new PelletCmdException("Invalid argument to lint --only: " + string);
        }
        this.setDoRootOnly(this.options.getOption("root-only").getValueAsBoolean());
        if (this.getInputFiles().length > 1) {
            throw new PelletCmdException("lint doesn't handle multiple input files");
        }
        this.setInputOntologyPath(this.getInputFiles()[0]);
        this.setOutputOntologyPath(this.options.getOption("fix").getValueAsString());
    }

    @Override
    public String getAppId() {
        return "Pellint: Lint tool for OWL ontologies";
    }

    @Override
    public String getAppCmd() {
        String string = "pellet lint [options] <file URI> ...\n";
        String string2 = "Note: pellet lint <file URI> without arguments prints the lint report to STDOUT.";
        String string3 = System.getProperty("line.separator");
        String string4 = string + string3 + string3 + string2;
        return string4;
    }

    <T extends Serializable> void f(Map<T, T> map) {
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions pelletCmdOptions = this.getGlobalOptions();
        PelletCmdOption pelletCmdOption = new PelletCmdOption("fix");
        pelletCmdOption.setShortOption("f");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setType("File");
        pelletCmdOption.setDescription("Apply any applicable fixes to ontology lints and save a new ontology to file in RDF/XML format.");
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("root-only");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setType("boolean");
        pelletCmdOption.setDescription("Lint the root ontology only; ignore its imports.");
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("only");
        pelletCmdOption.setShortOption("o");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setType("RDF | OWL");
        pelletCmdOption.setDescription("Analyze only RDF declarations or OWL axioms, not both.");
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("exclude-valid-punning");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setDescription("Excludes valid punnings to be reported by lint. OWL 2 allows resources\nto have certain multiple types (known as punning), e.g. a resource can\nbe both a class and an individual. However, certain punnings are not\nallowed under any condition, e.g. a resource cannot be both a datatype\nproperty and an object property. All punnings are reported by default\nbut if this option is used punnings valid for OWL 2 will be excluded\nfrom the report.");
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        return pelletCmdOptions;
    }

    public void setDoRDF(boolean bl) {
        this.m_DoRDF = bl;
    }

    public void setDoOWL(boolean bl) {
        this.m_DoOWL = bl;
    }

    public void setDoRootOnly(boolean bl) {
        this.m_DoRootOnly = bl;
    }

    public void setInputOntologyPath(String string) {
        this.m_InputOntologyPath = string;
    }

    public void setOutputOntologyPath(String string) {
        this.m_OutputOntologyPath = string;
    }

    public static OntologyLints lint(List<AxiomLintPattern> list, List<OntologyLintPattern> list2, OWLOntology oWLOntology) {
        OntologyLints ontologyLints = new OntologyLints(oWLOntology);
        for (OWLAxiom object : oWLOntology.getAxioms()) {
            for (AxiomLintPattern axiomLintPattern : list) {
                Lint lint = axiomLintPattern.match(oWLOntology, object);
                if (lint == null) continue;
                ontologyLints.addLint(axiomLintPattern, lint);
            }
        }
        for (OntologyLintPattern ontologyLintPattern : list2) {
            List<Lint> list3 = ontologyLintPattern.match(oWLOntology);
            if (list3.isEmpty()) continue;
            ontologyLints.addLints(ontologyLintPattern, list3);
        }
        ontologyLints.sort((Comparator<? super Lint>)new Comparator<Lint>(){

            @Override
            public int compare(Lint lint, Lint lint2) {
                Severity severity = lint.getSeverity();
                Severity severity2 = lint2.getSeverity();
                if (severity != null && severity2 != null) {
                    return -severity.compareTo(severity2);
                }
                Set<OWLClass> set = lint.getParticipatingClasses();
                Set<OWLClass> set2 = lint2.getParticipatingClasses();
                if (set == null || set2 == null) {
                    return 0;
                }
                if (set.size() != 1 || set2.size() != 1) {
                    return 0;
                }
                IRI iRI = set.iterator().next().getIRI();
                IRI iRI2 = set2.iterator().next().getIRI();
                if (iRI == null || iRI2 == null) {
                    return 0;
                }
                String string = iRI.getFragment();
                String string2 = iRI2.getFragment();
                if (string == null || string2 == null) {
                    return 0;
                }
                return string.compareTo(string2);
            }
        });
        return ontologyLints;
    }

    @Override
    public void run() {
        try {
            if (this.m_InputOntologyPath == null) {
                throw new IllegalPellintArgumentException("Input ontology is not specified");
            }
            if (this.m_DoRDF) {
                this.runLintForRDFXML();
            }
            if (this.m_DoOWL) {
                this.runLintForOWL();
            }
        }
        catch (IllegalPellintArgumentException illegalPellintArgumentException) {
            illegalPellintArgumentException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            oWLOntologyCreationException.printStackTrace();
        }
        catch (OWLOntologyStorageException oWLOntologyStorageException) {
            oWLOntologyStorageException.printStackTrace();
        }
        catch (OWLOntologyChangeException oWLOntologyChangeException) {
            oWLOntologyChangeException.printStackTrace();
        }
    }

    private void runLintForRDFXML() throws MalformedURLException, IOException {
        RDFModelReader rDFModelReader = new RDFModelReader();
        RDFModel rDFModel = null;
        try {
            rDFModel = rDFModelReader.read(this.m_InputOntologyPath, !this.m_DoRootOnly);
        }
        catch (Exception exception) {
            throw new PelletCmdException(exception);
        }
        OWLSyntaxChecker oWLSyntaxChecker = new OWLSyntaxChecker();
        oWLSyntaxChecker.setExcludeValidPunnings(this.options.getOption("exclude-valid-punning").getValueAsBoolean());
        RDFLints rDFLints = oWLSyntaxChecker.validate(rDFModel);
        this.output(rDFLints.toString());
        if (this.m_OutputOntologyPath != null && !this.m_DoOWL) {
            List<Statement> list = rDFLints.getMissingStatements();
            rDFModel.addAllStatementsWithExistingBNodesOnly(list);
            RDFModelWriter rDFModelWriter = new RDFModelWriter();
            rDFModelWriter.write(new FileOutputStream(new File(this.m_OutputOntologyPath)), rDFModel);
            this.output("Saved to " + this.m_OutputOntologyPath);
        }
    }

    private void runLintForOWL() throws OWLOntologyCreationException, OWLOntologyChangeException, UnknownOWLOntologyException, OWLOntologyStorageException, FileNotFoundException {
        Set<Object> set;
        Object object;
        LintPatternLoader lintPatternLoader = new LintPatternLoader(Pellint.loadProperties());
        List<AxiomLintPattern> list = lintPatternLoader.getAxiomLintPatterns();
        List<OntologyLintPattern> list2 = lintPatternLoader.getOntologyLintPatterns();
        this.logLoadedPatterns(list, list2);
        OWLOntologyManager oWLOntologyManager = OWLManager.createOWLOntologyManager();
        OWLOntology oWLOntology = null;
        try {
            object = FileUtils.toURI(this.m_InputOntologyPath);
            oWLOntology = oWLOntologyManager.loadOntology(IRI.create((String)object));
        }
        catch (Exception exception) {
            throw new PelletCmdException(exception);
        }
        this.output(this.getOWL2DLProfileViolations(oWLOntology));
        object = Pellint.lint(list, list2, oWLOntology);
        this.output(((OntologyLints)object).toString());
        if (!this.m_DoRootOnly) {
            set = CollectionUtil.copy(oWLOntologyManager.getImportsClosure(oWLOntology));
            set.remove(oWLOntology);
            if (set.isEmpty()) {
                this.output("\n" + oWLOntology.getOntologyID() + " does not import other ontologies.");
            } else {
                Object object22;
                for (Object object22 : set) {
                    this.output(this.getOWL2DLProfileViolations((OWLOntology)object22));
                    OntologyLints ontologyLints = Pellint.lint(list, list2, (OWLOntology)object22);
                    this.output(ontologyLints.toString());
                }
                OWLOntology oWLOntology2 = Pellint.buildMergedImportClosure(oWLOntologyManager, oWLOntology);
                object22 = Pellint.lint(list, list2, oWLOntology2);
                ((OntologyLints)object22).setRootOntology(oWLOntology);
                this.output(((OntologyLints)object22).toString());
            }
        }
        if (this.m_OutputOntologyPath != null) {
            set = ((OntologyLints)object).applyFix(oWLOntologyManager);
            if (!set.isEmpty()) {
                this.output("Unreparable lints:");
                for (Object object22 : set) {
                    this.output(((Lint)object22).toString());
                }
            }
            oWLOntologyManager.saveOntology(((OntologyLints)object).getOntology(), (OWLOntologyDocumentTarget)new StreamDocumentTarget((OutputStream)new FileOutputStream(this.m_OutputOntologyPath)));
            this.output("Saved to " + this.m_OutputOntologyPath);
        }
    }

    private String getOWL2DLProfileViolations(OWLOntology oWLOntology) {
        OWL2DLProfile oWL2DLProfile = new OWL2DLProfile();
        OWLProfileReport oWLProfileReport = oWL2DLProfile.checkOntology(oWLOntology);
        if (oWLProfileReport.isInProfile()) {
            return "No OWL 2 DL violations found for ontology " + oWLOntology.getOntologyID().toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n=========================================================\n");
        stringBuffer.append("OWL 2 DL violations found for ontology ").append(oWLOntology.getOntologyID().toString()).append(":\n");
        for (OWLProfileViolation oWLProfileViolation : oWLProfileReport.getViolations()) {
            stringBuffer.append(oWLProfileViolation.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void logLoadedPatterns(List<AxiomLintPattern> list, List<OntologyLintPattern> list2) {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        List<AxiomLintPattern> list3 = CollectionUtil.copy(list);
        list3.addAll(list2);
        Collections.sort(list3, new Comparator<LintPattern>(){

            @Override
            public int compare(LintPattern lintPattern, LintPattern lintPattern2) {
                return lintPattern.getName().compareTo(lintPattern2.getName());
            }
        });
        LOGGER.fine("Loaded lint patterns:");
        for (LintPattern lintPattern : list3) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  ");
            if (lintPattern.isFixable()) {
                stringBuilder.append("[fixable] ");
            } else {
                stringBuilder.append("          ");
            }
            stringBuilder.append(lintPattern.getName());
            LOGGER.fine(stringBuilder.toString());
        }
    }

    private static OWLOntology buildMergedImportClosure(OWLOntologyManager oWLOntologyManager, OWLOntology oWLOntology) throws OWLOntologyCreationException, OWLOntologyChangeException {
        OWLOntologyImportsClosureSetProvider oWLOntologyImportsClosureSetProvider = new OWLOntologyImportsClosureSetProvider(oWLOntologyManager, oWLOntology);
        OWLOntologyMerger oWLOntologyMerger = new OWLOntologyMerger((OWLOntologySetProvider)oWLOntologyImportsClosureSetProvider);
        return oWLOntologyMerger.createMergedOntology(oWLOntologyManager, MERGED_ONTOLOGY_URI);
    }

    private static Properties loadProperties() {
        Properties properties = new Properties();
        String string = System.getProperty(CONFIGURATION_PROPERTY_NAME);
        URL uRL = null;
        if (string == null) {
            uRL = Pellint.class.getClassLoader().getResource(DEFAULT_CONFIGURATION_FILE_NAME);
            if (uRL == null) {
                LOGGER.severe("Cannot find Pellint configuration file pellint.properties");
            }
        } else {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                uRL = Pellint.class.getClassLoader().getResource(string);
            }
            if (uRL == null) {
                LOGGER.severe("Cannot find Pellint configuration file " + string);
            }
        }
        if (uRL != null) {
            try {
                properties.load(uRL.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.severe("Pellint configuration file cannot be found");
            }
            catch (IOException iOException) {
                LOGGER.severe("I/O error while reading Pellet configuration file");
            }
        }
        return properties;
    }
}

