/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.PropertyType;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;

public class RoleTaxonomyBuilder {
    protected static Logger log = Logger.getLogger(Taxonomy.class.getName());
    public static final ATermAppl TOP_ANNOTATION_PROPERTY = ATermUtils.makeTermAppl("_TOP_ANNOTATION_PROPERTY_");
    public static final ATermAppl BOTTOM_ANNOTATION_PROPERTY = ATermUtils.makeTermAppl("_BOTTOM_ANNOTATION_PROPERTY_");
    protected Collection<Role> properties;
    protected Taxonomy<ATermAppl> taxonomy;
    protected RBox rbox;
    protected Role topRole;
    protected Role bottomRole;
    protected PropertyType propertyType;
    int count = 0;

    public RoleTaxonomyBuilder(RBox rBox, PropertyType propertyType) {
        this.rbox = rBox;
        this.propertyType = propertyType;
        this.properties = rBox.getRoles();
        switch (this.propertyType) {
            case OBJECT: {
                this.taxonomy = new Taxonomy<ATermAppl>(null, TermFactory.TOP_OBJECT_PROPERTY, TermFactory.BOTTOM_OBJECT_PROPERTY);
                break;
            }
            case DATATYPE: {
                this.taxonomy = new Taxonomy<ATermAppl>(null, TermFactory.TOP_DATA_PROPERTY, TermFactory.BOTTOM_DATA_PROPERTY);
                break;
            }
            case ANNOTATION: {
                this.taxonomy = new Taxonomy<ATermAppl>(null, TOP_ANNOTATION_PROPERTY, BOTTOM_ANNOTATION_PROPERTY);
                this.taxonomy.getTop().setHidden(true);
                this.taxonomy.getBottom().setHidden(true);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown property type: " + (Object)((Object)this.propertyType)));
            }
        }
        this.topRole = rBox.getRole((ATerm)this.taxonomy.getTop().getName());
        this.bottomRole = rBox.getRole((ATerm)this.taxonomy.getBottom().getName());
    }

    public RoleTaxonomyBuilder(RBox rBox, boolean bl) {
        this.rbox = rBox;
        this.properties = rBox.getRoles();
        this.taxonomy = bl ? new Taxonomy<ATermAppl>(null, TermFactory.TOP_OBJECT_PROPERTY, TermFactory.BOTTOM_OBJECT_PROPERTY) : new Taxonomy<ATermAppl>(null, TermFactory.TOP_DATA_PROPERTY, TermFactory.BOTTOM_DATA_PROPERTY);
        this.topRole = rBox.getRole((ATerm)this.taxonomy.getTop().getName());
        this.bottomRole = rBox.getRole((ATerm)this.taxonomy.getBottom().getName());
    }

    public Taxonomy<ATermAppl> classify() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Properties: " + this.properties.size());
        }
        for (Role role : this.properties) {
            if (this.propertyType != role.getType()) continue;
            this.classify(role);
        }
        return this.taxonomy;
    }

    private void classify(Role role) {
        Object object2;
        if (this.taxonomy.contains(role.getName())) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Property (" + ++this.count + ") " + role + "...");
        }
        if (role.getSubRoles().contains(this.topRole)) {
            this.taxonomy.getTop().addEquivalent(role.getName());
            return;
        }
        if (role.getSuperRoles().contains(this.bottomRole)) {
            this.taxonomy.getBottom().addEquivalent(role.getName());
            return;
        }
        HashMap<TaxonomyNode<Object>, Boolean> hashMap = new HashMap<TaxonomyNode<ATermAppl>, Boolean>();
        this.mark(this.taxonomy.getTop(), hashMap, Boolean.TRUE, Propagate.NONE);
        this.mark(this.taxonomy.getBottom(), hashMap, Boolean.FALSE, Propagate.NONE);
        Collection<TaxonomyNode<ATermAppl>> collection = this.search(true, role, this.taxonomy.getTop(), new HashSet<TaxonomyNode<ATermAppl>>(), new ArrayList<TaxonomyNode<ATermAppl>>(), hashMap);
        hashMap = new HashMap();
        this.mark(this.taxonomy.getTop(), hashMap, Boolean.FALSE, Propagate.NONE);
        this.mark(this.taxonomy.getBottom(), hashMap, Boolean.TRUE, Propagate.NONE);
        if (collection.size() == 1 && this.subsumed((TaxonomyNode<ATermAppl>)(object2 = collection.iterator().next()), role, (Map<TaxonomyNode<ATermAppl>, Boolean>)hashMap)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(ATermUtils.toString(role.getName()) + " = " + ATermUtils.toString((ATermAppl)((TaxonomyNode)object2).getName()));
            }
            this.taxonomy.addEquivalentNode(role.getName(), (TaxonomyNode<ATermAppl>)object2);
            return;
        }
        object2 = this.search(false, role, this.taxonomy.getBottom(), new HashSet<TaxonomyNode<ATermAppl>>(), new ArrayList<TaxonomyNode<ATermAppl>>(), hashMap);
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        for (TaxonomyNode<ATermAppl> object3 : collection) {
            arrayList.add(object3.getName());
        }
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            TaxonomyNode taxonomyNode = (TaxonomyNode)iterator.next();
            arrayList2.add(taxonomyNode.getName());
        }
        this.taxonomy.addNode(Collections.singleton(role.getName()), arrayList, arrayList2, false);
    }

    private Collection<TaxonomyNode<ATermAppl>> search(boolean bl, Role role, TaxonomyNode<ATermAppl> taxonomyNode, Set<TaxonomyNode<ATermAppl>> set, List<TaxonomyNode<ATermAppl>> list, Map<TaxonomyNode<ATermAppl>, Boolean> map) {
        ArrayList<TaxonomyNode<ATermAppl>> arrayList = new ArrayList<TaxonomyNode<ATermAppl>>();
        set.add(taxonomyNode);
        Collection<TaxonomyNode<ATermAppl>> collection = bl ? taxonomyNode.getSubs() : taxonomyNode.getSupers();
        for (TaxonomyNode<Object> taxonomyNode2 : collection) {
            if (bl) {
                if (!this.subsumes(taxonomyNode2, role, map)) continue;
                arrayList.add(taxonomyNode2);
                continue;
            }
            if (!this.subsumed(taxonomyNode2, role, map)) continue;
            arrayList.add(taxonomyNode2);
        }
        if (arrayList.isEmpty()) {
            list.add(taxonomyNode);
        } else {
            for (TaxonomyNode<Object> taxonomyNode2 : arrayList) {
                if (set.contains(taxonomyNode2)) continue;
                this.search(bl, role, taxonomyNode2, set, list, map);
            }
        }
        return list;
    }

    private boolean subsumes(TaxonomyNode<ATermAppl> taxonomyNode, Role role, Map<TaxonomyNode<ATermAppl>, Boolean> map) {
        Boolean bl = map.get(taxonomyNode);
        if (bl != null) {
            return bl;
        }
        boolean bl2 = this.subsumes(this.rbox.getRole((ATerm)taxonomyNode.getName()), role);
        Boolean bl3 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        Propagate propagate = bl2 ? Propagate.NONE : Propagate.DOWN;
        this.mark(taxonomyNode, map, bl3, propagate);
        return bl2;
    }

    private boolean subsumed(TaxonomyNode<ATermAppl> taxonomyNode, Role role, Map<TaxonomyNode<ATermAppl>, Boolean> map) {
        Boolean bl = map.get(taxonomyNode);
        if (bl != null) {
            return bl;
        }
        boolean bl2 = this.subsumes(role, this.rbox.getRole((ATerm)taxonomyNode.getName()));
        Boolean bl3 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        Propagate propagate = bl2 ? Propagate.NONE : Propagate.UP;
        this.mark(taxonomyNode, map, bl3, propagate);
        return bl2;
    }

    private void mark(TaxonomyNode<ATermAppl> taxonomyNode, Map<TaxonomyNode<ATermAppl>, Boolean> map, Boolean bl, Propagate propagate) {
        Boolean bl2 = map.get(taxonomyNode);
        if (bl2 != null) {
            if (!bl2.equals(bl)) {
                throw new RuntimeException("Inconsistent classification result " + taxonomyNode.getName() + " " + bl2 + " " + bl);
            }
            return;
        }
        map.put(taxonomyNode, bl);
        if (propagate != Propagate.NONE) {
            Collection<TaxonomyNode<ATermAppl>> collection = propagate == Propagate.UP ? taxonomyNode.getSupers() : taxonomyNode.getSubs();
            for (TaxonomyNode<ATermAppl> taxonomyNode2 : collection) {
                this.mark(taxonomyNode2, map, bl, propagate);
            }
        }
    }

    private boolean subsumes(Role role, Role role2) {
        boolean bl = role.isSuperRoleOf(role2);
        ATermUtils.assertTrue(role2.isSubRoleOf(role) == bl);
        return bl;
    }

    private static enum Propagate {
        UP,
        DOWN,
        NONE;

    }
}

