/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.expressivity.ProfileBasedExpressivityChecker;
import java.util.Collection;
import java.util.Iterator;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

public class ELExpressivityChecker
extends ProfileBasedExpressivityChecker {
    private Expressivity m_Expressivity;

    public ELExpressivityChecker(KnowledgeBase knowledgeBase) {
        super(knowledgeBase);
    }

    @Override
    public boolean compute(Expressivity expressivity) {
        this.m_Expressivity = expressivity;
        if (!this.processIndividuals()) {
            return false;
        }
        if (!this.processClasses()) {
            return false;
        }
        return this.processRoles();
    }

    private boolean processIndividuals() {
        IndividualIterator individualIterator = this.m_KB.getABox().getIndIterator();
        while (individualIterator.hasNext()) {
            Individual individual = individualIterator.next();
            ATermAppl aTermAppl = ATermUtils.makeValue((ATerm)individual.getName());
            for (ATermAppl aTermAppl2 : individual.getTypes()) {
                if (aTermAppl2.equals(aTermAppl) || ELSyntaxUtils.isEL(aTermAppl2)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processClasses() {
        for (ATermAppl aTermAppl : this.m_KB.getTBox().getAssertedAxioms()) {
            ATermAppl aTermAppl2;
            AFun aFun = aTermAppl.getAFun();
            if (aFun.equals(ATermUtils.DISJOINTSFUN)) {
                this.m_Expressivity.setHasDisjointClasses(true);
                aTermAppl2 = (ATermList)aTermAppl.getArgument(0);
                while (!aTermAppl2.isEmpty()) {
                    if (!ELSyntaxUtils.isEL((ATermAppl)aTermAppl2.getFirst())) {
                        return false;
                    }
                    aTermAppl2 = aTermAppl2.getNext();
                }
                continue;
            }
            aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
            if (!ELSyntaxUtils.isEL(aTermAppl2) || !ELSyntaxUtils.isEL(aTermAppl3)) {
                return false;
            }
            if (aFun.equals(ATermUtils.SUBFUN)) {
                if (!ATermUtils.isBottom(ELSyntaxUtils.simplify(aTermAppl3))) continue;
                this.m_Expressivity.setHasDisjointClasses(true);
                continue;
            }
            if (aFun.equals(ATermUtils.EQCLASSFUN)) {
                if (!ATermUtils.isBottom(ELSyntaxUtils.simplify(aTermAppl2)) && !ATermUtils.isBottom(ELSyntaxUtils.simplify(aTermAppl3))) continue;
                this.m_Expressivity.setHasDisjointClasses(true);
                continue;
            }
            if (aFun.equals(ATermUtils.DISJOINTFUN)) {
                this.m_Expressivity.setHasDisjointClasses(true);
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean processRoles() {
        Collection<Role> collection = this.m_KB.getRBox().getRoles();
        for (Role role : collection) {
            if (role.isBuiltin()) continue;
            if (role.isDatatypeRole()) {
                return false;
            }
            if (role.isAnon()) {
                for (Role role2 : role.getSubRoles()) {
                    if (role2.isAnon() || role2.isBottom()) continue;
                    return false;
                }
            }
            if (role.isAnon() && role.isFunctional()) {
                return false;
            }
            if (role.isFunctional()) {
                return false;
            }
            if (role.isTransitive()) {
                this.m_Expressivity.setHasTransitivity(true);
            }
            if (role.isReflexive()) {
                this.m_Expressivity.setHasReflexivity(true);
            }
            if (role.isIrreflexive()) {
                return false;
            }
            if (role.isAsymmetric()) {
                return false;
            }
            if (!role.getDisjointRoles().isEmpty()) {
                return false;
            }
            if (role.hasComplexSubRole()) {
                this.m_Expressivity.setHasComplexSubRoles(true);
                boolean bl = role.isAnon();
                for (ATermAppl aTermAppl : role.getSubRoleChains()) {
                    while (!aTermAppl.isEmpty()) {
                        if (ATermUtils.isInv((ATermAppl)aTermAppl.getFirst()) != bl) {
                            return false;
                        }
                        aTermAppl = aTermAppl.getNext();
                    }
                }
            }
            if (role.getSubRoles().size() <= 1) continue;
            this.m_Expressivity.setHasRoleHierarchy(true);
        }
        for (Role role : collection) {
            Iterator<Object> iterator = this.m_KB.getRBox().getAssertedDomains(role);
            while (iterator.hasNext()) {
                ATermAppl aTermAppl = (ATermAppl)iterator.next();
                if (!ELSyntaxUtils.isEL(aTermAppl)) {
                    return false;
                }
                this.m_Expressivity.setHasDomain(true);
            }
            Iterator<ATermAppl> iterator2 = this.m_KB.getRBox().getAssertedRanges(role);
            while (iterator2.hasNext()) {
                ATermAppl aTermAppl;
                aTermAppl = iterator2.next();
                if (!ELSyntaxUtils.isEL(aTermAppl)) {
                    return false;
                }
                this.m_Expressivity.setHasDomain(true);
            }
        }
        return true;
    }

    @Override
    public boolean updateWith(Expressivity expressivity, ATermAppl aTermAppl) {
        return false;
    }
}

