/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.SyntaxLabels;

public class SinkTripleOutput
implements Sink<Triple> {
    private CharsetEncoder encoder;
    private Prologue prologue = null;
    private Writer out;
    private NodeToLabel labelPolicy = null;
    private NodeFormatter nodeFmt = new NodeFormatterNT();

    public SinkTripleOutput(OutputStream outs) {
        this(outs, null, SyntaxLabels.createNodeToLabel());
    }

    public SinkTripleOutput(OutputStream outs, Prologue prologue, NodeToLabel labels) {
        this.out = IO.asBufferedUTF8(outs);
        this.setPrologue(prologue);
        this.setLabelPolicy(labels);
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public void setLabelPolicy(NodeToLabel labels) {
        this.labelPolicy = labels;
    }

    @Override
    public void send(Triple triple) {
        try {
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            this.nodeFmt.format(this.out, s);
            this.out.write(" ");
            this.nodeFmt.format(this.out, p);
            this.out.write(" ");
            this.nodeFmt.format(this.out, o);
            this.out.write(" .\n");
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    @Override
    public void flush() {
        IO.flush(this.out);
    }

    @Override
    public void close() {
        IO.flush(this.out);
    }
}

