/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main.iterator;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter2;
import com.hp.hpl.jena.sparql.expr.ExprList;

public abstract class QueryIterJoinBase
extends QueryIter2 {
    private QueryIterator current;
    protected Table tableRight;
    protected ExprList exprs;
    private Binding nextBinding = null;

    public QueryIterJoinBase(QueryIterator left, QueryIterator right, ExprList exprs, ExecutionContext execCxt) {
        super(left, right, execCxt);
        this.tableRight = TableFactory.create(this.getRight());
        this.getRight().close();
        this.exprs = exprs;
    }

    public QueryIterJoinBase(QueryIterator left, Table right, ExprList exprs, ExecutionContext execCxt) {
        super(left, right.iterator(execCxt), execCxt);
        this.tableRight = right;
        this.exprs = exprs;
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        if (this.nextBinding != null) {
            return true;
        }
        this.nextBinding = this.moveToNext();
        return this.nextBinding != null;
    }

    @Override
    protected Binding moveToNextBinding() {
        if (this.nextBinding == null) {
            throw new ARQInternalErrorException("moveToNextBinding: slot empty but hasNext was true)");
        }
        Binding b = this.nextBinding;
        this.nextBinding = null;
        return b;
    }

    @Override
    protected void closeSubIterator() {
        QueryIterJoinBase.performClose(this.current);
        if (this.tableRight != null) {
            this.tableRight.close();
        }
        this.tableRight = null;
    }

    @Override
    protected void requestSubCancel() {
        this.closeSubIterator();
    }

    private Binding moveToNext() {
        do {
            if (this.current != null) {
                if (this.current.hasNext()) {
                    return this.current.nextBinding();
                }
                this.current.close();
                this.current = null;
            }
            this.current = this.joinWorker();
        } while (this.current != null);
        return null;
    }

    protected abstract QueryIterator joinWorker();

    protected QueryIterator leftJoinWorker() {
        if (!this.getLeft().hasNext()) {
            return null;
        }
        Binding b = this.getLeft().nextBinding();
        QueryIterator x = this.tableRight.matchRightLeft(b, true, this.exprs, this.getExecContext());
        return x;
    }

    protected QueryIterator equiJoinWorker() {
        if (!this.getLeft().hasNext()) {
            return null;
        }
        if (this.exprs != null) {
            throw new ARQInternalErrorException("QueryIterJoinBase: expression not empty for equiJoin");
        }
        Binding b = this.getLeft().nextBinding();
        QueryIterator x = this.tableRight.matchRightLeft(b, false, null, this.getExecContext());
        return x;
    }
}

