/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.model;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coode.owlapi.rdf.model.RDFNode;
import org.coode.owlapi.rdf.model.RDFResourceNode;
import org.coode.owlapi.rdf.model.RDFTriple;
import org.coode.owlapi.rdf.renderer.RDFRendererBase;

public class RDFGraph {
    private Map<RDFResourceNode, Set<RDFTriple>> triplesBySubject;
    private Set<RDFResourceNode> rootAnonymousNodes = null;
    private Set<RDFTriple> triples = new HashSet<RDFTriple>();

    public RDFGraph() {
        this.triplesBySubject = new HashMap<RDFResourceNode, Set<RDFTriple>>();
    }

    public boolean isEmpty() {
        return this.triples.isEmpty();
    }

    public void addTriple(RDFTriple triple) {
        this.rootAnonymousNodes = null;
        this.triples.add(triple);
        Set<RDFTriple> tripleSet = this.triplesBySubject.get(triple.getSubject());
        if (tripleSet == null) {
            tripleSet = new HashSet<RDFTriple>();
            this.triplesBySubject.put(triple.getSubject(), tripleSet);
        }
        tripleSet.add(triple);
    }

    @Deprecated
    public Set<RDFTriple> getTriplesForSubject(RDFNode subject) {
        if (this.triplesBySubject.containsKey(subject)) {
            return new HashSet<RDFTriple>((Collection)this.triplesBySubject.get(subject));
        }
        return Collections.emptySet();
    }

    public List<RDFTriple> getSortedTriplesForSubject(RDFNode subject, boolean sort) {
        ArrayList<RDFTriple> toReturn = new ArrayList<RDFTriple>();
        Set<RDFTriple> set = this.triplesBySubject.get(subject);
        if (set != null) {
            toReturn.addAll(set);
        }
        if (sort) {
            Collections.sort(toReturn, RDFRendererBase.tripleComparator);
        }
        return toReturn;
    }

    public boolean isAnonymousNodeSharedSubject(RDFResourceNode node) {
        if (!node.isAnonymous()) {
            return false;
        }
        int count = 0;
        for (RDFTriple triple : this.triples) {
            RDFResourceNode object;
            if (triple.getObject().isLiteral() || !(object = (RDFResourceNode)triple.getObject()).equals(node) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    public Set<RDFResourceNode> getRootAnonymousNodes() {
        if (this.rootAnonymousNodes == null) {
            this.rebuildAnonRoots();
        }
        return this.rootAnonymousNodes;
    }

    private void rebuildAnonRoots() {
        this.rootAnonymousNodes = new HashSet<RDFResourceNode>();
        for (RDFTriple triple : this.triples) {
            this.rootAnonymousNodes.add(triple.getSubject());
        }
        for (RDFTriple triple : this.triples) {
            if (!triple.getObject().isLiteral()) {
                this.rootAnonymousNodes.remove(triple.getObject());
            }
            if (triple.getSubject().isAnonymous()) continue;
            this.rootAnonymousNodes.remove(triple.getSubject());
        }
    }

    public void dumpTriples(Writer w) throws IOException {
        for (Set<RDFTriple> set : this.triplesBySubject.values()) {
            for (RDFTriple triple : set) {
                w.write(triple.toString());
                w.write("\n");
            }
        }
        w.flush();
    }
}

