/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.fsm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.fsm.State;
import org.mindswap.pellet.utils.fsm.Transition;

public class TransitionGraph<T> {
    private State<T> initialState = null;
    private Set<State<T>> allStates = new HashSet<State<T>>();
    private Set<State<T>> finalStates = new HashSet<State<T>>();
    private Set<T> alphabet = new HashSet<T>();

    public int size() {
        return this.allStates.size();
    }

    public State<T> newState() {
        State state = new State();
        this.allStates.add(state);
        return state;
    }

    public Set<T> getAlpahabet() {
        return Collections.unmodifiableSet(this.alphabet);
    }

    public Set<State<T>> getAllStates() {
        return Collections.unmodifiableSet(this.allStates);
    }

    public void setInitialState(State<T> state) {
        this.initialState = state;
    }

    public State<T> getInitialState() {
        return this.initialState;
    }

    public void addFinalState(State<T> state) {
        this.finalStates.add(state);
    }

    public Set<State<T>> getFinalStates() {
        return this.finalStates;
    }

    public State<T> getFinalState() {
        int n = this.finalStates.size();
        if (n == 0) {
            throw new RuntimeException("There are no final states!");
        }
        if (n > 1) {
            throw new RuntimeException("There is more than one final state!");
        }
        return this.finalStates.iterator().next();
    }

    public void addTransition(State<T> state, T t, State<T> state2) {
        if (t == null) {
            throw new NullPointerException();
        }
        state.addTransition(t, state2);
        this.alphabet.add(t);
    }

    public void addTransition(State<T> state, State<T> state2) {
        state.addTransition(state2);
    }

    public List<Pair<State<T>, State<T>>> findTransitions(T t) {
        ArrayList<Pair<State<T>, State<T>>> arrayList = new ArrayList<Pair<State<T>, State<T>>>();
        for (State<T> state : this.allStates) {
            State<T> state2 = state.move(t);
            if (state2 == null) continue;
            arrayList.add(new Pair<State<T>, State<T>>(state, state2));
        }
        return arrayList;
    }

    public boolean isInitial(State<T> state) {
        return this.initialState.equals(state);
    }

    public boolean isFinal(State<T> state) {
        return this.finalStates.contains(state);
    }

    public boolean isAnyFinal(Set<State<T>> set) {
        for (State<T> state : set) {
            if (!this.finalStates.contains(state)) continue;
            return true;
        }
        return false;
    }

    public TransitionGraph<T> epsilon() {
        TransitionGraph<T> transitionGraph = new TransitionGraph<T>();
        State<T> state = transitionGraph.newState();
        State<T> state2 = transitionGraph.newState();
        state.addTransition(state2);
        transitionGraph.initialState = state;
        transitionGraph.finalStates.add(state2);
        return transitionGraph;
    }

    public static <T> TransitionGraph<T> symbol(T t) {
        TransitionGraph<T> transitionGraph = new TransitionGraph<T>();
        State<T> state = transitionGraph.newState();
        State<T> state2 = transitionGraph.newState();
        state.addTransition(t, state2);
        transitionGraph.initialState = state;
        transitionGraph.finalStates.add(state2);
        transitionGraph.alphabet.add(t);
        return transitionGraph;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Transition Graph\n");
        for (State<T> state : this.allStates) {
            stringBuffer.append(state.getName()).append(": ");
            Iterator<Transition<T>> iterator = state.getTransitions().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("initial state: ");
        stringBuffer.append(this.initialState.getName());
        stringBuffer.append("\n");
        stringBuffer.append("final states: ");
        stringBuffer.append(this.finalStates);
        stringBuffer.append("\n");
        stringBuffer.append("alphabet: ");
        stringBuffer.append(this.alphabet);
        stringBuffer.append("\n");
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    public TransitionGraph<T> renumber() {
        HashSet hashSet = new HashSet();
        LinkedList linkedList = new LinkedList();
        int n = 0;
        linkedList.addFirst(this.initialState);
        while (linkedList.size() > 0) {
            State state = (State)linkedList.removeFirst();
            state.setName(n++);
            hashSet.add(state);
            for (Transition transition : state.getTransitions()) {
                if (!hashSet.add(transition.getTo())) continue;
                linkedList.addLast(transition.getTo());
            }
        }
        return this;
    }

    public boolean accepts(List<T> list) {
        State<T> state = this.initialState;
        for (T t : list) {
            if ((state = state.move(t)) != null) continue;
            return false;
        }
        return this.finalStates.contains(state);
    }

    public TransitionGraph<T> choice(TransitionGraph<T> transitionGraph) {
        State<T> state = this.newState();
        State<T> state2 = this.newState();
        this.allStates.addAll(transitionGraph.allStates);
        this.finalStates.addAll(transitionGraph.finalStates);
        state.addTransition(this.initialState);
        state.addTransition(transitionGraph.initialState);
        this.initialState = state;
        for (State<T> state3 : this.finalStates) {
            state3.addTransition(state2);
        }
        this.finalStates.clear();
        this.finalStates.add(state2);
        this.alphabet.addAll(transitionGraph.alphabet);
        return this;
    }

    public TransitionGraph<T> concat(TransitionGraph<T> transitionGraph) {
        State<T> state = this.newState();
        State<T> state2 = this.newState();
        this.allStates.addAll(transitionGraph.allStates);
        state.addTransition(this.initialState);
        this.initialState = state;
        for (State<T> state3 : this.finalStates) {
            state3.addTransition(transitionGraph.initialState);
        }
        for (State<T> state3 : transitionGraph.finalStates) {
            state3.addTransition(state2);
        }
        this.finalStates.clear();
        this.finalStates.add(state2);
        this.alphabet.addAll(transitionGraph.alphabet);
        return this;
    }

    public TransitionGraph<T> closure() {
        State<T> state = this.newState();
        State<T> state2 = this.newState();
        for (State<T> state3 : this.finalStates) {
            state3.addTransition(this.initialState);
            state3.addTransition(state2);
        }
        this.finalStates.clear();
        this.finalStates.add(state2);
        state.addTransition(this.initialState);
        state.addTransition(state2);
        this.initialState = state;
        return this;
    }

    public TransitionGraph<T> insert(TransitionGraph<T> transitionGraph, State<T> state, State<T> state2) {
        this.alphabet.addAll(transitionGraph.alphabet);
        HashMap<State<T>, State<T>> hashMap = new HashMap<State<T>, State<T>>();
        hashMap.put(transitionGraph.getInitialState(), state);
        for (State<T> state3 : transitionGraph.getFinalStates()) {
            hashMap.put(state3, state2);
        }
        for (State<T> state3 : transitionGraph.allStates) {
            State<T> state4 = (State<T>)hashMap.get(state3);
            if (state4 == null) {
                state4 = this.newState();
                hashMap.put(state3, state4);
            }
            for (Transition<T> transition : state3.getTransitions()) {
                State<T> state5 = transition.getTo();
                State<T> state6 = (State<T>)hashMap.get(state5);
                if (state6 == null) {
                    state6 = this.newState();
                    hashMap.put(state5, state6);
                }
                if (transition.isEpsilon()) {
                    state4.addTransition(state6);
                    continue;
                }
                state4.addTransition(transition.getName(), state6);
            }
        }
        return this;
    }

    public Set<State<T>> move(Set<State<T>> set, T t) {
        HashSet<State<T>> hashSet = new HashSet<State<T>>();
        for (State<T> state : set) {
            for (Transition<T> transition : state.getTransitions()) {
                if (!transition.hasName(t)) continue;
                hashSet.add(transition.getTo());
            }
        }
        return hashSet;
    }

    public Set<State<T>> epsilonClosure(State<T> state, Set<State<T>> set) {
        set.add(state);
        for (Transition<T> transition : state.getTransitions()) {
            if (!transition.isEpsilon() || set.contains(transition.getTo())) continue;
            set = this.epsilonClosure(transition.getTo(), set);
        }
        return set;
    }

    public Set<State<T>> epsilonClosure(Set<State<T>> set) {
        Set<State<T>> set2 = new HashSet<State<T>>();
        for (State<T> state : set) {
            set2 = this.epsilonClosure(state, set2);
        }
        return set2;
    }

    public boolean isDeterministic() {
        if (!this.allStates.contains(this.initialState)) {
            throw new InternalReasonerException();
        }
        for (State<T> state : this.allStates) {
            HashSet<T> hashSet = new HashSet<T>();
            for (Transition<T> transition : state.getTransitions()) {
                T t = transition.getName();
                if (!transition.isEpsilon() && hashSet.add(t)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isConnected() {
        HashSet hashSet = new HashSet();
        Stack stack = new Stack();
        stack.push(this.initialState);
        hashSet.add(this.initialState);
        while (!stack.isEmpty()) {
            State state = (State)stack.pop();
            if (!this.allStates.contains(state)) {
                return false;
            }
            for (Transition transition : state.getTransitions()) {
                if (!hashSet.add(transition.getTo())) continue;
                stack.push(transition.getTo());
            }
        }
        return hashSet.size() == this.allStates.size();
    }

    public TransitionGraph<T> determinize() {
        State state;
        HashMap<Object, State> hashMap = new HashMap<Object, State>();
        State state2 = new State();
        Set set = this.epsilonClosure(this.initialState, new HashSet<State<T>>());
        this.initialState = state2;
        HashSet<State> hashSet = new HashSet<State>();
        hashSet.add(state2);
        hashMap.put(set, state2);
        this.initialState = state2;
        boolean bl = true;
        while (bl) {
            state = null;
            Set<State<T>> set2 = null;
            bl = false;
            for (Map.Entry entry : hashMap.entrySet()) {
                state2 = (State)entry.getValue();
                set = (Set)entry.getKey();
                bl = hashSet.contains(state2);
                if (!bl) continue;
                break;
            }
            if (!bl) continue;
            for (Map.Entry entry : this.alphabet) {
                set2 = this.epsilonClosure(this.move(set, entry));
                if (set2.size() == 0) continue;
                state = (State)hashMap.get(set2);
                if (state == null) {
                    state = new State();
                    hashSet.add(state);
                    hashMap.put(set2, state);
                } else if (state.equals(state2)) {
                    state = state2;
                }
                state2.addTransition(entry, state);
            }
            hashSet.remove(state2);
            hashMap.put(set, state2);
        }
        state = new HashSet<State<T>>();
        this.allStates.clear();
        for (Map.Entry entry : hashMap.entrySet()) {
            state2 = (State)entry.getValue();
            set = (Set)entry.getKey();
            this.allStates.add(state2);
            if (!this.isAnyFinal(set)) continue;
            state.add(state2);
        }
        this.finalStates.clear();
        this.finalStates = state;
        return this;
    }

    public void setPartition(Set<State<T>> set, int n, Map<State<T>, Integer> map) {
        for (State<T> state : set) {
            map.put(state, n);
        }
    }

    public TransitionGraph<T> minimize() {
        HashSet<State> hashSet;
        State<T> state22;
        int n;
        ArrayList<HashSet<State<T>>> arrayList = new ArrayList<HashSet<State<T>>>(this.allStates.size());
        HashMap<State<T>, Integer> hashMap = new HashMap<State<T>, Integer>();
        HashMap<State, Object> hashMap2 = new HashMap<State, Object>();
        HashSet<State<T>> hashSet2 = new HashSet<State<T>>(this.finalStates);
        arrayList.add(hashSet2);
        this.setPartition(hashSet2, 0, hashMap);
        if (hashSet2.size() < this.allStates.size()) {
            HashSet<State<T>> hashSet3 = new HashSet<State<T>>(this.allStates);
            hashSet3.removeAll(this.finalStates);
            arrayList.add(hashSet3);
            this.setPartition(hashSet3, 1, hashMap);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Iterator iterator = ((Set)arrayList.get(n)).iterator();
            state22 = (State)iterator.next();
            hashSet = null;
            block1: while (iterator.hasNext()) {
                State object2 = (State)iterator.next();
                for (T t : this.alphabet) {
                    if (this.isEquivalentState(state22.move(t), object2.move(t), hashMap)) continue;
                    if (hashSet == null) {
                        hashSet = new HashSet<State>();
                        arrayList.add(hashSet);
                    }
                    iterator.remove();
                    hashSet.add(object2);
                    hashMap.put(object2, arrayList.size() - 1);
                    continue block1;
                }
            }
            if (hashSet == null) continue;
            n = -1;
        }
        n = (Integer)hashMap.get(this.initialState);
        for (int i = 0; i < arrayList.size(); ++i) {
            state22 = ((Set)arrayList.get(i)).iterator();
            hashSet = (State)state22.next();
            hashMap2.put((State)((Object)hashSet), hashSet);
            if (i == n) {
                this.initialState = hashSet;
            }
            while (state22.hasNext()) {
                State state = (State)state22.next();
                this.allStates.remove(state);
                this.finalStates.remove(state);
                hashMap2.put(state, hashSet);
            }
        }
        for (State<T> state22 : this.allStates) {
            for (Transition transition : state22.getTransitions()) {
                transition.setTo((State)hashMap2.get(transition.getTo()));
            }
        }
        return this;
    }

    protected boolean isEquivalentState(State<T> state, State<T> state2, Map<State<T>, Integer> map) {
        if (state == state2) {
            return true;
        }
        if (state == null || state2 == null) {
            return false;
        }
        return map.get(state).equals(map.get(state2));
    }
}

