/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.fsm;

import org.mindswap.pellet.utils.fsm.State;

public class Transition<T> {
    private static Object EPSILON = null;
    private T name;
    private State<T> to;

    public Transition(State<T> state) {
        this.name = EPSILON;
        this.to = state;
    }

    public Transition(T t, State<T> state) {
        this.name = t;
        this.to = state;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.to == null ? 0 : this.to.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Transition transition = (Transition)object;
        if (this.name == null ? transition.name != null : !this.name.equals(transition.name)) {
            return false;
        }
        return !(this.to == null ? transition.to != null : !this.to.equals(transition.to));
    }

    public boolean isEpsilon() {
        return this.name == EPSILON;
    }

    public State<T> getTo() {
        return this.to;
    }

    public void setTo(State<T> state) {
        this.to = state;
    }

    public T getName() {
        return this.name;
    }

    public boolean hasName(T t) {
        return this.name == EPSILON ? t == EPSILON : (t == EPSILON ? false : this.name.equals(t));
    }

    public String toString() {
        return (this.name == EPSILON ? "epsilon" : this.name.toString()) + " -> " + this.to.getName();
    }
}

