/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import aterm.ATerm;
import aterm.ATermAppl;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.KBOperation;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.StatisticsTable;
import org.mindswap.pellet.utils.Timer;

public class SizeEstimate {
    protected static final Logger log = Logger.getLogger(SizeEstimate.class.getName());
    private static final Set<ATermAppl> EMPTY_SET = SetUtils.emptySet();
    public static double UNKNOWN_PROB = 0.5;
    public static boolean CHECK_CONCEPT_SAT = false;
    private long noSatCost;
    private long oneSatCost;
    private long classificationCost;
    private long realizationCost;
    private long instanceRetrievalCost;
    private long classRetrievalCost;
    private KnowledgeBase kb;
    private boolean computed = false;
    private int pCount;
    private int opCount;
    private int dpCount;
    private int fpCount;
    private int ifpCount;
    private int tpCount;
    private int spCount;
    private int cCount;
    private int iCount;
    private Map<ATermAppl, Integer> instancesPC;
    private Map<ATermAppl, Integer> directInstancesPC;
    private Map<ATermAppl, Integer> classesPI;
    private Map<ATermAppl, Integer> directClassesPI;
    private Map<ATermAppl, Integer> pairsPP;
    private Map<ATermAppl, Integer> sames;
    private Map<ATermAppl, Integer> differents;
    private Map<ATermAppl, Double> avgObjectsPP;
    private Map<ATermAppl, Integer> equivClasses;
    private Map<ATermAppl, Integer> subClasses;
    private Map<ATermAppl, Integer> directSubClasses;
    private Map<ATermAppl, Integer> superClasses;
    private Map<ATermAppl, Integer> directSuperClasses;
    private Map<ATermAppl, Integer> disjoints;
    private Map<ATermAppl, Integer> complements;
    private Map<ATermAppl, Integer> equivProperties;
    private Map<ATermAppl, Integer> subProperties;
    private Map<ATermAppl, Integer> directSubProperties;
    private Map<ATermAppl, Integer> superProperties;
    private Map<ATermAppl, Integer> directSuperProperties;
    private Map<ATermAppl, Integer> inverses;
    private double avgClassesPI;
    private double avgDirectClassesPI;
    private double avgSamesPI;
    private double avgDifferentsPI;
    private double avgSubClasses;
    private double avgDirectSubClasses;
    private double avgSuperClasses;
    private double avgDirectSuperClasses;
    private double avgEquivClasses;
    private double avgDisjoints;
    private double avgComplements;
    private double avgSubProperties;
    private double avgDirectSubProperties;
    private double avgSuperProperties;
    private double avgDirectSuperProperties;
    private double avgEquivProperties;
    private double avgInversesPP;
    private double avgPairsPP;
    private double avgSubjectsPerProperty;
    private double avgInstancesPC;
    private double avgDirectInstances;

    public SizeEstimate(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        this.init();
    }

    public boolean isKBComputed() {
        return this.computed;
    }

    private void init() {
        this.cCount = this.kb.getClasses().size();
        this.iCount = this.kb.getIndividuals().size();
        this.pCount = this.kb.getProperties().size();
        this.opCount = this.kb.getObjectProperties().size();
        this.dpCount = this.kb.getDataProperties().size();
        this.fpCount = this.kb.getFunctionalProperties().size();
        this.ifpCount = this.kb.getInverseFunctionalProperties().size();
        this.tpCount = this.kb.getTransitiveProperties().size();
        this.spCount = this.kb.getSymmetricProperties().size();
        this.instancesPC = new HashMap<ATermAppl, Integer>();
        this.directInstancesPC = new HashMap<ATermAppl, Integer>();
        this.classesPI = new HashMap<ATermAppl, Integer>();
        this.directClassesPI = new HashMap<ATermAppl, Integer>();
        this.pairsPP = new HashMap<ATermAppl, Integer>();
        this.avgObjectsPP = new HashMap<ATermAppl, Double>();
        this.sames = new HashMap<ATermAppl, Integer>();
        this.differents = new HashMap<ATermAppl, Integer>();
        this.subClasses = new HashMap<ATermAppl, Integer>();
        this.directSubClasses = new HashMap<ATermAppl, Integer>();
        this.superClasses = new HashMap<ATermAppl, Integer>();
        this.directSuperClasses = new HashMap<ATermAppl, Integer>();
        this.equivClasses = new HashMap<ATermAppl, Integer>();
        this.disjoints = new HashMap<ATermAppl, Integer>();
        this.complements = new HashMap<ATermAppl, Integer>();
        this.inverses = new HashMap<ATermAppl, Integer>();
        this.subProperties = new HashMap<ATermAppl, Integer>();
        this.directSubProperties = new HashMap<ATermAppl, Integer>();
        this.superProperties = new HashMap<ATermAppl, Integer>();
        this.directSuperProperties = new HashMap<ATermAppl, Integer>();
        this.equivProperties = new HashMap<ATermAppl, Integer>();
        this.instancesPC.put(ATermUtils.TOP, this.iCount);
        this.instancesPC.put(ATermUtils.BOTTOM, 0);
        this.subClasses.put(ATermUtils.TOP, this.cCount);
        this.directSubClasses.put(ATermUtils.TOP, this.cCount);
        this.subClasses.put(ATermUtils.BOTTOM, 1);
        this.directSubClasses.put(ATermUtils.BOTTOM, 0);
        this.superClasses.put(ATermUtils.TOP, 1);
        this.directSuperClasses.put(ATermUtils.TOP, 0);
        this.superClasses.put(ATermUtils.BOTTOM, this.cCount);
        this.directSuperClasses.put(ATermUtils.BOTTOM, this.cCount);
        this.equivClasses.put(ATermUtils.TOP, 1);
        this.equivClasses.put(ATermUtils.BOTTOM, 1);
        this.disjoints.put(ATermUtils.TOP, 1);
        this.disjoints.put(ATermUtils.BOTTOM, this.cCount);
        this.complements.put(ATermUtils.TOP, 1);
        this.complements.put(ATermUtils.BOTTOM, 1);
        this.computed = false;
        this.avgSubjectsPerProperty = 1.0;
        this.avgPairsPP = 1.0;
        this.computKBCosts();
    }

    public void computKBCosts() {
        int n = this.kb.getClasses().size();
        int n2 = this.kb.getClasses().size();
        this.noSatCost = 1L;
        this.oneSatCost = 2L;
        this.classificationCost = this.kb.isClassified() ? this.noSatCost : (long)(n * n) * this.oneSatCost / 10L;
        this.realizationCost = this.kb.isRealized() ? this.noSatCost : this.classificationCost + this.oneSatCost * (long)n * (long)n2;
        this.instanceRetrievalCost = this.kb.isRealized() ? this.noSatCost : (long)n2 * this.oneSatCost / 100L;
        this.classRetrievalCost = this.kb.isRealized() ? this.noSatCost : this.realizationCost;
    }

    public void computeAll() {
        if (!this.computed) {
            this.computKBCosts();
            if (log.isLoggable(Level.FINE)) {
                log.fine("   NoSat cost : " + this.noSatCost + " ms.");
                log.fine("  OneSat cost : " + this.oneSatCost + " ms.");
                log.fine("Classify cost : " + this.classificationCost + " ms.");
                log.fine(" Realize cost : " + this.realizationCost + " ms.");
                log.fine("      IR cost : " + this.instanceRetrievalCost + " ms.");
                log.fine("      CR cost : " + this.classRetrievalCost + " ms.");
            }
            this.compute(new HashSet<ATermAppl>(this.kb.getClasses()), new HashSet<ATermAppl>(this.kb.getProperties()));
            this.computed = true;
        }
    }

    public boolean isComputed(ATermAppl aTermAppl) {
        return this.instancesPC.containsKey(aTermAppl) || this.pairsPP.containsKey(aTermAppl) || this.classesPI.containsKey(aTermAppl);
    }

    private double average(Collection<Integer> collection) {
        int n = 0;
        Iterator<Integer> iterator = collection.iterator();
        while (iterator.hasNext()) {
            n += iterator.next().intValue();
        }
        return collection.size() > 0 ? (double)n / (double)collection.size() : 1.0;
    }

    /*
     * WARNING - void declaration
     */
    public void compute(Collection<ATermAppl> collection, Collection<ATermAppl> collection2) {
        int n;
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(collection);
        HashSet<ATermAppl> hashSet2 = new HashSet<ATermAppl>(collection2);
        hashSet.removeAll(this.instancesPC.keySet());
        hashSet2.removeAll(this.pairsPP.keySet());
        Timer timer = this.kb.timers.startTimer("sizeEstimate");
        log.fine("Size estimation started");
        Random random = new Random();
        HashMap<ATermAppl, Integer> hashMap = new HashMap<ATermAppl, Integer>();
        HashMap<ATermAppl, Integer> hashMap2 = new HashMap<ATermAppl, Integer>();
        Taxonomy<ATermAppl> taxonomy = this.kb.isClassified() ? this.kb.getTaxonomy() : this.kb.getToldTaxonomy();
        Iterator<Object> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ATermAppl aTermAppl = (ATermAppl)iterator.next();
            if (!this.kb.isClass((ATerm)aTermAppl)) continue;
            if (taxonomy.contains(aTermAppl)) {
                this.subClasses.put(aTermAppl, taxonomy.getFlattenedSubs(aTermAppl, false).size());
                this.directSubClasses.put(aTermAppl, taxonomy.getFlattenedSubs(aTermAppl, true).size());
                this.superClasses.put(aTermAppl, taxonomy.getFlattenedSupers(aTermAppl, false).size());
                this.directSuperClasses.put(aTermAppl, taxonomy.getFlattenedSupers(aTermAppl, true).size());
                this.equivClasses.put(aTermAppl, taxonomy.getEquivalents(aTermAppl).size() + 1);
            } else {
                this.subClasses.put(aTermAppl, 1);
                this.directSubClasses.put(aTermAppl, 1);
                this.superClasses.put(aTermAppl, 1);
                this.directSuperClasses.put(aTermAppl, 1);
                this.equivClasses.put(aTermAppl, 1);
            }
            Map<ATermAppl, Set<ATermAppl>> map = this.kb.getToldDisjoints();
            if (map.containsKey(aTermAppl)) {
                this.disjoints.put(aTermAppl, map.get(aTermAppl).size());
                this.complements.put(aTermAppl, map.get(aTermAppl).size());
            } else {
                this.disjoints.put(aTermAppl, 1);
                this.complements.put(aTermAppl, 1);
            }
            if (this.kb.isRealized() && !ATermUtils.isComplexClass((ATerm)aTermAppl)) {
                this.instancesPC.put(aTermAppl, this.kb.getInstances(aTermAppl).size());
                this.directInstancesPC.put(aTermAppl, this.kb.getInstances(aTermAppl, true).size());
            } else {
                this.instancesPC.put(aTermAppl, 0);
                this.directInstancesPC.put(aTermAppl, 0);
                if (CHECK_CONCEPT_SAT) {
                    if (!this.kb.isSatisfiable(aTermAppl)) {
                        iterator.remove();
                    }
                    if (!this.kb.isSatisfiable(ATermUtils.makeNot((ATerm)aTermAppl))) {
                        iterator.remove();
                        this.instancesPC.put(aTermAppl, this.kb.getIndividuals().size());
                    }
                }
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Initialize " + aTermAppl + " = " + this.size(aTermAppl));
        }
        for (ATermAppl aTermAppl : hashSet2) {
            this.pairsPP.put(aTermAppl, 0);
            hashMap.put(aTermAppl, 0);
            hashMap2.put(aTermAppl, 0);
            this.subProperties.put(aTermAppl, this.kb.getSubProperties(aTermAppl).size());
            this.directSubProperties.put(aTermAppl, this.kb.getSubProperties(aTermAppl, true).size());
            this.superProperties.put(aTermAppl, this.kb.getSuperProperties(aTermAppl).size());
            this.directSuperProperties.put(aTermAppl, this.kb.getSuperProperties(aTermAppl, true).size());
            this.equivProperties.put(aTermAppl, this.kb.getEquivalentProperties(aTermAppl).size() + 1);
            this.inverses.put(aTermAppl, this.kb.getInverses((ATerm)aTermAppl).size());
        }
        for (ATermAppl aTermAppl : this.kb.getIndividuals()) {
            Object object;
            if (!this.kb.isIndividual((ATerm)aTermAppl)) continue;
            this.sames.put(aTermAppl, 1);
            this.differents.put(aTermAppl, this.iCount);
            float f = random.nextFloat();
            if ((double)f > PelletOptions.SAMPLING_RATIO) continue;
            if (this.kb.isRealized()) {
                this.classesPI.put(aTermAppl, this.kb.getTypes(aTermAppl).size());
                this.directClassesPI.put(aTermAppl, this.kb.getTypes(aTermAppl, true).size());
            } else {
                this.classesPI.put(aTermAppl, 0);
                this.directClassesPI.put(aTermAppl, 0);
                for (ATermAppl aTermAppl2 : hashSet) {
                    object = this.kb.getABox().isKnownType(aTermAppl, aTermAppl2);
                    if (!((Bool)object).isTrue() && (!CHECK_CONCEPT_SAT || !((Bool)object).isUnknown() || !((double)random.nextFloat() < UNKNOWN_PROB))) continue;
                    this.instancesPC.put(aTermAppl2, this.size(aTermAppl2) + 1);
                    this.directInstancesPC.put(aTermAppl2, this.size(aTermAppl2) + 1);
                    this.classesPI.put(aTermAppl, this.classesPerInstance(aTermAppl, false) + 1);
                    this.directClassesPI.put(aTermAppl, this.classesPerInstance(aTermAppl, true) + 1);
                }
            }
            for (ATermAppl aTermAppl3 : hashSet2) {
                HashSet<Object> hashSet3;
                Collection<Object> collection3;
                object = this.kb.getRBox().getRole((ATerm)aTermAppl3);
                n = 0;
                if (((Role)object).isObjectRole()) {
                    collection3 = new HashSet();
                    hashSet3 = new HashSet<ATermAppl>();
                    this.kb.getABox().getObjectPropertyValues(aTermAppl, (Role)object, (Set<ATermAppl>)collection3, (Set<ATermAppl>)hashSet3, true);
                    n = collection3.size();
                } else {
                    collection3 = this.kb.getABox().getObviousDataPropertyValues(aTermAppl, (Role)object, null);
                    n = collection3.size();
                }
                if (n > 0) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Update " + aTermAppl3 + " by " + n);
                    }
                    this.pairsPP.put(aTermAppl3, this.size(aTermAppl3) + n);
                    hashMap.put(aTermAppl3, (Integer)hashMap.get(aTermAppl3) + 1);
                }
                if (!((Role)object).isObjectRole()) continue;
                object = ((Role)object).getInverse();
                collection3 = new HashSet();
                hashSet3 = new HashSet();
                this.kb.getABox().getObjectPropertyValues(aTermAppl, (Role)object, (Set<ATermAppl>)collection3, (Set<ATermAppl>)hashSet3, true);
                if (collection3.isEmpty()) continue;
                hashMap2.put(aTermAppl3, (Integer)hashMap2.get(aTermAppl3) + 1);
            }
        }
        if (!this.computed) {
            this.avgClassesPI = this.average(this.classesPI.values());
            this.avgDirectClassesPI = this.average(this.directClassesPI.values());
        }
        if (!this.kb.isRealized()) {
            for (ATermAppl aTermAppl : hashSet) {
                int n3 = this.instancesPC.get(aTermAppl);
                if (n3 == 0) {
                    this.instancesPC.put(aTermAppl, 1);
                } else {
                    this.instancesPC.put(aTermAppl, (int)((double)n3 / PelletOptions.SAMPLING_RATIO));
                }
                n3 = this.directInstancesPC.get(aTermAppl);
                if (n3 == 0) {
                    this.directInstancesPC.put(aTermAppl, 1);
                    continue;
                }
                this.directInstancesPC.put(aTermAppl, (int)((double)n3 / PelletOptions.SAMPLING_RATIO));
            }
            int n4 = Double.valueOf(this.avgClassesPI).intValue();
            int n5 = Double.valueOf(this.avgDirectClassesPI).intValue();
            for (ATermAppl aTermAppl : this.kb.getIndividuals()) {
                void var14_37;
                void var14_34;
                Integer n2 = this.classesPI.get(aTermAppl);
                if (n2 == null) {
                    Integer n3 = n4;
                }
                if (var14_34.intValue() == 0) {
                    this.classesPI.put(aTermAppl, 1);
                } else {
                    this.classesPI.put(aTermAppl, (int)((double)var14_34.intValue() / PelletOptions.SAMPLING_RATIO));
                }
                Integer n6 = this.directClassesPI.get(aTermAppl);
                if (n6 == null) {
                    Integer n7 = n5;
                }
                if (var14_37.intValue() == 0) {
                    this.directClassesPI.put(aTermAppl, 1);
                    continue;
                }
                this.directClassesPI.put(aTermAppl, (int)((double)var14_37.intValue() / PelletOptions.SAMPLING_RATIO));
            }
        }
        for (ATermAppl aTermAppl : hashSet2) {
            int n6 = this.size(aTermAppl);
            if (n6 == 0) {
                this.pairsPP.put(aTermAppl, 1);
            } else {
                this.pairsPP.put(aTermAppl, (int)((double)n6 / PelletOptions.SAMPLING_RATIO));
            }
            Role role = this.kb.getRBox().getRole((ATerm)aTermAppl);
            ATermAppl aTermAppl4 = role.getInverse() != null ? role.getInverse().getName() : null;
            int n8 = (Integer)hashMap.get(aTermAppl);
            if (n8 == 0) {
                n8 = 1;
            }
            if ((n = ((Integer)hashMap2.get(aTermAppl)).intValue()) == 0) {
                n = 1;
            }
            double d = (double)n6 / (double)n8;
            this.avgObjectsPP.put(aTermAppl, d);
            this.avgSubjectsPerProperty += (double)n8;
            if (aTermAppl4 == null) continue;
            d = (double)n6 / (double)n;
            this.avgObjectsPP.put(aTermAppl4, d);
            this.avgSubjectsPerProperty += (double)n;
        }
        if (hashSet2.size() > 0) {
            this.avgSubjectsPerProperty /= (double)(2 * hashSet2.size());
            this.avgPairsPP = this.average(this.pairsPP.values());
        } else {
            this.avgSubjectsPerProperty = 1.0;
            this.avgPairsPP = 1.0;
        }
        this.avgInstancesPC = this.average(this.instancesPC.values());
        this.avgDirectInstances = this.average(this.directInstancesPC.values());
        this.avgSamesPI = this.average(this.sames.values());
        this.avgDifferentsPI = this.average(this.differents.values());
        this.avgSubClasses = this.average(this.subClasses.values());
        this.avgDirectSubClasses = this.average(this.directSubClasses.values());
        this.avgSuperClasses = this.average(this.superClasses.values());
        this.avgDirectSuperClasses = this.average(this.directSuperClasses.values());
        this.avgEquivClasses = this.average(this.equivClasses.values());
        this.avgDisjoints = this.average(this.disjoints.values());
        this.avgComplements = this.average(this.complements.values());
        this.avgSubProperties = this.average(this.subProperties.values());
        this.avgDirectSubProperties = this.average(this.directSubProperties.values());
        this.avgSuperProperties = this.average(this.superProperties.values());
        this.avgDirectSuperProperties = this.average(this.directSuperProperties.values());
        this.avgEquivProperties = this.average(this.equivProperties.values());
        this.avgInversesPP = this.average(this.inverses.values());
        timer.stop();
        if (log.isLoggable(Level.FINE)) {
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            log.fine("Size estimation finished in " + decimalFormat.format((double)timer.getLast() / 1000.0) + " sec");
        }
    }

    private void printStatistics() {
        System.out.println("Avg classes per instance:" + this.avgClassesPI);
        System.out.println("Avg sames per individual:" + this.avgSamesPerInstance());
        System.out.println("Avg differents per individual:" + this.avgDifferentsPerInstance());
        StatisticsTable<ATermAppl, String> statisticsTable = new StatisticsTable<ATermAppl, String>();
        statisticsTable.add("size", this.instancesPC);
        statisticsTable.add("subs", this.subClasses);
        statisticsTable.add("supers", this.superClasses);
        statisticsTable.add("equivs", this.equivClasses);
        statisticsTable.add("complements", this.complements);
        statisticsTable.add("disjoints", this.disjoints);
        System.out.println(statisticsTable.toString());
        System.out.println("Avg individuals per class:" + this.avgInstancesPC);
        System.out.println("Avg subclasses:" + this.avgSubClasses(false));
        System.out.println("Avg direct subclasses:" + this.avgSubClasses(true));
        System.out.println("Avg superclasses:" + this.avgSuperClasses(false));
        System.out.println("Avg direct superclasses:" + this.avgSuperClasses(true));
        System.out.println("Avg equivalent classes:" + this.avgEquivClasses());
        System.out.println("Avg complement classes:" + this.avgComplementClasses());
        System.out.println("Avg disjoint classes:" + this.avgDisjointClasses());
        StatisticsTable<ATermAppl, String> statisticsTable2 = new StatisticsTable<ATermAppl, String>();
        statisticsTable2.add("size", this.pairsPP);
        statisticsTable2.add("avgs", this.avgObjectsPP);
        statisticsTable2.add("subs", this.subProperties);
        statisticsTable2.add("supers", this.superProperties);
        statisticsTable2.add("equivs", this.equivProperties);
        statisticsTable2.add("inverses", this.inverses);
        System.out.println(statisticsTable2.toString());
        System.out.println("Avg pairs per property:" + this.avgPairsPerProperty());
        System.out.println("Avg subjects per property:" + this.avgSubjectsPerProperty());
        System.out.println("Avg subproperties:" + this.avgSubProperties(false));
        System.out.println("Avg superproperties:" + this.avgSuperProperties(false));
        System.out.println("Avg equivalent properties:" + this.avgEquivProperties());
    }

    public int size(ATermAppl aTermAppl) {
        if (this.instancesPC.containsKey(aTermAppl)) {
            return this.instancesPC.get(aTermAppl);
        }
        if (this.pairsPP.containsKey(aTermAppl)) {
            return this.pairsPP.get(aTermAppl);
        }
        if (this.kb.isProperty((ATerm)aTermAppl)) {
            this.compute(EMPTY_SET, Collections.singleton(aTermAppl));
        } else {
            this.compute(Collections.singleton(aTermAppl), EMPTY_SET);
        }
        return this.size(aTermAppl);
    }

    public int classesPerInstance(ATermAppl aTermAppl, boolean bl) {
        Map<ATermAppl, Integer> map;
        Map<ATermAppl, Integer> map2 = map = bl ? this.directClassesPI : this.classesPI;
        if (map.containsKey(aTermAppl)) {
            return map.get(aTermAppl);
        }
        throw new InternalReasonerException("Instance number estimate : " + aTermAppl + " is not found!");
    }

    public double avg(ATermAppl aTermAppl) {
        if (!this.avgObjectsPP.containsKey(aTermAppl)) {
            this.compute(EMPTY_SET, Collections.singleton(aTermAppl));
        }
        return this.avgObjectsPP.get(aTermAppl);
    }

    public int getClassCount() {
        return this.cCount;
    }

    public int getInstanceCount() {
        return this.iCount;
    }

    public int getPropertyCount() {
        return this.pCount;
    }

    public int getObjectPropertyCount() {
        return this.opCount;
    }

    public int getDataPropertyCount() {
        return this.dpCount;
    }

    public int getFunctionalPropertyCount() {
        return this.fpCount;
    }

    public int getInverseFunctionalPropertyCount() {
        return this.ifpCount;
    }

    public int getTransitivePropertyCount() {
        return this.tpCount;
    }

    public int getSymmetricPropertyCount() {
        return this.spCount;
    }

    public double avgInstancesPerClass(boolean bl) {
        return bl ? this.avgDirectInstances : this.avgInstancesPC;
    }

    public double avgDirectInstancesPerClass() {
        return this.avgDirectInstances;
    }

    public double avgPairsPerProperty() {
        return this.avgPairsPP;
    }

    public double avgSubjectsPerProperty() {
        return this.avgSubjectsPerProperty;
    }

    public double avgSubClasses(boolean bl) {
        return bl ? this.avgDirectSubClasses : this.avgSubClasses;
    }

    public double avgSuperClasses(boolean bl) {
        return bl ? this.avgDirectSuperClasses : this.avgSuperClasses;
    }

    public double avgEquivClasses() {
        return this.avgEquivClasses;
    }

    public double avgDisjointClasses() {
        return this.avgDisjoints;
    }

    public double avgComplementClasses() {
        return this.avgComplements;
    }

    public double avgSubProperties(boolean bl) {
        return bl ? this.avgDirectSubProperties : this.avgSubProperties;
    }

    public double avgSuperProperties(boolean bl) {
        return bl ? this.avgDirectSuperProperties : this.avgSuperProperties;
    }

    public double avgEquivProperties() {
        return this.avgEquivProperties;
    }

    public double avgInverseProperties() {
        return this.avgInversesPP;
    }

    public double avgSamesPerInstance() {
        return this.avgSamesPI;
    }

    public double avgDifferentsPerInstance() {
        return this.avgDifferentsPI;
    }

    public double avgClassesPerInstance(boolean bl) {
        return bl ? this.avgDirectClassesPI : this.avgClassesPI;
    }

    public double subClasses(ATermAppl aTermAppl, boolean bl) {
        Map<ATermAppl, Integer> map;
        Map<ATermAppl, Integer> map2 = map = bl ? this.directSubClasses : this.subClasses;
        if (!map.containsKey(aTermAppl)) {
            this.compute(Collections.singleton(aTermAppl), EMPTY_SET);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Computing additionally " + aTermAppl);
            }
        }
        return map.get(aTermAppl).intValue();
    }

    public double subProperties(ATermAppl aTermAppl, boolean bl) {
        Map<ATermAppl, Integer> map;
        Map<ATermAppl, Integer> map2 = map = bl ? this.directSubProperties : this.subProperties;
        if (!map.containsKey(aTermAppl)) {
            this.compute(EMPTY_SET, Collections.singleton(aTermAppl));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Computing additionally " + aTermAppl);
            }
        }
        return map.get(aTermAppl).intValue();
    }

    public double superClasses(ATermAppl aTermAppl, boolean bl) {
        Map<ATermAppl, Integer> map;
        Map<ATermAppl, Integer> map2 = map = bl ? this.directSuperClasses : this.superClasses;
        if (!map.containsKey(aTermAppl)) {
            this.compute(Collections.singleton(aTermAppl), EMPTY_SET);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Computing additionally " + aTermAppl);
            }
        }
        return map.get(aTermAppl).intValue();
    }

    public double superProperties(ATermAppl aTermAppl, boolean bl) {
        Map<ATermAppl, Integer> map;
        Map<ATermAppl, Integer> map2 = map = bl ? this.directSuperProperties : this.superProperties;
        if (!map.containsKey(aTermAppl)) {
            this.compute(EMPTY_SET, Collections.singleton(aTermAppl));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Computing additionally " + aTermAppl);
            }
        }
        return map.get(aTermAppl).intValue();
    }

    public double equivClasses(ATermAppl aTermAppl) {
        if (!this.equivClasses.containsKey(aTermAppl)) {
            this.compute(Collections.singleton(aTermAppl), EMPTY_SET);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Computing additionally " + aTermAppl);
            }
        }
        return this.equivClasses.get(aTermAppl).intValue();
    }

    public double equivProperties(ATermAppl aTermAppl) {
        if (!this.equivProperties.containsKey(aTermAppl)) {
            this.compute(EMPTY_SET, Collections.singleton(aTermAppl));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Computing additionally " + aTermAppl);
            }
        }
        return this.equivProperties.get(aTermAppl).intValue();
    }

    public double sames(ATermAppl aTermAppl) {
        if (this.sames.containsKey(aTermAppl)) {
            return this.sames.get(aTermAppl).intValue();
        }
        throw new InternalReasonerException("Sames estimate for " + aTermAppl + " is not found!");
    }

    public double differents(ATermAppl aTermAppl) {
        if (this.differents.containsKey(aTermAppl)) {
            return this.differents.get(aTermAppl).intValue();
        }
        throw new InternalReasonerException("Sames estimate for " + aTermAppl + " is not found!");
    }

    public double disjoints(ATermAppl aTermAppl) {
        if (!this.disjoints.containsKey(aTermAppl)) {
            this.compute(Collections.singleton(aTermAppl), EMPTY_SET);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Computing additionally " + aTermAppl);
            }
        }
        return this.disjoints.get(aTermAppl).intValue();
    }

    public double complements(ATermAppl aTermAppl) {
        if (!this.complements.containsKey(aTermAppl)) {
            this.compute(Collections.singleton(aTermAppl), EMPTY_SET);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Computing additionally " + aTermAppl);
            }
        }
        return this.complements.get(aTermAppl).intValue();
    }

    public double inverses(ATermAppl aTermAppl) {
        if (!this.inverses.containsKey(aTermAppl)) {
            this.compute(EMPTY_SET, Collections.singleton(aTermAppl));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Computing additionally " + aTermAppl);
            }
        }
        return this.inverses.get(aTermAppl).intValue();
    }

    public long getCost(KBOperation kBOperation) {
        long l;
        switch (kBOperation) {
            case IS_DIRECT_TYPE: {
                l = this.getCost(KBOperation.IS_TYPE);
                break;
            }
            case IS_TYPE: {
                l = this.kb.isRealized() ? this.noSatCost : this.oneSatCost;
                break;
            }
            case HAS_PROPERTY_VALUE: {
                l = this.noSatCost;
                break;
            }
            case IS_SUBCLASS_OF: 
            case IS_EQUIVALENT_CLASS: {
                l = this.oneSatCost;
                break;
            }
            case IS_DISJOINT_WITH: 
            case IS_COMPLEMENT_OF: {
                l = this.oneSatCost;
                break;
            }
            case IS_SUBPROPERTY_OF: 
            case IS_EQUIVALENT_PROPERTY: {
                l = this.noSatCost;
                break;
            }
            case IS_OBJECT_PROPERTY: 
            case IS_DATATYPE_PROPERTY: {
                l = this.noSatCost;
                break;
            }
            case IS_FUNCTIONAL_PROPERTY: 
            case IS_INVERSE_FUNCTIONAL_PROPERTY: 
            case IS_TRANSITIVE_PROPERTY: 
            case IS_DOMAIN: 
            case IS_RANGE: {
                l = this.oneSatCost;
                break;
            }
            case IS_INVERSE_OF: {
                l = this.noSatCost;
                break;
            }
            case IS_SYMMETRIC_PROPERTY: {
                l = this.noSatCost;
                break;
            }
            case IS_ASYMMETRIC_PROPERTY: {
                l = this.noSatCost;
                break;
            }
            case IS_REFLEXIVE_PROPERTY: {
                l = this.noSatCost;
                break;
            }
            case IS_IRREFLEXIVE_PROPERTY: {
                l = this.noSatCost;
                break;
            }
            case GET_INVERSES: {
                l = this.noSatCost;
                break;
            }
            case GET_INSTANCES: {
                l = this.instanceRetrievalCost;
                break;
            }
            case GET_DIRECT_INSTANCES: {
                l = this.instanceRetrievalCost + this.classificationCost;
                break;
            }
            case GET_TYPES: {
                l = this.classRetrievalCost;
                break;
            }
            case GET_DIRECT_TYPES: {
                l = this.getCost(KBOperation.GET_TYPES);
                break;
            }
            case GET_PROPERTY_VALUE: {
                l = this.noSatCost;
                break;
            }
            case IS_SAME_AS: {
                l = this.oneSatCost;
                break;
            }
            case GET_SAMES: {
                l = this.oneSatCost;
                break;
            }
            case IS_DIFFERENT_FROM: {
                l = this.oneSatCost;
                break;
            }
            case GET_DIFFERENTS: {
                l = this.instanceRetrievalCost;
                break;
            }
            case GET_OBJECT_PROPERTIES: 
            case GET_DATATYPE_PROPERTIES: {
                l = this.noSatCost;
                break;
            }
            case GET_FUNCTIONAL_PROPERTIES: 
            case GET_INVERSE_FUNCTIONAL_PROPERTIES: 
            case GET_TRANSITIVE_PROPERTIES: 
            case GET_SYMMETRIC_PROPERTIES: 
            case GET_ASYMMETRIC_PROPERTIES: 
            case GET_REFLEXIVE_PROPERTIES: 
            case GET_IRREFLEXIVE_PROPERTIES: 
            case GET_DOMAINS: 
            case GET_RANGES: {
                l = this.noSatCost;
                break;
            }
            case GET_SUB_OR_SUPERCLASSES: 
            case GET_DIRECT_SUB_OR_SUPERCLASSES: 
            case GET_EQUIVALENT_CLASSES: {
                l = this.classificationCost;
                break;
            }
            case GET_DISJOINT_CLASSES: 
            case GET_COMPLEMENT_CLASSES: {
                l = this.classificationCost;
                break;
            }
            case GET_SUB_OR_SUPERPROPERTIES: 
            case GET_DIRECT_SUB_OR_SUPERPROPERTIES: 
            case GET_EQUIVALENT_PROPERTIES: {
                l = this.noSatCost;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown KB Operation type : " + (Object)((Object)kBOperation));
            }
        }
        return l;
    }
}

