/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.MultiMapUtils;
import com.clarkparsia.pellet.utils.TermFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.impl.BinaryTBox;
import org.mindswap.pellet.tbox.impl.PrimitiveTBox;
import org.mindswap.pellet.tbox.impl.UnaryTBox;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.BinarySet;
import org.mindswap.pellet.utils.iterator.IteratorUtils;
import org.mindswap.pellet.utils.iterator.MultiIterator;
import org.mindswap.pellet.utils.iterator.MultiListIterator;

public class TBoxImpl
implements TBox {
    public static final Logger log = Logger.getLogger(TBoxImpl.class.getName());
    protected static final Map<ATermAppl, String> FACETS = new HashMap<ATermAppl, String>();
    private static final Set<Set<ATermAppl>> SINGLE_EMPTY_SET;
    protected KnowledgeBase kb;
    protected Set<ATermAppl> classes = CollectionUtils.makeIdentitySet();
    private Set<ATermAppl> allClasses;
    private Map<ATermAppl, Set<Set<ATermAppl>>> tboxAxioms = CollectionUtils.makeIdentityMap();
    private Map<ATermAppl, Set<ATermAppl>> reverseExplain = CollectionUtils.makeIdentityMap();
    private Set<ATermAppl> tboxAssertedAxioms = CollectionUtils.makeIdentitySet();
    private Set<ATermAppl> absorbedAxioms = CollectionUtils.makeSet();
    private PrimitiveTBox primitiveTbox;
    private UnaryTBox unaryTbox;
    private BinaryTBox binaryTbox;
    private Absorption[] absorptions = new Absorption[]{new BinaryAbsorption(true), new DeterministicUnaryAbsorption(), new SimplifyAbsorption(), new OneOfAbsorption(), new HasValueAbsorption(), new RuleAbsorption(), new BinaryAbsorption(false), new ExistentialAbsorption(), new UnaryAbsorption(), new UnfoldAbsorption(), new DomainAbsorption(), new GeneralAbsorption()};
    private int freshConceptCount = 0;

    public TBoxImpl(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        this.primitiveTbox = new PrimitiveTBox();
        this.unaryTbox = new UnaryTBox();
        this.binaryTbox = new BinaryTBox();
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    @Override
    public Set<ATermAppl> getAllClasses() {
        if (this.allClasses == null) {
            this.allClasses = new HashSet<ATermAppl>(this.classes);
            this.allClasses.add(ATermUtils.TOP);
            this.allClasses.add(ATermUtils.BOTTOM);
        }
        return this.allClasses;
    }

    @Override
    public Set<Set<ATermAppl>> getAxiomExplanations(ATermAppl aTermAppl) {
        return this.tboxAxioms.get(aTermAppl);
    }

    @Override
    public Set<ATermAppl> getAxiomExplanation(ATermAppl aTermAppl) {
        Set<Set<ATermAppl>> set = this.tboxAxioms.get(aTermAppl);
        if (set == null || set.isEmpty()) {
            log.warning("No explanation for " + aTermAppl);
            return Collections.emptySet();
        }
        Iterator<Set<ATermAppl>> iterator = set.iterator();
        if (iterator.hasNext()) {
            Set<ATermAppl> set2 = iterator.next();
            return set2;
        }
        return Collections.emptySet();
    }

    protected boolean addAxiomExplanation(ATermAppl aTermAppl, Set<ATermAppl> set) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Add Axiom: " + ATermUtils.toString(aTermAppl) + " Explanation: " + set);
        }
        boolean bl = false;
        bl = !PelletOptions.USE_TRACING ? this.tboxAxioms.put(aTermAppl, SINGLE_EMPTY_SET) == null : MultiMapUtils.add(this.tboxAxioms, aTermAppl, set);
        if (bl) {
            for (ATermAppl aTermAppl2 : set) {
                if (aTermAppl.equals(aTermAppl2)) continue;
                MultiMapUtils.add(this.reverseExplain, aTermAppl2, aTermAppl);
            }
        }
        return bl;
    }

    private static List<ATermAppl> normalizeDisjointAxiom(ATermAppl ... aTermApplArray) {
        List<ATermAppl> list = CollectionUtils.makeList();
        for (int i = 0; i < aTermApplArray.length - 1; ++i) {
            ATermAppl aTermAppl = aTermApplArray[i];
            ATermAppl aTermAppl2 = ATermUtils.makeNot((ATerm)aTermAppl);
            for (int j = i + 1; j < aTermApplArray.length; ++j) {
                ATermAppl aTermAppl3 = aTermApplArray[j];
                ATermAppl aTermAppl4 = ATermUtils.makeNot((ATerm)aTermAppl3);
                list.add(ATermUtils.makeSub((ATerm)aTermAppl, (ATerm)aTermAppl4));
                if (!ATermUtils.isPrimitive(aTermAppl3)) continue;
                list.add(ATermUtils.makeSub((ATerm)aTermAppl3, (ATerm)aTermAppl2));
            }
        }
        return list;
    }

    @Override
    public boolean addAxiom(ATermAppl aTermAppl) {
        ATermAppl[] aTermApplArray;
        ATermAppl aTermAppl2;
        Set<ATermAppl> set;
        this.tboxAssertedAxioms.add(aTermAppl);
        List<ATermAppl> list = null;
        Set<Object> set2 = set = PelletOptions.USE_TRACING ? Collections.singleton(aTermAppl) : Collections.emptySet();
        if (aTermAppl.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            list = Collections.singletonList(aTermAppl);
        } else if (aTermAppl.getAFun().equals(ATermUtils.SUBFUN)) {
            list = Collections.singletonList(aTermAppl);
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            aTermApplArray = (ATermAppl[])aTermAppl.getArgument(1);
            list = TBoxImpl.normalizeDisjointAxiom(aTermAppl2, aTermApplArray);
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            aTermAppl2 = (ATermList)aTermAppl.getArgument(0);
            aTermApplArray = ATermUtils.toArray((ATermList)aTermAppl2);
            list = TBoxImpl.normalizeDisjointAxiom(aTermApplArray);
        } else {
            log.warning("Not a valid TBox axiom: " + aTermAppl);
            return false;
        }
        boolean bl = false;
        for (ATermAppl aTermAppl3 : list) {
            bl |= this.addAxiom(aTermAppl3, set, false);
        }
        return bl;
    }

    protected boolean addAxiom(ATermAppl aTermAppl, Set<ATermAppl> set, boolean bl) {
        boolean bl2 = this.addAxiomExplanation(aTermAppl, set);
        if (bl2 || bl) {
            if (aTermAppl.getAFun().equals(ATermUtils.EQCLASSFUN)) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
                ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
                boolean bl3 = false;
                if (ATermUtils.isPrimitive(aTermAppl2) && !this.unaryTbox.unfold(aTermAppl2).hasNext() && !this.binaryTbox.unfold(aTermAppl2).hasNext()) {
                    bl3 = this.primitiveTbox.add(aTermAppl2, aTermAppl3, set);
                }
                if (!bl3 && ATermUtils.isPrimitive(aTermAppl3) && !this.unaryTbox.unfold(aTermAppl3).hasNext() && !this.binaryTbox.unfold(aTermAppl3).hasNext()) {
                    bl3 = this.primitiveTbox.add(aTermAppl3, aTermAppl2, set);
                }
                if (!bl3) {
                    this.absorbSubClass(aTermAppl2, aTermAppl3, set);
                    this.absorbSubClass(aTermAppl3, aTermAppl2, set);
                }
            } else if (aTermAppl.getAFun().equals(ATermUtils.SUBFUN)) {
                ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(0);
                ATermAppl aTermAppl5 = (ATermAppl)aTermAppl.getArgument(1);
                this.absorbSubClass(aTermAppl4, aTermAppl5, set);
            }
        }
        return bl2;
    }

    private void absorbSubClass(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Absorb: subClassOf(" + ATermUtils.toString(aTermAppl) + ", " + ATermUtils.toString(aTermAppl2) + ")");
        }
        Set<ATermAppl> set2 = CollectionUtils.makeSet();
        set2.add(ATermUtils.nnf(aTermAppl));
        set2.add(ATermUtils.nnf(ATermUtils.negate(aTermAppl2)));
        this.absorbAxiom(set2, CollectionUtils.makeSet(set));
    }

    private void absorbAxiom(Set<ATermAppl> set, Set<ATermAppl> set2) {
        if (set.size() == 1) {
            this.unaryTbox.add(TermFactory.TOP, TermFactory.not(set.iterator().next()), set2);
            return;
        }
        for (Absorption absorption : this.absorptions) {
            if (!absorption.absorb(set, set2)) continue;
            return;
        }
        throw new InternalReasonerException("Absorption failed");
    }

    protected ATermAppl disjunction(Set<ATermAppl> set) {
        return TermFactory.not(TermFactory.and(set.toArray(new ATermAppl[set.size()])));
    }

    private ATermAppl freshConcept() {
        return TermFactory.term("_A" + ++this.freshConceptCount + "_");
    }

    @Override
    public boolean removeAxiom(ATermAppl aTermAppl) {
        return this.removeAxiom(aTermAppl, aTermAppl);
    }

    @Override
    public boolean removeAxiom(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (!PelletOptions.USE_TRACING) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot remove axioms when PelletOptions.USE_TRACING is false");
            }
            return false;
        }
        if (this.absorbedAxioms.contains(aTermAppl)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot remove axioms that have been absorbed outside TBox");
            }
            return false;
        }
        this.tboxAssertedAxioms.remove(aTermAppl);
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        boolean bl = this.removeExplanation(aTermAppl, aTermAppl2, hashSet);
        for (ATermAppl aTermAppl3 : hashSet) {
            Set<Set<ATermAppl>> set = this.tboxAxioms.get(aTermAppl3);
            if (set == null) continue;
            Iterator<Set<ATermAppl>> iterator = set.iterator();
            this.addAxiom(aTermAppl3, iterator.next(), true);
            while (iterator.hasNext()) {
                this.addAxiomExplanation(aTermAppl3, iterator.next());
            }
        }
        return bl;
    }

    private boolean removeExplanation(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        Set<ATermAppl> set22;
        boolean bl = false;
        if (!PelletOptions.USE_TRACING) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot remove axioms when PelletOptions.USE_TRACING is false");
            }
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Removing " + aTermAppl2);
        }
        MultiMapUtils.remove(this.reverseExplain, aTermAppl2, aTermAppl);
        Set<Set<ATermAppl>> set3 = this.tboxAxioms.get(aTermAppl);
        HashSet<Set<ATermAppl>> hashSet = new HashSet<Set<ATermAppl>>();
        if (set3 != null) {
            for (Set<ATermAppl> set22 : set3) {
                if (!set22.contains(aTermAppl2)) {
                    hashSet.add(set22);
                    continue;
                }
                set.addAll(set22);
                set.remove(aTermAppl2);
            }
        }
        if (!hashSet.isEmpty()) {
            this.tboxAxioms.put(aTermAppl, hashSet);
            return true;
        }
        bl |= this.tboxAxioms.remove(aTermAppl) != null;
        AFun aFun = aTermAppl.getAFun();
        if (aFun.equals(ATermUtils.SUBFUN) || aFun.equals(ATermUtils.EQCLASSFUN)) {
            // empty if block
        }
        if ((set22 = this.reverseExplain.remove(aTermAppl)) != null) {
            for (ATermAppl aTermAppl3 : set22) {
                if (aTermAppl3.equals(aTermAppl)) continue;
                bl |= this.removeExplanation(aTermAppl3, aTermAppl, set);
            }
        }
        return bl;
    }

    @Override
    public Collection<ATermAppl> getAxioms() {
        return this.tboxAxioms.keySet();
    }

    @Override
    public Collection<ATermAppl> getAssertedAxioms() {
        return this.tboxAssertedAxioms;
    }

    public boolean containsAxiom(ATermAppl aTermAppl) {
        return this.tboxAxioms.containsKey(aTermAppl);
    }

    public void print() {
        try {
            this.print(System.out);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.print(stringBuilder);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public void print(Appendable appendable) throws IOException {
        this.primitiveTbox.print(appendable);
        this.unaryTbox.print(appendable);
        this.binaryTbox.print(appendable);
        appendable.append("Explain: [\n");
        for (ATermAppl aTermAppl : this.tboxAxioms.keySet()) {
            appendable.append(ATermUtils.toString(aTermAppl));
            appendable.append(" -> ");
            appendable.append(this.tboxAxioms.get(aTermAppl).toString());
            appendable.append("\n");
        }
        appendable.append("]\nReverseExplain: [\n");
        for (ATermAppl aTermAppl : this.reverseExplain.keySet()) {
            appendable.append(ATermUtils.toString(aTermAppl));
            appendable.append(" -> ");
            appendable.append(this.reverseExplain.get(aTermAppl).toString());
            appendable.append("\n");
        }
        appendable.append("]\n");
    }

    @Override
    public boolean addClass(ATermAppl aTermAppl) {
        boolean bl = this.classes.add(aTermAppl);
        if (bl) {
            this.allClasses = null;
        }
        return bl;
    }

    @Override
    public Set<ATermAppl> getClasses() {
        return this.classes;
    }

    @Override
    public Collection<ATermAppl> getAxioms(ATermAppl aTermAppl) {
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        return arrayList;
    }

    @Override
    public Iterator<Unfolding> unfold(ATermAppl aTermAppl) {
        if (ATermUtils.isPrimitive(aTermAppl)) {
            MultiIterator<Unfolding> multiIterator = new MultiIterator<Unfolding>(this.primitiveTbox.unfold(aTermAppl));
            multiIterator.append(this.unaryTbox.unfold(aTermAppl));
            multiIterator.append(this.binaryTbox.unfold(aTermAppl));
            return multiIterator;
        }
        if (ATermUtils.isNot(aTermAppl)) {
            return this.primitiveTbox.unfold(aTermAppl);
        }
        return IteratorUtils.emptyIterator();
    }

    @Override
    public boolean isPrimitive(ATermAppl aTermAppl) {
        return ATermUtils.isPrimitive(aTermAppl) && !this.primitiveTbox.contains(aTermAppl);
    }

    @Override
    public void prepare() {
    }

    static {
        FACETS.put(Facet.XSD.MIN_INCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#greaterThanOrEqual");
        FACETS.put(Facet.XSD.MIN_EXCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#greaterThan");
        FACETS.put(Facet.XSD.MAX_INCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#lessThanOrEqual");
        FACETS.put(Facet.XSD.MAX_EXCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#lessThan");
        SINGLE_EMPTY_SET = Collections.singleton(Collections.emptySet());
    }

    private class GeneralAbsorption
    implements Absorption {
        private GeneralAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> set, Set<ATermAppl> set2) {
            ATermAppl aTermAppl = TBoxImpl.this.disjunction(set);
            TBoxImpl.this.unaryTbox.add(TermFactory.TOP, aTermAppl, set2);
            return true;
        }
    }

    private class DomainAbsorption
    implements Absorption {
        private DomainAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> set, Set<ATermAppl> set2) {
            for (ATermAppl aTermAppl : set) {
                ATermAppl aTermAppl2;
                Role role;
                if (!ATermUtils.isSomeValues(aTermAppl) || (role = TBoxImpl.this.kb.getRole((ATerm)(aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0)))) == null || role.hasComplexSubRole()) continue;
                ATermAppl aTermAppl3 = TBoxImpl.this.disjunction(set);
                TBoxImpl.this.kb.addDomain((ATerm)aTermAppl2, aTermAppl3, set2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Add dom: " + ATermUtils.toString(aTermAppl2) + " " + ATermUtils.toString(aTermAppl3));
                }
                TBoxImpl.this.absorbedAxioms.addAll(set2);
                return true;
            }
            return false;
        }
    }

    private class UnaryAbsorption
    extends AbstractUnaryAbsorption {
        private UnaryAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> set, Set<ATermAppl> set2) {
            for (ATermAppl aTermAppl : set) {
                if (!this.absorbIntoTerm(aTermAppl, set, set2)) continue;
                return true;
            }
            return false;
        }
    }

    private class DeterministicUnaryAbsorption
    extends AbstractUnaryAbsorption {
        private DeterministicUnaryAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> set, Set<ATermAppl> set2) {
            if (set.size() != 2) {
                return false;
            }
            Iterator<ATermAppl> iterator = set.iterator();
            ATermAppl aTermAppl = iterator.next();
            if (this.absorbIntoTerm(aTermAppl, set, set2)) {
                return true;
            }
            ATermAppl aTermAppl2 = iterator.next();
            return this.absorbIntoTerm(aTermAppl2, set, set2);
        }
    }

    private abstract class AbstractUnaryAbsorption
    implements Absorption {
        private AbstractUnaryAbsorption() {
        }

        protected boolean absorbIntoTerm(ATermAppl aTermAppl, Set<ATermAppl> set, Set<ATermAppl> set2) {
            if (TBoxImpl.this.isPrimitive(aTermAppl) && !TBoxImpl.this.primitiveTbox.contains(aTermAppl)) {
                set.remove(aTermAppl);
                ATermAppl aTermAppl2 = TBoxImpl.this.disjunction(set);
                TBoxImpl.this.unaryTbox.add(aTermAppl, aTermAppl2, set2);
                return true;
            }
            return false;
        }
    }

    private class UnfoldAbsorption
    implements Absorption {
        private UnfoldAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> set, Set<ATermAppl> set2) {
            for (ATermAppl aTermAppl : set) {
                Unfolding unfolding = TBoxImpl.this.primitiveTbox.getDefinition(aTermAppl);
                if (unfolding == null) continue;
                ATermAppl aTermAppl2 = unfolding.getResult();
                set.remove(aTermAppl);
                set.add(ATermUtils.nnf(aTermAppl2));
                TBoxImpl.this.absorbAxiom(set, set2);
                return true;
            }
            return false;
        }
    }

    private class ExistentialAbsorption
    implements Absorption {
        private ExistentialAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> set, Set<ATermAppl> set2) {
            for (ATermAppl aTermAppl : set) {
                if (!ATermUtils.isSomeValues(aTermAppl)) continue;
                ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
                ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
                if (!TBoxImpl.this.kb.isObjectProperty((ATerm)aTermAppl2)) continue;
                set.remove(aTermAppl);
                if (set.size() == 1 && ATermUtils.isNegatedPrimitive(aTermAppl3) && ATermUtils.isNegatedPrimitive(set.iterator().next())) {
                    set.add(aTermAppl);
                    return false;
                }
                ATermAppl aTermAppl4 = TBoxImpl.this.freshConcept();
                set.add(aTermAppl4);
                TBoxImpl.this.absorbAxiom(set, set2);
                Set set3 = CollectionUtils.makeIdentitySet();
                set3.add(ATermUtils.nnf(aTermAppl3));
                set3.add(TermFactory.some(TermFactory.inv(aTermAppl2), TermFactory.not(aTermAppl4)));
                TBoxImpl.this.absorbAxiom(set3, set2);
                return true;
            }
            return false;
        }
    }

    private class BinaryAbsorption
    implements Absorption {
        private boolean deterministic = false;

        BinaryAbsorption(boolean bl) {
            this.deterministic = bl;
        }

        @Override
        public boolean absorb(Set<ATermAppl> set, Set<ATermAppl> set2) {
            ATermAppl aTermAppl2;
            if (!PelletOptions.USE_BINARY_ABSORPTION) {
                return false;
            }
            if (this.deterministic && set.size() > 3) {
                return false;
            }
            Set set3 = CollectionUtils.makeIdentitySet();
            Set set4 = CollectionUtils.makeIdentitySet();
            for (ATermAppl aTermAppl2 : set) {
                if (!TBoxImpl.this.isPrimitive(aTermAppl2)) continue;
                if (!TBoxImpl.this.primitiveTbox.contains(aTermAppl2)) {
                    set3.add(aTermAppl2);
                    set4.add(aTermAppl2);
                }
                if (!TBoxImpl.this.binaryTbox.contains(aTermAppl2)) continue;
                set3.add(aTermAppl2);
            }
            if (set3.isEmpty()) {
                return false;
            }
            ATermAppl aTermAppl3 = (ATermAppl)set3.iterator().next();
            set4.remove(aTermAppl3);
            if (set4.isEmpty()) {
                return false;
            }
            aTermAppl2 = (ATermAppl)set4.iterator().next();
            BinarySet<ATermAppl> binarySet = BinarySet.create(aTermAppl3, aTermAppl2);
            Unfolding unfolding = TBoxImpl.this.binaryTbox.unfold(binarySet);
            set.remove(aTermAppl3);
            set.remove(aTermAppl2);
            if (set.size() == 0) {
                TBoxImpl.this.binaryTbox.add(binarySet, TermFactory.BOTTOM, set2);
            } else if (set.size() == 1) {
                TBoxImpl.this.binaryTbox.add(binarySet, ATermUtils.negate(set.iterator().next()), set2);
            } else {
                ATermAppl aTermAppl4 = null;
                if (unfolding == null) {
                    aTermAppl4 = TBoxImpl.this.freshConcept();
                    TBoxImpl.this.binaryTbox.add(binarySet, aTermAppl4, set2);
                } else {
                    aTermAppl4 = unfolding.getResult();
                }
                set.add(aTermAppl4);
                TBoxImpl.this.absorbAxiom(set, set2);
            }
            return true;
        }
    }

    private class RuleAbsorption
    implements Absorption {
        private RuleAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> set, Set<ATermAppl> set2) {
            Object object2;
            if (!PelletOptions.USE_RULE_ABSORPTION) {
                return false;
            }
            int n = 0;
            int n2 = 0;
            ATermAppl aTermAppl = null;
            for (ATermAppl aTermAppl2 : set) {
                if (ATermUtils.isPrimitive(aTermAppl2) && !TBoxImpl.this.primitiveTbox.contains(aTermAppl2)) {
                    ++n2;
                    continue;
                }
                if (ATermUtils.isSomeValues(aTermAppl2)) {
                    ++n;
                    continue;
                }
                if (!ATermUtils.isNot(aTermAppl2)) continue;
                aTermAppl = aTermAppl2;
            }
            if (aTermAppl == null || n == 0 && n2 < 2) {
                return false;
            }
            set.remove(aTermAppl);
            AtomIVariable atomIVariable = new AtomIVariable("var");
            int n3 = 0;
            ArrayList<RuleAtom> arrayList = new ArrayList<RuleAtom>();
            for (Object object2 : set) {
                n3 = this.processClass(atomIVariable, (ATermAppl)object2, (List<RuleAtom>)arrayList, n3);
            }
            ArrayList arrayList2 = new ArrayList();
            this.processClass(atomIVariable, ATermUtils.negate(aTermAppl), arrayList2, 1);
            object2 = new Rule(arrayList2, arrayList);
            TBoxImpl.this.kb.addRule((Rule)object2);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Add rule: " + object2);
            }
            return true;
        }

        protected int processClass(AtomIObject atomIObject, ATermAppl aTermAppl, List<RuleAtom> list, int n) {
            AFun aFun = aTermAppl.getAFun();
            if (aFun.equals(ATermUtils.ANDFUN)) {
                ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
                while (!aTermList.isEmpty()) {
                    ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
                    n = this.processClass(atomIObject, aTermAppl2, list, n);
                    aTermList = aTermList.getNext();
                }
            } else if (aFun.equals(ATermUtils.SOMEFUN)) {
                ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(0);
                ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(1);
                if (aTermAppl4.getAFun().equals(ATermUtils.VALUEFUN)) {
                    ATermAppl aTermAppl5 = (ATermAppl)aTermAppl4.getArgument(0);
                    if (TBoxImpl.this.kb.isDatatypeProperty((ATerm)aTermAppl3)) {
                        AtomDConstant atomDConstant = new AtomDConstant(aTermAppl5);
                        DatavaluedPropertyAtom datavaluedPropertyAtom = new DatavaluedPropertyAtom(aTermAppl3, atomIObject, atomDConstant);
                        list.add(datavaluedPropertyAtom);
                    } else {
                        AtomIConstant atomIConstant = new AtomIConstant(aTermAppl5);
                        IndividualPropertyAtom individualPropertyAtom = new IndividualPropertyAtom(aTermAppl3, atomIObject, atomIConstant);
                        list.add(individualPropertyAtom);
                    }
                } else {
                    ++n;
                    if (TBoxImpl.this.kb.isDatatypeProperty((ATerm)aTermAppl3)) {
                        AtomDVariable atomDVariable = new AtomDVariable("var" + n);
                        DatavaluedPropertyAtom datavaluedPropertyAtom = new DatavaluedPropertyAtom(aTermAppl3, atomIObject, atomDVariable);
                        list.add(datavaluedPropertyAtom);
                        this.processDatatype(atomDVariable, aTermAppl4, list);
                    } else {
                        AtomIVariable atomIVariable = new AtomIVariable("var" + n);
                        IndividualPropertyAtom individualPropertyAtom = new IndividualPropertyAtom(aTermAppl3, atomIObject, atomIVariable);
                        list.add(individualPropertyAtom);
                        n = this.processClass(atomIVariable, aTermAppl4, list, n);
                    }
                }
            } else if (!aTermAppl.equals(ATermUtils.TOP)) {
                list.add(new ClassAtom(aTermAppl, atomIObject));
            }
            return n;
        }

        protected void processDatatype(AtomDObject atomDObject, ATermAppl aTermAppl, List<RuleAtom> list) {
            AFun aFun = aTermAppl.getAFun();
            if (aFun.equals(ATermUtils.ANDFUN)) {
                ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
                while (!aTermList.isEmpty()) {
                    ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
                    this.processDatatype(atomDObject, aTermAppl2, list);
                    aTermList = aTermList.getNext();
                }
            } else if (aFun.equals(ATermUtils.RESTRDATATYPEFUN)) {
                ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(0);
                list.add(new DataRangeAtom(aTermAppl3, atomDObject));
                ATermList aTermList = (ATermList)aTermAppl.getArgument(1);
                while (!aTermList.isEmpty()) {
                    ATermAppl aTermAppl4 = (ATermAppl)aTermList.getFirst();
                    ATermAppl aTermAppl5 = (ATermAppl)aTermAppl4.getArgument(0);
                    String string = FACETS.get(aTermAppl5);
                    if (string == null) {
                        list.add(new DataRangeAtom(aTermAppl, atomDObject));
                        return;
                    }
                    ATermAppl aTermAppl6 = (ATermAppl)aTermAppl4.getArgument(1);
                    list.add(new BuiltInAtom(string, atomDObject, new AtomDConstant(aTermAppl6)));
                    aTermList = aTermList.getNext();
                }
            } else {
                list.add(new DataRangeAtom(aTermAppl, atomDObject));
            }
        }
    }

    private class HasValueAbsorption
    implements Absorption {
        private HasValueAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> set, Set<ATermAppl> set2) {
            if (!PelletOptions.USE_HASVALUE_ABSORPTION) {
                return false;
            }
            Iterator<ATermAppl> iterator = set.iterator();
            while (iterator.hasNext()) {
                ATermAppl aTermAppl;
                ATermAppl aTermAppl2 = iterator.next();
                if (!ATermUtils.isHasValue(aTermAppl2) || !TBoxImpl.this.kb.isObjectProperty((ATerm)(aTermAppl = (ATermAppl)aTermAppl2.getArgument(0)))) continue;
                iterator.remove();
                ATermAppl aTermAppl3 = TBoxImpl.this.disjunction(set);
                ATermAppl aTermAppl4 = (ATermAppl)aTermAppl2.getArgument(1);
                ATermAppl aTermAppl5 = (ATermAppl)aTermAppl4.getArgument(0);
                ATermAppl aTermAppl6 = TBoxImpl.this.kb.getProperty((ATerm)aTermAppl).getInverse().getName();
                ATermAppl aTermAppl7 = ATermUtils.makeAllValues((ATerm)aTermAppl6, (ATerm)aTermAppl3);
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Absorb into " + ATermUtils.toString(aTermAppl5) + " with inverse of " + ATermUtils.toString(aTermAppl) + " for " + ATermUtils.toString(aTermAppl3));
                }
                TBoxImpl.this.absorbedAxioms.addAll(set2);
                TBoxImpl.this.kb.addIndividual(aTermAppl5);
                TBoxImpl.this.kb.addType(aTermAppl5, aTermAppl7, new DependencySet(set2));
                return true;
            }
            return false;
        }
    }

    private class OneOfAbsorption
    implements Absorption {
        private OneOfAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> set, Set<ATermAppl> set2) {
            if (!PelletOptions.USE_NOMINAL_ABSORPTION) {
                return false;
            }
            for (ATermAppl aTermAppl : set) {
                Iterator<ATermAppl> iterator = this.getNominals(aTermAppl);
                if (!iterator.hasNext()) continue;
                set.remove(aTermAppl);
                ATermAppl aTermAppl2 = TBoxImpl.this.disjunction(set);
                this.absorbOneOf(iterator, aTermAppl2, set2);
                return true;
            }
            return false;
        }

        public Iterator<ATermAppl> getNominals(ATermAppl aTermAppl) {
            if (ATermUtils.isOneOf(aTermAppl)) {
                ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
                return new MultiListIterator(aTermList);
            }
            if (ATermUtils.isNominal(aTermAppl)) {
                return IteratorUtils.singletonIterator(aTermAppl);
            }
            return IteratorUtils.emptyIterator();
        }

        private void absorbOneOf(Iterator<ATermAppl> iterator, ATermAppl aTermAppl, Set<ATermAppl> set) {
            if (PelletOptions.USE_PSEUDO_NOMINALS) {
                if (log.isLoggable(Level.WARNING)) {
                    log.warning("Ignoring axiom involving nominals: " + set);
                }
                return;
            }
            TBoxImpl.this.absorbedAxioms.addAll(set);
            DependencySet dependencySet = new DependencySet(set);
            while (iterator.hasNext()) {
                ATermAppl aTermAppl2 = iterator.next();
                ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(0);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Absorb nominals: " + ATermUtils.toString(aTermAppl) + " " + aTermAppl3);
                }
                TBoxImpl.this.kb.addIndividual(aTermAppl3);
                TBoxImpl.this.kb.addType(aTermAppl3, aTermAppl, dependencySet);
            }
        }
    }

    private class SimplifyAbsorption
    implements Absorption {
        private SimplifyAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> set, Set<ATermAppl> set2) {
            Iterator<ATermAppl> iterator = set.iterator();
            while (iterator.hasNext()) {
                ATermAppl aTermAppl = iterator.next();
                if (ATermUtils.isAnd(aTermAppl)) {
                    iterator.remove();
                    ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
                    while (!aTermList.isEmpty()) {
                        set.add((ATermAppl)aTermList.getFirst());
                        aTermList = aTermList.getNext();
                    }
                    TBoxImpl.this.absorbAxiom(set, set2);
                    return true;
                }
                if (!ATermUtils.isOr(aTermAppl)) continue;
                iterator.remove();
                ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
                while (!aTermList.isEmpty()) {
                    Set<ATermAppl> set3 = CollectionUtils.makeSet(set);
                    set3.add((ATermAppl)aTermList.getFirst());
                    TBoxImpl.this.absorbAxiom(set3, set2);
                    aTermList = aTermList.getNext();
                }
                return true;
            }
            return false;
        }
    }

    private static interface Absorption {
        public boolean absorb(Set<ATermAppl> var1, Set<ATermAppl> var2);
    }
}

