/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.IndividualBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.utils.ATermUtils;

public class MaxBranch
extends IndividualBranch {
    private List<NodeMerge> mergePairs;
    private Role r;
    private int n;
    private ATermAppl qualification;
    private DependencySet[] prevDS;

    public MaxBranch(ABox aBox, CompletionStrategy completionStrategy, Individual individual, Role role, int n, ATermAppl aTermAppl, List<NodeMerge> list, DependencySet dependencySet) {
        super(aBox, completionStrategy, individual, dependencySet, list.size());
        this.r = role;
        this.n = n;
        this.mergePairs = list;
        this.qualification = aTermAppl;
        this.prevDS = new DependencySet[list.size()];
    }

    @Override
    public IndividualBranch copyTo(ABox aBox) {
        Individual individual = aBox.getIndividual((ATerm)this.ind.getName());
        MaxBranch maxBranch = new MaxBranch(aBox, null, individual, this.r, this.n, this.qualification, this.mergePairs, this.getTermDepends());
        maxBranch.setAnonCount(this.getAnonCount());
        maxBranch.setNodeCount(this.nodeCount);
        maxBranch.setBranch(this.branch);
        maxBranch.setStrategy(this.strategy);
        maxBranch.setTryNext(this.tryNext);
        maxBranch.prevDS = new DependencySet[this.prevDS.length];
        System.arraycopy(this.prevDS, 0, maxBranch.prevDS, 0, this.getTryNext());
        return maxBranch;
    }

    @Override
    protected void tryBranch() {
        Object object;
        this.abox.incrementBranch();
        ATermAppl aTermAppl = ATermUtils.makeMax((ATerm)this.r.getName(), this.n, (ATerm)this.qualification);
        aTermAppl = ATermUtils.normalize(aTermAppl);
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            object = new QueueElement(this.ind, aTermAppl);
            this.abox.getCompletionQueue().add((QueueElement)object, NodeSelector.MAX_NUMBER);
            this.abox.getCompletionQueue().add((QueueElement)object, NodeSelector.CHOOSE);
        }
        object = this.getTermDepends();
        while (this.getTryNext() < this.getTryCount()) {
            int n;
            Object object2;
            Object object3;
            Object object4;
            Node node;
            Object object5;
            this.abox.getKB().timers.mainTimer.check();
            if (PelletOptions.USE_SEMANTIC_BRANCHING) {
                for (int i = 0; i < this.getTryNext(); ++i) {
                    object5 = this.mergePairs.get(i);
                    node = this.abox.getNode((ATerm)((NodeMerge)object5).getSource()).getSame();
                    object4 = this.abox.getNode((ATerm)((NodeMerge)object5).getTarget()).getSame();
                    node.setDifferent((Node)object4, this.prevDS[i]);
                }
            }
            NodeMerge nodeMerge = this.mergePairs.get(this.getTryNext());
            object5 = this.abox.getNode((ATerm)nodeMerge.getSource()).getSame();
            node = this.abox.getNode((ATerm)nodeMerge.getTarget()).getSame();
            if (log.isLoggable(Level.FINE)) {
                log.fine("MAX : (" + (this.getTryNext() + 1) + "/" + this.mergePairs.size() + ") at branch (" + this.getBranch() + ") to  " + this.ind + " for prop " + this.r + " qualification " + this.qualification + " merge " + object5 + " -> " + node + " " + object);
            }
            object = ((DependencySet)object).union(new DependencySet(this.getBranch()), this.abox.doExplanation());
            object4 = this.ind.getRNeighborEdges(this.r);
            boolean bl = false;
            boolean bl2 = false;
            Iterator<Edge> iterator = ((EdgeList)object4).iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = object3.getNeighbor(this.ind);
                if (object2.equals(object5)) {
                    object = ((DependencySet)object).union(object3.getDepends(), this.abox.doExplanation());
                    bl = true;
                    continue;
                }
                if (!object2.equals(node)) continue;
                object = ((DependencySet)object).union(object3.getDepends(), this.abox.doExplanation());
                bl2 = true;
            }
            if (!bl || !bl2) {
                throw new InternalReasonerException("An error occurred related to the max cardinality restriction about " + this.r);
            }
            object = ((DependencySet)object).union(((Node)object5).getDepends((ATerm)this.qualification), this.abox.doExplanation());
            object = ((DependencySet)object).union(node.getDepends((ATerm)this.qualification), this.abox.doExplanation());
            for (n = this.abox.getBranches().size() - 2; n >= 0 && (object3 = this.abox.getBranches().get(n)) instanceof MaxBranch; --n) {
                object2 = (MaxBranch)object3;
                if (!((MaxBranch)object2).ind.equals(this.ind) || !((MaxBranch)object2).r.equals(this.r) || !((MaxBranch)object2).qualification.equals(this.qualification)) break;
                ((DependencySet)object).add(((Branch)object2).getBranch());
            }
            this.strategy.mergeTo((Node)object5, node, (DependencySet)object);
            n = this.abox.isClosed() ? 1 : 0;
            if (n != 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("CLASH: Branch " + this.getBranch() + " " + this.abox.getClash() + "!");
                }
                if (!((DependencySet)(object3 = this.abox.getClash().getDepends())).contains(this.getBranch())) {
                    return;
                }
            } else {
                return;
            }
            this.strategy.restore(this);
            this.abox.incrementBranch();
            this.setLastClash((DependencySet)object3);
            ++this.tryNext;
        }
        object = this.getCombinedClash();
        if (!PelletOptions.USE_INCREMENTAL_DELETION) {
            ((DependencySet)object).remove(this.getBranch());
        }
        if (this.abox.doExplanation()) {
            this.abox.setClash(Clash.maxCardinality(this.ind, (DependencySet)object, this.r.getName(), this.n));
        } else {
            this.abox.setClash(Clash.maxCardinality(this.ind, (DependencySet)object));
        }
    }

    @Override
    public void setLastClash(DependencySet dependencySet) {
        super.setLastClash(dependencySet);
        if (this.getTryNext() >= 0) {
            this.prevDS[this.getTryNext()] = dependencySet;
        }
    }

    @Override
    public String toString() {
        if (this.getTryNext() < this.mergePairs.size()) {
            return "Branch " + this.getBranch() + " max rule on " + this.ind + " merged  " + this.mergePairs.get(this.getTryNext());
        }
        return "Branch " + this.getBranch() + " max rule on " + this.ind + " exhausted merge possibilities";
    }

    @Override
    public void shiftTryNext(int n) {
        NodeMerge nodeMerge = this.mergePairs.remove(n);
        this.mergePairs.add(nodeMerge);
        for (int i = n; i < this.mergePairs.size(); ++i) {
            this.prevDS[i] = this.prevDS[i + 1];
        }
        this.prevDS[this.mergePairs.size() - 1] = null;
        this.setTryNext(this.getTryNext() - 1);
    }
}

