/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.HashSet;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.ATermUtils;

public class DisjunctionBranch
extends Branch {
    protected Node node;
    protected ATermAppl disjunction;
    private ATermAppl[] disj;
    protected DependencySet[] prevDS;
    protected int[] order;

    public DisjunctionBranch(ABox aBox, CompletionStrategy completionStrategy, Node node, ATermAppl aTermAppl, DependencySet dependencySet, ATermAppl[] aTermApplArray) {
        super(aBox, completionStrategy, dependencySet, aTermApplArray.length);
        this.node = node;
        this.disjunction = aTermAppl;
        this.setDisj(aTermApplArray);
        this.prevDS = new DependencySet[aTermApplArray.length];
        this.order = new int[aTermApplArray.length];
        for (int i = 0; i < aTermApplArray.length; ++i) {
            this.order[i] = i;
        }
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    protected String getDebugMsg() {
        return "DISJ: Branch (" + this.getBranch() + ") try (" + (this.getTryNext() + 1) + "/" + this.getTryCount() + ") " + this.node + " " + ATermUtils.toString(this.disj[this.getTryNext()]) + " " + ATermUtils.toString(this.disjunction);
    }

    @Override
    public DisjunctionBranch copyTo(ABox aBox) {
        Node node = aBox.getNode((ATerm)this.node.getName());
        DisjunctionBranch disjunctionBranch = new DisjunctionBranch(aBox, null, node, this.disjunction, this.getTermDepends(), this.disj);
        disjunctionBranch.setAnonCount(this.anonCount);
        disjunctionBranch.setNodeCount(this.nodeCount);
        disjunctionBranch.setBranch(this.branch);
        disjunctionBranch.setStrategy(this.strategy);
        disjunctionBranch.setTryNext(this.tryNext);
        disjunctionBranch.prevDS = new DependencySet[this.disj.length];
        System.arraycopy(this.prevDS, 0, disjunctionBranch.prevDS, 0, this.disj.length);
        disjunctionBranch.order = new int[this.disj.length];
        System.arraycopy(this.order, 0, disjunctionBranch.order, 0, this.disj.length);
        return disjunctionBranch;
    }

    private int preferredDisjunct() {
        if (this.disj.length != 2) {
            return -1;
        }
        if (ATermUtils.isPrimitive(this.disj[0]) && ATermUtils.isAllValues(this.disj[1]) && ATermUtils.isNot((ATermAppl)this.disj[1].getArgument(1))) {
            return 1;
        }
        if (ATermUtils.isPrimitive(this.disj[1]) && ATermUtils.isAllValues(this.disj[0]) && ATermUtils.isNot((ATermAppl)this.disj[0].getArgument(1))) {
            return 0;
        }
        return -1;
    }

    @Override
    public void setLastClash(DependencySet dependencySet) {
        super.setLastClash(dependencySet);
        if (this.getTryNext() >= 0) {
            this.prevDS[this.getTryNext()] = dependencySet;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void tryBranch() {
        int n;
        this.abox.incrementBranch();
        int[] nArray = null;
        if (PelletOptions.USE_DISJUNCT_SORTING) {
            int n2;
            int n3;
            nArray = this.abox.getDisjBranchStats().get(this.disjunction);
            if (nArray == null) {
                n3 = this.preferredDisjunct();
                nArray = new int[this.disj.length];
                for (n2 = 0; n2 < this.disj.length; ++n2) {
                    nArray[n2] = n2 != n3 ? 0 : Integer.MIN_VALUE;
                }
                this.abox.getDisjBranchStats().put(this.disjunction, nArray);
            }
            if (this.getTryNext() > 0) {
                int n4 = this.order[this.getTryNext() - 1];
                nArray[n4] = nArray[n4] + 1;
            }
            if (nArray != null) {
                n3 = this.getTryNext();
                n2 = nArray[this.getTryNext()];
                for (n = this.getTryNext() + 1; n < nArray.length; ++n) {
                    boolean bl;
                    boolean bl2 = bl = nArray[n] < n2;
                    if (!bl) continue;
                    n3 = n;
                    n2 = nArray[n];
                }
                if (n3 != this.getTryNext()) {
                    ATermAppl aTermAppl = this.disj[n3];
                    this.disj[n3] = this.disj[this.getTryNext()];
                    this.disj[this.getTryNext()] = aTermAppl;
                    this.order[n3] = this.getTryNext();
                    this.order[this.getTryNext()] = n3;
                }
            }
        }
        Node node = this.node.getSame();
        while (this.getTryNext() < this.getTryCount()) {
            Clash clash;
            DependencySet dependencySet;
            ATermAppl aTermAppl = this.disj[this.getTryNext()];
            if (PelletOptions.USE_SEMANTIC_BRANCHING) {
                for (n = 0; n < this.getTryNext(); ++n) {
                    this.strategy.addType(node, ATermUtils.negate(this.disj[n]), this.prevDS[n]);
                }
            }
            DependencySet dependencySet2 = null;
            if (this.getTryNext() == this.getTryCount() - 1 && !PelletOptions.SATURATE_TABLEAU) {
                dependencySet2 = this.getTermDepends();
                for (int i = 0; i < this.getTryNext(); ++i) {
                    dependencySet2 = dependencySet2.union(this.prevDS[i], this.abox.doExplanation());
                }
                if (PelletOptions.USE_INCREMENTAL_DELETION) {
                    dependencySet2.setExplain(this.getTermDepends().getExplain());
                } else {
                    dependencySet2.remove(this.getBranch());
                }
            } else if (PelletOptions.USE_INCREMENTAL_DELETION) {
                dependencySet2 = this.getTermDepends().union(new DependencySet(this.getBranch()), this.abox.doExplanation());
            } else {
                dependencySet2 = new DependencySet(this.getBranch());
                HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
                hashSet.addAll(this.getTermDepends().getExplain());
                dependencySet2.setExplain(hashSet);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getDebugMsg());
            }
            ATermAppl aTermAppl2 = ATermUtils.negate(aTermAppl);
            DependencySet dependencySet3 = dependencySet = PelletOptions.SATURATE_TABLEAU ? null : node.getDepends((ATerm)aTermAppl2);
            if (dependencySet == null) {
                this.strategy.addType(node, aTermAppl, dependencySet2);
                if (this.abox.isClosed()) {
                    dependencySet = this.abox.getClash().getDepends();
                }
            } else {
                dependencySet = dependencySet.union(dependencySet2, this.abox.doExplanation());
            }
            if (dependencySet == null) return;
            if (log.isLoggable(Level.FINE)) {
                clash = this.abox.isClosed() ? this.abox.getClash() : Clash.atomic(node, dependencySet, aTermAppl);
                log.fine("CLASH: Branch " + this.getBranch() + " " + clash + "!" + " " + dependencySet.getExplain());
            }
            if (PelletOptions.USE_DISJUNCT_SORTING) {
                if (nArray == null) {
                    nArray = new int[this.disj.length];
                    for (int i = 0; i < this.disj.length; ++i) {
                        nArray[i] = 0;
                    }
                    this.abox.getDisjBranchStats().put(this.disjunction, nArray);
                }
                int n5 = this.order[this.getTryNext()];
                nArray[n5] = nArray[n5] + 1;
            }
            if (this.getTryNext() < this.getTryCount() - 1 && dependencySet.contains(this.getBranch())) {
                if (this.abox.isClosed()) {
                    if (node.isLiteral()) {
                        this.abox.setClash(null);
                        node.restore(this.branch);
                    } else {
                        this.strategy.restoreLocal((Individual)node, this);
                        this.abox.incrementBranch();
                    }
                }
            } else {
                if (this.abox.doExplanation()) {
                    clash = ATermUtils.isNot(aTermAppl2) ? aTermAppl : aTermAppl2;
                    this.abox.setClash(Clash.atomic(node, dependencySet.union(dependencySet2, this.abox.doExplanation()), (ATermAppl)clash));
                } else {
                    this.abox.setClash(Clash.atomic(node, dependencySet.union(dependencySet2, this.abox.doExplanation())));
                }
                if (!PelletOptions.USE_INCREMENTAL_DELETION) return;
                this.abox.getKB().getDependencyIndex().addCloseBranchDependency(this, this.abox.getClash().getDepends());
                return;
            }
            this.setLastClash(dependencySet);
            ++this.tryNext;
        }
        throw new InternalReasonerException("This exception should not be thrown!");
    }

    @Override
    public void shiftTryNext(int n) {
        ATermAppl aTermAppl = this.disj[n];
        if (PelletOptions.USE_SEMANTIC_BRANCHING) {
            // empty if block
        }
        for (int i = n; i < this.disj.length - 1; ++i) {
            this.disj[i] = this.disj[i + 1];
            this.prevDS[i] = this.prevDS[i + 1];
            this.order[i] = this.order[i];
        }
        this.disj[this.disj.length - 1] = aTermAppl;
        this.prevDS[this.disj.length - 1] = null;
        this.order[this.disj.length - 1] = this.disj.length - 1;
        this.setTryNext(this.getTryNext() - 1);
    }

    public void printLong() {
        for (int i = 0; i < this.disj.length; ++i) {
            System.out.println("Disj[" + i + "] " + this.disj[i]);
            System.out.println("prevDS[" + i + "] " + this.prevDS[i]);
            System.out.println("order[" + i + "] " + this.order[i]);
        }
        System.out.println("trynext: " + this.getTryNext());
    }

    public void setDisj(ATermAppl[] aTermApplArray) {
        this.disj = aTermApplArray;
    }

    public ATermAppl getDisjunct(int n) {
        return this.disj[n];
    }
}

