/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.FileUtils;

public abstract class KBLoader {
    public static final Logger log = Logger.getLogger(KBLoader.class.getName());
    protected String inputFormat;

    public abstract void clear();

    public KnowledgeBase createKB(String ... stringArray) {
        this.clear();
        this.parse(stringArray);
        this.load();
        return this.getKB();
    }

    public abstract KnowledgeBase getKB();

    public abstract void load();

    public void parse(String ... stringArray) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Parsing (" + stringArray.length + ") files");
        }
        for (String string : stringArray) {
            String string2 = FileUtils.getFileURI(string);
            this.parseFile(string2);
        }
        if (log.isLoggable(Level.INFO)) {
            log.fine("Parsing done.");
        }
    }

    public abstract void setIgnoreImports(boolean var1);

    protected abstract void parseFile(String var1);

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

