/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.util;

import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;

public class OptimizedDirectedMultigraph<V>
extends SimpleDirectedWeightedGraph<V, DefaultWeightedEdge> {
    private static final long serialVersionUID = 1L;
    private static final String NON_POSITIVE_MULTIPLICITY = "Non-positive multiplicity is not allowed";

    public OptimizedDirectedMultigraph() {
        super(DefaultWeightedEdge.class);
    }

    public DefaultWeightedEdge addEdge(V v, V v2) {
        return this.addEdge(v, v2, 1);
    }

    public DefaultWeightedEdge addEdge(V v, V v2, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(NON_POSITIVE_MULTIPLICITY);
        }
        DefaultWeightedEdge defaultWeightedEdge = (DefaultWeightedEdge)this.getEdge(v, v2);
        if (defaultWeightedEdge == null) {
            defaultWeightedEdge = (DefaultWeightedEdge)super.addEdge(v, v2);
            this.setEdgeWeight(defaultWeightedEdge, n);
        } else {
            double d = this.getEdgeWeight(defaultWeightedEdge);
            this.setEdgeWeight(defaultWeightedEdge, d + (double)n);
        }
        return defaultWeightedEdge;
    }

    public int getEdgeMultiplicity(DefaultWeightedEdge defaultWeightedEdge) {
        return (int)this.getEdgeWeight(defaultWeightedEdge);
    }
}

