/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.ontology;

import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.format.SimpleLintFormat;
import com.clarkparsia.pellint.lintpattern.ontology.ClassCollector;
import com.clarkparsia.pellint.lintpattern.ontology.ExistentialClassCollector;
import com.clarkparsia.pellint.lintpattern.ontology.NamedClassCollector;
import com.clarkparsia.pellint.lintpattern.ontology.OntologyLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFactory;
import com.clarkparsia.pellint.model.Severity;
import com.clarkparsia.pellint.util.OptimizedDirectedMultigraph;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.alg.TransitiveClosure;
import org.jgrapht.ext.DOTExporter;
import org.jgrapht.ext.StringNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.DirectedSubgraph;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class ExistentialExplosionPattern
implements OntologyLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new SimpleLintFormat();
    private int m_MaxTreeSize = 10000;
    private List<Lint> m_AccumulatedLints;
    private LintFactory m_LintFactory;

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + " (MaxTreeSize = " + this.m_MaxTreeSize + ")";
    }

    @Override
    public String getDescription() {
        return "Concepts/Individuals are involved in a large some/min/exact value restrictions tree/loop - maximum recommended number of generated nodes is " + this.m_MaxTreeSize;
    }

    @Override
    public boolean isFixable() {
        return false;
    }

    @Override
    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void setMaxTreeSize(int n) {
        this.m_MaxTreeSize = n;
    }

    @Override
    public List<Lint> match(OWLOntology oWLOntology) {
        this.m_AccumulatedLints = new ArrayList<Lint>();
        this.m_LintFactory = new LintFactory(this, oWLOntology);
        OptimizedDirectedMultigraph<OWLClass> optimizedDirectedMultigraph = ExistentialExplosionPattern.extractGraphFromSubsumptionAxiomsWith(oWLOntology, new ExistentialClassCollector());
        this.estimateTreeSizesForCycles(optimizedDirectedMultigraph);
        if (!this.m_AccumulatedLints.isEmpty()) {
            return this.m_AccumulatedLints;
        }
        OptimizedDirectedMultigraph<OWLClass> optimizedDirectedMultigraph2 = ExistentialExplosionPattern.extractGraphFromSubsumptionAxiomsWith(oWLOntology, new NamedClassCollector());
        TransitiveClosure.INSTANCE.closeSimpleDirectedGraph(optimizedDirectedMultigraph2);
        ExistentialExplosionPattern.addInheritedEdges(optimizedDirectedMultigraph, optimizedDirectedMultigraph2);
        this.estimateTreeSizesForCycles(optimizedDirectedMultigraph);
        if (!this.m_AccumulatedLints.isEmpty()) {
            return this.m_AccumulatedLints;
        }
        Map<OWLClass, Integer> map = ExistentialExplosionPattern.countIndividuals(oWLOntology);
        this.estimateTreeSizesForCyclesWithIndividuals(optimizedDirectedMultigraph, optimizedDirectedMultigraph2, map);
        if (!this.m_AccumulatedLints.isEmpty()) {
            return this.m_AccumulatedLints;
        }
        this.removeCyclesAndEstimateTreeSizesWithIndividuals(optimizedDirectedMultigraph, map);
        return this.m_AccumulatedLints;
    }

    private static <V, E> void printGraph(Graph<V, E> graph) {
        DOTExporter dOTExporter = new DOTExporter((VertexNameProvider)new StringNameProvider(), null, null);
        dOTExporter.export((Writer)new BufferedWriter(new PrintWriter(System.out)), graph);
    }

    private static OptimizedDirectedMultigraph<OWLClass> extractGraphFromSubsumptionAxiomsWith(OWLOntology oWLOntology, ClassCollector classCollector) {
        OptimizedDirectedMultigraph<OWLClass> optimizedDirectedMultigraph = new OptimizedDirectedMultigraph<OWLClass>();
        for (OWLSubClassOfAxiom oWLSubClassOfAxiom : oWLOntology.getAxioms(AxiomType.SUBCLASS_OF)) {
            ExistentialExplosionPattern.processSubsumption(optimizedDirectedMultigraph, oWLSubClassOfAxiom.getSubClass(), oWLSubClassOfAxiom.getSuperClass(), classCollector);
        }
        for (OWLSubClassOfAxiom oWLSubClassOfAxiom : oWLOntology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
            Set set = oWLSubClassOfAxiom.getClassExpressions();
            for (OWLClassExpression oWLClassExpression : set) {
                for (OWLClassExpression oWLClassExpression2 : set) {
                    if (oWLClassExpression == oWLClassExpression2) continue;
                    ExistentialExplosionPattern.processSubsumption(optimizedDirectedMultigraph, oWLClassExpression, oWLClassExpression2, classCollector);
                }
            }
        }
        return optimizedDirectedMultigraph;
    }

    private static void processSubsumption(OptimizedDirectedMultigraph<OWLClass> optimizedDirectedMultigraph, OWLClassExpression oWLClassExpression, OWLClassExpression oWLClassExpression2, ClassCollector classCollector) {
        if (oWLClassExpression.isAnonymous()) {
            return;
        }
        OWLClass oWLClass = oWLClassExpression.asOWLClass();
        classCollector.reset();
        oWLClassExpression2.accept((OWLClassExpressionVisitor)classCollector);
        for (OWLClass oWLClass2 : classCollector.getCollectedClasses()) {
            if (oWLClass.equals(oWLClass2)) continue;
            optimizedDirectedMultigraph.addVertex(oWLClass);
            optimizedDirectedMultigraph.addVertex(oWLClass2);
            optimizedDirectedMultigraph.addEdge(oWLClass, oWLClass2);
        }
    }

    private static void addInheritedEdges(OptimizedDirectedMultigraph<OWLClass> optimizedDirectedMultigraph, OptimizedDirectedMultigraph<OWLClass> optimizedDirectedMultigraph2) {
        for (OWLClass oWLClass : optimizedDirectedMultigraph2.vertexSet()) {
            if (!optimizedDirectedMultigraph.containsVertex(oWLClass)) continue;
            Set set = optimizedDirectedMultigraph.outgoingEdgesOf(oWLClass);
            for (DefaultWeightedEdge defaultWeightedEdge : optimizedDirectedMultigraph2.incomingEdgesOf(oWLClass)) {
                OWLClass oWLClass2 = (OWLClass)optimizedDirectedMultigraph2.getEdgeSource(defaultWeightedEdge);
                if (!optimizedDirectedMultigraph.containsVertex(oWLClass2)) continue;
                for (DefaultWeightedEdge defaultWeightedEdge2 : set) {
                    int n = optimizedDirectedMultigraph.getEdgeMultiplicity(defaultWeightedEdge2);
                    OWLClass oWLClass3 = (OWLClass)optimizedDirectedMultigraph.getEdgeTarget(defaultWeightedEdge2);
                    if (oWLClass2.equals(oWLClass3)) continue;
                    optimizedDirectedMultigraph.addEdge(oWLClass2, oWLClass3, n);
                }
            }
        }
    }

    private static Map<OWLClass, Integer> countIndividuals(OWLOntology oWLOntology) {
        HashMap<OWLClass, Integer> hashMap = new HashMap<OWLClass, Integer>();
        for (OWLClassAssertionAxiom oWLClassAssertionAxiom : oWLOntology.getAxioms(AxiomType.CLASS_ASSERTION)) {
            OWLClassExpression oWLClassExpression = oWLClassAssertionAxiom.getClassExpression();
            if (oWLClassExpression.isAnonymous()) continue;
            OWLClass oWLClass = oWLClassExpression.asOWLClass();
            Integer n = (Integer)hashMap.get(oWLClass);
            if (n == null) {
                n = 0;
            }
            hashMap.put(oWLClass, n + 1);
        }
        return hashMap;
    }

    private static int getMaxSizeOfCompleteGraphToIgnore(int n) {
        int n2 = 1;
        while (Math.pow(n2 - 1, n2) < (double)n) {
            ++n2;
        }
        return n2 - 1;
    }

    private void estimateTreeSizesForCycles(OptimizedDirectedMultigraph<OWLClass> optimizedDirectedMultigraph) {
        int n = ExistentialExplosionPattern.getMaxSizeOfCompleteGraphToIgnore(this.m_MaxTreeSize);
        StrongConnectivityInspector strongConnectivityInspector = new StrongConnectivityInspector(optimizedDirectedMultigraph);
        for (Set set : strongConnectivityInspector.stronglyConnectedSets()) {
            if (set.size() <= n) continue;
            DirectedSubgraph directedSubgraph = new DirectedSubgraph(optimizedDirectedMultigraph, set, null);
            double d = 1.0;
            for (OWLClass oWLClass : set) {
                d *= (double)directedSubgraph.outDegreeOf((Object)oWLClass);
            }
            if (!(d > (double)this.m_MaxTreeSize)) continue;
            Lint lint = this.m_LintFactory.make();
            lint.addAllParticipatingClasses(set);
            lint.setSeverity(new Severity(d));
            this.m_AccumulatedLints.add(lint);
        }
    }

    private void estimateTreeSizesForCyclesWithIndividuals(OptimizedDirectedMultigraph<OWLClass> optimizedDirectedMultigraph, OptimizedDirectedMultigraph<OWLClass> optimizedDirectedMultigraph2, Map<OWLClass, Integer> map) {
        StrongConnectivityInspector strongConnectivityInspector = new StrongConnectivityInspector(optimizedDirectedMultigraph);
        for (Set set : strongConnectivityInspector.stronglyConnectedSets()) {
            Object object;
            Object object222;
            if (set.size() <= 1) continue;
            DirectedSubgraph directedSubgraph = new DirectedSubgraph(optimizedDirectedMultigraph, set, null);
            double d = 1.0;
            for (Object object222 : set) {
                d *= (double)directedSubgraph.outDegreeOf(object222);
            }
            HashSet hashSet = new HashSet(set);
            object222 = set.iterator();
            while (object222.hasNext()) {
                object = (OWLClass)object222.next();
                if (!optimizedDirectedMultigraph2.containsVertex(object)) continue;
                for (DefaultWeightedEdge defaultWeightedEdge : optimizedDirectedMultigraph2.incomingEdgesOf(object)) {
                    hashSet.add(optimizedDirectedMultigraph2.getEdgeSource(defaultWeightedEdge));
                }
            }
            int n = 0;
            for (Map.Entry entry : map.entrySet()) {
                if (!hashSet.contains(entry.getKey())) continue;
                n += ((Integer)entry.getValue()).intValue();
            }
            if (!((d *= (double)n) > (double)this.m_MaxTreeSize)) continue;
            object = this.m_LintFactory.make();
            ((Lint)object).addAllParticipatingClasses(set);
            ((Lint)object).setSeverity(new Severity(d));
            this.m_AccumulatedLints.add((Lint)object);
        }
    }

    private void removeCyclesAndEstimateTreeSizesWithIndividuals(OptimizedDirectedMultigraph<OWLClass> optimizedDirectedMultigraph, Map<OWLClass, Integer> map) {
        Object object;
        Object object2;
        Double d;
        Double d2;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        CycleDetector cycleDetector = new CycleDetector(optimizedDirectedMultigraph);
        Set set = cycleDetector.findCycles();
        for (OWLClass oWLClass : set) {
            d2 = (Double)hashMap.get(oWLClass);
            if (d2 == null) {
                d2 = (double)optimizedDirectedMultigraph.outDegreeOf(oWLClass) + 1.0;
            }
            for (DefaultWeightedEdge object3 : optimizedDirectedMultigraph.incomingEdgesOf(oWLClass)) {
                int n = optimizedDirectedMultigraph.getEdgeMultiplicity(object3);
                OWLClass oWLClass2 = (OWLClass)optimizedDirectedMultigraph.getEdgeSource(object3);
                d = (Double)hashMap.get(oWLClass2);
                if (d == null) {
                    d = optimizedDirectedMultigraph.outDegreeOf(oWLClass2);
                }
                hashMap.put(oWLClass2, d + d2 * (double)n);
            }
        }
        optimizedDirectedMultigraph.removeAllVertices(set);
        if (!optimizedDirectedMultigraph.vertexSet().isEmpty()) {
            OWLClass oWLClass;
            object2 = new EdgeReversedGraph(optimizedDirectedMultigraph);
            oWLClass = new TopologicalOrderIterator((DirectedGraph)object2);
            while (oWLClass.hasNext()) {
                d2 = (OWLClass)oWLClass.next();
                object = (Double)hashMap.get(d2);
                if (object == null) {
                    object = 1.0;
                }
                for (DefaultWeightedEdge defaultWeightedEdge : optimizedDirectedMultigraph.outgoingEdgesOf(d2)) {
                    int n = optimizedDirectedMultigraph.getEdgeMultiplicity(defaultWeightedEdge);
                    d = (OWLClass)optimizedDirectedMultigraph.getEdgeTarget(defaultWeightedEdge);
                    Double d3 = (Double)hashMap.get(d);
                    if (d3 == null) {
                        d3 = 1.0;
                    }
                    object = (Double)object + d3 * (double)n;
                }
                hashMap.put(d2, object);
            }
        }
        object2 = new HashSet();
        double d4 = 0.0;
        for (Map.Entry entry : map.entrySet()) {
            OWLClass oWLClass = (OWLClass)entry.getKey();
            int n = (Integer)entry.getValue();
            d = (Double)hashMap.get(oWLClass);
            if (d == null) continue;
            double d5 = d * (double)n;
            d4 += d5;
            if (!(d5 > 0.0)) continue;
            object2.add(oWLClass);
        }
        if (d4 > (double)this.m_MaxTreeSize) {
            object = this.m_LintFactory.make();
            ((Lint)object).addAllParticipatingClasses((Collection<? extends OWLClass>)object2);
            ((Lint)object).setSeverity(new Severity(d4));
            this.m_AccumulatedLints.add((Lint)object);
        }
    }
}

