/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.sparqldl.model.Filter;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryParameters;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

public class QueryImpl
implements Query {
    private static final ATermAppl DEFAULT_NAME = TermFactory.term("query");
    private ATermAppl name = DEFAULT_NAME;
    private List<QueryAtom> allAtoms;
    private KnowledgeBase kb;
    private List<ATermAppl> resultVars;
    private Set<ATermAppl> allVars;
    private Set<ATermAppl> individualsAndLiterals;
    private boolean ground;
    private boolean distinct;
    private Filter filter;
    private QueryParameters parameters;
    private EnumMap<Query.VarType, Set<ATermAppl>> distVars;

    public QueryImpl(KnowledgeBase knowledgeBase, boolean bl) {
        this.kb = knowledgeBase;
        this.ground = true;
        this.allAtoms = new ArrayList<QueryAtom>();
        this.resultVars = new ArrayList<ATermAppl>();
        this.allVars = new HashSet<ATermAppl>();
        this.individualsAndLiterals = new HashSet<ATermAppl>();
        this.distVars = new EnumMap(Query.VarType.class);
        for (Query.VarType varType : Query.VarType.values()) {
            this.distVars.put(varType, new HashSet());
        }
        this.distinct = bl;
    }

    public QueryImpl(Query query) {
        this(query.getKB(), query.isDistinct());
        this.name = query.getName();
        this.parameters = query.getQueryParameters();
    }

    @Override
    public void add(QueryAtom queryAtom) {
        if (this.allAtoms.contains(queryAtom)) {
            return;
        }
        this.allAtoms.add(queryAtom);
        for (ATermAppl aTermAppl : queryAtom.getArguments()) {
            if (ATermUtils.isVar(aTermAppl)) {
                if (this.allVars.contains(aTermAppl)) continue;
                this.allVars.add(aTermAppl);
                continue;
            }
            if (!ATermUtils.isLiteral(aTermAppl) && !this.kb.isIndividual((ATerm)aTermAppl) || this.individualsAndLiterals.contains(aTermAppl)) continue;
            this.individualsAndLiterals.add(aTermAppl);
        }
        this.ground = this.ground && queryAtom.isGround();
    }

    @Override
    public Set<ATermAppl> getDistVarsForType(Query.VarType varType) {
        return this.distVars.get((Object)varType);
    }

    @Override
    public void addDistVar(ATermAppl aTermAppl, Query.VarType varType) {
        Set<ATermAppl> set = this.distVars.get((Object)varType);
        if (!set.contains(aTermAppl)) {
            set.add(aTermAppl);
        }
    }

    @Override
    public void addResultVar(ATermAppl aTermAppl) {
        this.resultVars.add(aTermAppl);
    }

    @Override
    public List<QueryAtom> getAtoms() {
        return Collections.unmodifiableList(this.allAtoms);
    }

    @Override
    public Set<ATermAppl> getConstants() {
        return Collections.unmodifiableSet(this.individualsAndLiterals);
    }

    @Override
    public Set<ATermAppl> getDistVars() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Query.VarType varType : Query.VarType.values()) {
            hashSet.addAll((Collection<ATermAppl>)this.distVars.get((Object)varType));
        }
        return hashSet;
    }

    @Override
    public Set<ATermAppl> getUndistVars() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(this.allVars);
        hashSet.removeAll(this.getDistVars());
        return hashSet;
    }

    @Override
    public List<ATermAppl> getResultVars() {
        return Collections.unmodifiableList(this.resultVars);
    }

    @Override
    public Set<ATermAppl> getVars() {
        return Collections.unmodifiableSet(this.allVars);
    }

    @Override
    public boolean isGround() {
        return this.ground;
    }

    @Override
    public KnowledgeBase getKB() {
        return this.kb;
    }

    @Override
    public void setKB(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    @Override
    public Query apply(ResultBinding resultBinding) {
        ArrayList<QueryAtom> arrayList = new ArrayList<QueryAtom>();
        for (QueryAtom object : this.getAtoms()) {
            arrayList.add(object.apply(resultBinding));
        }
        QueryImpl queryImpl = new QueryImpl(this);
        queryImpl.resultVars.addAll(this.resultVars);
        queryImpl.resultVars.removeAll(resultBinding.getAllVariables());
        for (Query.VarType varType : Query.VarType.values()) {
            for (ATermAppl aTermAppl : this.getDistVarsForType(varType)) {
                if (resultBinding.isBound(aTermAppl)) continue;
                queryImpl.addDistVar(aTermAppl, varType);
            }
        }
        for (QueryAtom queryAtom : arrayList) {
            queryImpl.add(queryAtom);
        }
        return queryImpl;
    }

    @Override
    public ATermAppl rollUpTo(ATermAppl aTermAppl, Collection<ATermAppl> collection, boolean bl) {
        if (this.getDistVarsForType(Query.VarType.LITERAL).contains(aTermAppl) && !this.getDistVarsForType(Query.VarType.INDIVIDUAL).contains(aTermAppl) && !this.individualsAndLiterals.contains(aTermAppl)) {
            throw new InternalReasonerException("Trying to roll up to the variable '" + aTermAppl + "' which is not distinguished and individual.");
        }
        ATermList aTermList = ATermUtils.EMPTY_LIST;
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        if (bl) {
            hashSet.addAll(this.getConstants());
        }
        List<QueryAtom> list = this.findAtoms(QueryPredicate.PropertyValue, null, null, aTermAppl);
        for (QueryAtom object2 : list) {
            aTermList = aTermList.append((ATerm)this.rollEdgeIn(QueryPredicate.PropertyValue, object2, hashSet, collection));
        }
        List<QueryAtom> list2 = this.findAtoms(QueryPredicate.PropertyValue, aTermAppl, null, null);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            QueryAtom queryAtom = (QueryAtom)iterator.next();
            aTermList = aTermList.append((ATerm)this.rollEdgeOut(QueryPredicate.PropertyValue, queryAtom, hashSet, collection));
        }
        aTermList = aTermList.concat(this.getClasses(aTermAppl));
        return ATermUtils.makeAnd(aTermList);
    }

    private ATermList getClasses(ATermAppl aTermAppl) {
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        for (QueryAtom queryAtom : this.findAtoms(QueryPredicate.Type, aTermAppl, null)) {
            ATermAppl aTermAppl2 = queryAtom.getArguments().get(1);
            if (ATermUtils.isVar(aTermAppl2)) {
                throw new InternalReasonerException("Variables as predicates are not supported yet");
            }
            arrayList.add(aTermAppl2);
        }
        if (!ATermUtils.isVar(aTermAppl)) {
            arrayList.add(ATermUtils.makeValue((ATerm)aTermAppl));
        }
        return ATermUtils.makeList(arrayList);
    }

    private ATermAppl rollEdgeOut(QueryPredicate queryPredicate, QueryAtom queryAtom, Set<ATermAppl> set, Collection<ATermAppl> collection) {
        switch (queryAtom.getPredicate()) {
            case PropertyValue: {
                QueryAtom queryAtom22;
                ATermAppl aTermAppl = queryAtom.getArguments().get(0);
                ATermAppl aTermAppl2 = queryAtom.getArguments().get(1);
                ATermAppl aTermAppl3 = queryAtom.getArguments().get(2);
                if (ATermUtils.isVar(aTermAppl2)) {
                    return ATermUtils.TOP;
                }
                set.add(aTermAppl);
                if (set.contains(aTermAppl3)) {
                    ATermList aTermList = this.getClasses(aTermAppl3);
                    if (aTermList.getLength() == 0) {
                        if (this.kb.isDatatypeProperty((ATerm)aTermAppl2)) {
                            return ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)ATermUtils.TOP);
                    }
                    return ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)ATermUtils.makeAnd(aTermList));
                }
                if (ATermUtils.isLiteral(aTermAppl3)) {
                    ATermAppl aTermAppl4 = ATermUtils.makeValue((ATerm)aTermAppl3);
                    return ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)aTermAppl4);
                }
                ATermList aTermList = this.getClasses(aTermAppl3);
                for (QueryAtom queryAtom22 : this._findAtoms(collection, queryPredicate, null, null, aTermAppl3)) {
                    if (queryAtom22.equals(queryAtom)) continue;
                    aTermList = aTermList.append((ATerm)this.rollEdgeIn(queryPredicate, queryAtom22, set, collection));
                }
                List<QueryAtom> list = this._findAtoms(collection, queryPredicate, aTermAppl3, null, null);
                if (aTermList.isEmpty()) {
                    if (list.size() == 0) {
                        if (this.kb.isDatatypeProperty((ATerm)aTermAppl2)) {
                            return ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)ATermUtils.TOP);
                    }
                    queryAtom22 = ATermUtils.EMPTY_LIST;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        QueryAtom queryAtom3 = (QueryAtom)iterator.next();
                        queryAtom22 = queryAtom22.append((ATerm)this.rollEdgeOut(queryPredicate, queryAtom3, set, collection));
                    }
                    return ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)ATermUtils.makeAnd((ATermList)queryAtom22));
                }
                if (list.size() == 0) {
                    return ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)ATermUtils.makeAnd(aTermList));
                }
                queryAtom22 = ATermUtils.EMPTY_LIST;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    QueryAtom queryAtom4 = (QueryAtom)iterator.next();
                    queryAtom22 = queryAtom22.append((ATerm)this.rollEdgeOut(queryPredicate, queryAtom4, set, collection));
                }
                for (int i = 0; i < aTermList.getLength(); ++i) {
                    queryAtom22 = queryAtom22.append(aTermList.elementAt(i));
                }
                return ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)ATermUtils.makeAnd((ATermList)queryAtom22));
            }
        }
        throw new RuntimeException("This atom cannot be included to rolling-up : " + queryAtom);
    }

    /*
     * WARNING - void declaration
     */
    private ATermAppl rollEdgeIn(QueryPredicate queryPredicate, QueryAtom queryAtom, Set<ATermAppl> set, Collection<ATermAppl> collection) {
        switch (queryAtom.getPredicate()) {
            case PropertyValue: {
                void var12_17;
                ATermList aTermList;
                ATermAppl aTermAppl = queryAtom.getArguments().get(0);
                ATermAppl aTermAppl2 = queryAtom.getArguments().get(1);
                ATermAppl aTermAppl3 = queryAtom.getArguments().get(2);
                ATermAppl aTermAppl4 = this.kb.getRBox().getRole((ATerm)aTermAppl2).getInverse().getName();
                if (ATermUtils.isVar(aTermAppl2)) {
                    throw new InternalReasonerException("Variables as predicates are not supported yet");
                }
                set.add(aTermAppl3);
                if (set.contains(aTermAppl)) {
                    ATermList aTermList2 = this.getClasses(aTermAppl);
                    if (aTermList2.getLength() == 0) {
                        if (this.kb.isDatatypeProperty((ATerm)aTermAppl4)) {
                            return ATermUtils.makeSomeValues((ATerm)aTermAppl4, (ATerm)ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues((ATerm)aTermAppl4, (ATerm)ATermUtils.TOP);
                    }
                    return ATermUtils.makeSomeValues((ATerm)aTermAppl4, (ATerm)ATermUtils.makeAnd(aTermList2));
                }
                ATermList aTermList3 = this.getClasses(aTermAppl);
                List<QueryAtom> list = this._findAtoms(collection, queryPredicate, null, null, aTermAppl);
                for (QueryAtom object : this._findAtoms(collection, queryPredicate, aTermAppl, null, null)) {
                    if (object.equals(queryAtom)) continue;
                    aTermList3 = aTermList3.append((ATerm)this.rollEdgeOut(queryPredicate, object, set, collection));
                }
                if (aTermList3.isEmpty()) {
                    if (list.isEmpty()) {
                        if (this.kb.isDatatypeProperty((ATerm)aTermAppl2)) {
                            return ATermUtils.makeSomeValues((ATerm)aTermAppl4, (ATerm)ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues((ATerm)aTermAppl4, (ATerm)ATermUtils.TOP);
                    }
                    aTermList = ATermUtils.EMPTY_LIST;
                    for (QueryAtom queryAtom2 : list) {
                        aTermList = aTermList.append((ATerm)this.rollEdgeIn(queryPredicate, queryAtom2, set, collection));
                    }
                    return ATermUtils.makeSomeValues((ATerm)aTermAppl4, (ATerm)ATermUtils.makeAnd(aTermList));
                }
                if (list.isEmpty()) {
                    return ATermUtils.makeSomeValues((ATerm)aTermAppl4, (ATerm)ATermUtils.makeAnd(aTermList3));
                }
                aTermList = ATermUtils.EMPTY_LIST;
                for (QueryAtom queryAtom3 : list) {
                    aTermList = aTermList.append((ATerm)this.rollEdgeIn(queryPredicate, queryAtom3, set, collection));
                }
                boolean bl = false;
                while (var12_17 < aTermList3.getLength()) {
                    aTermList = aTermList.append(aTermList3.elementAt((int)var12_17));
                    ++var12_17;
                }
                return ATermUtils.makeSomeValues((ATerm)aTermAppl4, (ATerm)ATermUtils.makeAnd(aTermList));
            }
        }
        throw new RuntimeException("This atom cannot be included to rolling-up : " + queryAtom);
    }

    private List<QueryAtom> _findAtoms(Collection<ATermAppl> collection, QueryPredicate queryPredicate, ATermAppl ... aTermApplArray) {
        ArrayList<QueryAtom> arrayList = new ArrayList<QueryAtom>();
        for (QueryAtom queryAtom : this.allAtoms) {
            if (!queryPredicate.equals((Object)queryAtom.getPredicate())) continue;
            int n = 0;
            boolean bl = true;
            for (ATermAppl aTermAppl : queryAtom.getArguments()) {
                ATermAppl aTermAppl2;
                if (((aTermAppl2 = aTermApplArray[n++]) == null || aTermAppl2 == aTermAppl) && !collection.contains(aTermAppl)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(queryAtom);
        }
        return arrayList;
    }

    @Override
    public List<QueryAtom> findAtoms(QueryPredicate queryPredicate, ATermAppl ... aTermApplArray) {
        return this._findAtoms(Collections.emptySet(), queryPredicate, aTermApplArray);
    }

    @Override
    public Query reorder(int[] nArray) {
        if (nArray.length != this.allAtoms.size()) {
            throw new InternalReasonerException("Ordering permutation must be of the same size as the query : " + nArray.length);
        }
        QueryImpl queryImpl = new QueryImpl(this);
        for (int i = 0; i < nArray.length; ++i) {
            queryImpl.allAtoms.add(this.allAtoms.get(nArray[i]));
        }
        queryImpl.allVars = this.allVars;
        queryImpl.distVars = this.distVars;
        queryImpl.individualsAndLiterals = this.individualsAndLiterals;
        queryImpl.resultVars = this.resultVars;
        queryImpl.ground = this.ground;
        return queryImpl;
    }

    @Override
    public void remove(QueryAtom queryAtom) {
        if (!this.allAtoms.contains(queryAtom)) {
            return;
        }
        this.allAtoms.remove(queryAtom);
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        boolean bl = true;
        for (QueryAtom object2 : this.allAtoms) {
            bl &= object2.isGround();
            hashSet.addAll(object2.getArguments());
        }
        this.ground = bl;
        HashSet<ATermAppl> hashSet2 = new HashSet<ATermAppl>(queryAtom.getArguments());
        hashSet2.removeAll(hashSet);
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            ATermAppl aTermAppl = (ATermAppl)iterator.next();
            this.allVars.remove(aTermAppl);
            for (Map.Entry<Query.VarType, Set<ATermAppl>> entry : this.distVars.entrySet()) {
                entry.getValue().remove(aTermAppl);
            }
            this.resultVars.remove(aTermAppl);
            this.individualsAndLiterals.remove(aTermAppl);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        Object object;
        int n;
        String string = bl ? "     " : " ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ATermUtils.toString(this.name) + "(");
        for (n = 0; n < this.resultVars.size(); ++n) {
            object = this.resultVars.get(n);
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ATermUtils.toString((ATermAppl)object));
        }
        stringBuffer.append(")");
        if (this.allAtoms.size() > 0) {
            stringBuffer.append(" :-");
            if (bl) {
                stringBuffer.append("\n");
            }
            for (n = 0; n < this.allAtoms.size(); ++n) {
                object = this.allAtoms.get(n);
                if (n > 0) {
                    stringBuffer.append(",");
                    if (bl) {
                        stringBuffer.append("\n");
                    }
                }
                stringBuffer.append(string);
                stringBuffer.append(object.toString());
            }
        }
        stringBuffer.append(".");
        if (bl) {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void setQueryParameters(QueryParameters queryParameters) {
        this.parameters = queryParameters;
    }

    @Override
    public QueryParameters getQueryParameters() {
        return this.parameters;
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public void setName(ATermAppl aTermAppl) {
        this.name = aTermAppl;
    }
}

