/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mindswap.pellet.utils.ATermUtils;

public class QueryAtomImpl
implements QueryAtom {
    protected final QueryPredicate predicate;
    protected final List<ATermAppl> arguments;
    protected boolean ground;

    public QueryAtomImpl(QueryPredicate queryPredicate, ATermAppl ... aTermApplArray) {
        this(queryPredicate, Arrays.asList(aTermApplArray));
    }

    public QueryAtomImpl(QueryPredicate queryPredicate, List<ATermAppl> list) {
        if (queryPredicate == null) {
            throw new RuntimeException("Predicate cannot be null.");
        }
        this.predicate = queryPredicate;
        this.arguments = list;
        this.ground = true;
        for (ATermAppl aTermAppl : list) {
            if (!ATermUtils.isVar(aTermAppl)) continue;
            this.ground = false;
            break;
        }
    }

    @Override
    public QueryPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public List<ATermAppl> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isGround() {
        return this.ground;
    }

    @Override
    public QueryAtom apply(ResultBinding resultBinding) {
        if (this.isGround()) {
            return this;
        }
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        for (ATermAppl aTermAppl : this.arguments) {
            if (resultBinding.isBound(aTermAppl)) {
                arrayList.add(resultBinding.getValue(aTermAppl));
                continue;
            }
            arrayList.add(aTermAppl);
        }
        return arrayList.isEmpty() ? this : new QueryAtomImpl(this.predicate, arrayList);
    }

    public int hashCode() {
        return 31 * this.predicate.hashCode() + this.arguments.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QueryAtomImpl queryAtomImpl = (QueryAtomImpl)object;
        return this.predicate.equals((Object)queryAtomImpl.predicate) && this.arguments.equals(queryAtomImpl.arguments);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.arguments.size(); ++i) {
            ATermAppl aTermAppl = this.arguments.get(i);
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ATermUtils.toString(aTermAppl));
        }
        return (Object)((Object)this.predicate) + "(" + stringBuffer.toString() + ")";
    }
}

