/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class MultiQueryResults
implements QueryResult {
    private final List<ATermAppl> resultVars;
    private final List<QueryResult> queryResults;
    private int size;

    public MultiQueryResults(List<ATermAppl> list, List<QueryResult> list2) {
        this.resultVars = list;
        this.queryResults = list2;
        this.size = 1;
        for (QueryResult queryResult : list2) {
            this.size *= queryResult.size();
        }
    }

    @Override
    public void add(ResultBinding resultBinding) {
        throw new UnsupportedOperationException("MultiQueryResults do not support addition!");
    }

    @Override
    public List<ATermAppl> getResultVars() {
        return this.resultVars;
    }

    @Override
    public boolean isDistinct() {
        for (QueryResult queryResult : this.queryResults) {
            if (queryResult.isDistinct()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<ResultBinding> iterator() {
        return new Iterator<ResultBinding>(){
            private List<Iterator<ResultBinding>> iterators = new ArrayList<Iterator<ResultBinding>>();
            private List<ResultBinding> bindings = new ArrayList<ResultBinding>();
            private boolean hasNext = this.init();

            private boolean init() {
                for (QueryResult queryResult : MultiQueryResults.this.queryResults) {
                    Iterator iterator = queryResult.iterator();
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    this.iterators.add(iterator);
                    this.bindings.add((ResultBinding)iterator.next());
                }
                return true;
            }

            private void findNext() {
                ListIterator<Iterator<ResultBinding>> listIterator = this.iterators.listIterator();
                for (int i = 0; i < this.iterators.size(); ++i) {
                    Iterator<ResultBinding> iterator = listIterator.next();
                    if (iterator.hasNext()) {
                        this.bindings.set(i, iterator.next());
                        return;
                    }
                    if (i == this.iterators.size() - 1) {
                        this.hasNext = false;
                        return;
                    }
                    iterator = ((QueryResult)MultiQueryResults.this.queryResults.get(i)).iterator();
                    listIterator.set(iterator);
                    this.bindings.set(i, iterator.next());
                }
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public ResultBinding next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ResultBindingImpl resultBindingImpl = new ResultBindingImpl();
                for (ResultBinding resultBinding : this.bindings) {
                    resultBindingImpl.setValues(resultBinding);
                }
                this.findNext();
                return resultBindingImpl;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }
}

