/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import com.clarkparsia.pellet.sparqldl.engine.QueryCost;
import com.clarkparsia.pellet.sparqldl.engine.QueryPlan;
import com.clarkparsia.pellet.sparqldl.engine.QuerySizeEstimator;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.SetUtils;

public class IncrementalQueryPlan
extends QueryPlan {
    private static final Logger log = Logger.getLogger(IncrementalQueryPlan.class.getName());
    public final Stack<Integer> explored;
    private final List<QueryAtom> atoms;
    private int size;
    private QueryCost cost;

    public IncrementalQueryPlan(Query query) {
        super(query);
        QuerySizeEstimator.computeSizeEstimate(query);
        this.explored = new Stack();
        this.atoms = query.getAtoms();
        this.size = this.atoms.size();
        this.cost = new QueryCost(query.getKB());
        this.reset();
    }

    @Override
    public QueryAtom next(ResultBinding resultBinding) {
        int n = -1;
        QueryAtom queryAtom = null;
        double d = Double.POSITIVE_INFINITY;
        block0: for (int i = 0; i < this.size; ++i) {
            if (this.explored.contains(i)) continue;
            QueryAtom queryAtom2 = this.atoms.get(i);
            QueryAtom queryAtom3 = queryAtom2.apply(resultBinding);
            if (queryAtom3.getPredicate().equals((Object)QueryPredicate.NotKnown) && !queryAtom3.isGround()) {
                for (int j = 0; j < this.atoms.size(); ++j) {
                    QueryAtom queryAtom4;
                    if (i == j || this.explored.contains(j) || !SetUtils.intersects((queryAtom4 = this.atoms.get(j)).getArguments(), queryAtom3.getArguments())) continue;
                    if (!log.isLoggable(Level.FINE)) continue block0;
                    log.fine("Unbound vars for not");
                    continue block0;
                }
            }
            double d2 = this.cost.estimate(queryAtom3);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Atom=" + queryAtom2 + ", cost=" + this.cost + ", best cost=" + d);
            }
            if (!(d2 <= d)) continue;
            d = d2;
            queryAtom = queryAtom3;
            n = i;
        }
        if (n == -1) {
            throw new InternalReasonerException("Cannot find a valid atom in " + this.atoms + " where explored=" + this.explored);
        }
        this.explored.add(n);
        if (log.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.explored.size(); ++i) {
                stringBuffer.append(" ");
            }
            String string = stringBuffer.toString() + queryAtom + " : " + d;
            log.finer(string);
        }
        return queryAtom;
    }

    @Override
    public boolean hasNext() {
        return this.explored.size() < this.size;
    }

    @Override
    public void back() {
        this.explored.pop();
    }

    @Override
    public void reset() {
        this.explored.clear();
    }
}

