/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.NumericComparisonVisitor;
import com.clarkparsia.pellet.rules.builtins.NumericFunction;
import com.clarkparsia.pellet.rules.builtins.NumericPromotion;
import com.clarkparsia.pellet.rules.builtins.NumericVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FunctionApplicationVisitor
implements NumericVisitor {
    NumericFunction function;
    Number result;

    public FunctionApplicationVisitor(NumericFunction numericFunction) {
        this(numericFunction, null);
    }

    public FunctionApplicationVisitor(NumericFunction numericFunction, Number number) {
        this.function = numericFunction;
        this.result = number;
    }

    public Number getResult() {
        return this.result;
    }

    private void testAndSetResult(Number number) {
        if (this.result == null) {
            this.result = number;
        } else {
            NumericComparisonVisitor numericComparisonVisitor = new NumericComparisonVisitor();
            NumericPromotion numericPromotion = new NumericPromotion();
            numericPromotion.promote(this.result, number);
            numericPromotion.accept(numericComparisonVisitor);
            this.result = numericComparisonVisitor.getComparison() == 0 ? number : null;
        }
    }

    @Override
    public void visit(BigDecimal[] bigDecimalArray) {
        this.testAndSetResult(this.function.apply(bigDecimalArray));
    }

    @Override
    public void visit(BigInteger[] bigIntegerArray) {
        this.testAndSetResult(this.function.apply(bigIntegerArray));
    }

    @Override
    public void visit(Double[] doubleArray) {
        this.testAndSetResult(this.function.apply(doubleArray));
    }

    @Override
    public void visit(Float[] floatArray) {
        this.testAndSetResult(this.function.apply(floatArray));
    }
}

