/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategy;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategyImpl;
import com.clarkparsia.pellet.rules.RuleAtomAsserter;
import com.clarkparsia.pellet.rules.RulesToATermTranslator;
import com.clarkparsia.pellet.rules.RulesToReteTranslator;
import com.clarkparsia.pellet.rules.TrivialSatisfactionHelpers;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.Interpreter;
import com.clarkparsia.pellet.rules.rete.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.RuleBranch;
import org.mindswap.pellet.tableau.completion.SROIQStrategy;

public class RuleStrategy
extends SROIQStrategy {
    private BindingGeneratorStrategy bindingStrategy;

    public RuleStrategy(ABox aBox) {
        super(aBox);
        this.bindingStrategy = new BindingGeneratorStrategyImpl(aBox);
    }

    public void applyRULERule() {
        for (Rule rule : this.abox.getKB().getRules()) {
            int n = 0;
            for (VariableBinding variableBinding : this.bindingStrategy.createGenerator(rule)) {
                ++n;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Binding: " + variableBinding);
                    log.fine("total:" + n);
                }
                if (this.abox.isClosed()) continue;
                this.createDisjunctionsFromBinding(variableBinding, rule);
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("total bindings:" + n);
            log.fine("branches:" + this.abox.getBranch());
        }
    }

    @Override
    public void complete(Expressivity expressivity) {
        Object object;
        Expressivity expressivity2 = this.abox.getKB().getExpressivity();
        this.initialize(expressivity2);
        if (!this.abox.ranRete && this.abox.rulesNotApplied) {
            Object object2;
            Object object3;
            object = new Interpreter(this.abox);
            RulesToReteTranslator rulesToReteTranslator = new RulesToReteTranslator(this.abox);
            Object object5 = new RulesToATermTranslator();
            for (Rule object42 : this.abox.getKB().getRules()) {
                object3 = rulesToReteTranslator.translateRule(object42);
                if (object3 == null) continue;
                object2 = this.abox.doExplanation() ? object42.getExplanation((RulesToATermTranslator)object5) : Collections.emptySet();
                ((Interpreter)object).rete.compile((com.clarkparsia.pellet.rules.rete.Rule)object3, (Set<ATermAppl>)object2);
            }
            ((Interpreter)object).rete.compileFacts(this.abox);
            Set<Fact> set = ((Interpreter)object).run();
            if (log.isLoggable(Level.FINE)) {
                log.fine(set.size() + " inferred fact(s)");
            }
            DependencySet dependencySet = DependencySet.INDEPENDENT;
            object3 = set.iterator();
            while (object3.hasNext()) {
                Node node;
                Object object4;
                Object object6;
                object2 = (Fact)object3.next();
                ATermAppl aTermAppl = (ATermAppl)((Tuple)object2).getElements().get(0);
                ATermAppl aTermAppl2 = (ATermAppl)((Tuple)object2).getElements().get(1);
                ATermAppl aTermAppl3 = (ATermAppl)((Tuple)object2).getElements().get(2);
                if (aTermAppl.equals(Compiler.TYPE)) {
                    object6 = this.abox.getIndividual((ATerm)aTermAppl2);
                    object4 = aTermAppl3;
                    ((Individual)object6).addType((ATermAppl)object4, dependencySet);
                    continue;
                }
                if (aTermAppl.equals(Compiler.SAME_AS)) {
                    object6 = this.abox.getIndividual((ATerm)aTermAppl2);
                    object4 = this.abox.getIndividual((ATerm)aTermAppl3);
                    ((Node)object6).setSame((Node)object4, DependencySet.INDEPENDENT);
                    continue;
                }
                if (aTermAppl.equals(Compiler.DIFF_FROM)) {
                    object6 = this.abox.getIndividual((ATerm)aTermAppl2);
                    object4 = this.abox.getIndividual((ATerm)aTermAppl3);
                    ((Node)object6).setDifferent((Node)object4, DependencySet.INDEPENDENT);
                    continue;
                }
                object6 = this.abox.getRole((ATerm)aTermAppl);
                object4 = this.abox.getIndividual((ATerm)aTermAppl2);
                if (object6 != null && ((Role)object6).isObjectRole()) {
                    node = this.abox.getIndividual((ATerm)aTermAppl3);
                } else if (object6 != null && ((Role)object6).isDatatypeRole()) {
                    node = this.abox.getLiteral((ATerm)aTermAppl3);
                    if (node == null) {
                        node = this.abox.addLiteral(aTermAppl3);
                    }
                } else {
                    log.warning("Ignoring non object or datatype role " + aTermAppl);
                    continue;
                }
                this.addEdge((Individual)object4, (Role)object6, node, dependencySet);
            }
            this.abox.ranRete = true;
        }
        while (!this.abox.isComplete()) {
            while (this.abox.isChanged() && !this.abox.isClosed()) {
                this.completionTimer.check();
                this.abox.setChanged(false);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.stats.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb");
                    this.abox.validate();
                    this.abox.printTree();
                }
                object = this.abox.getIndIterator();
                for (Object object5 : this.tableauRules) {
                    object5.apply((IndividualIterator)object);
                    if (!this.abox.isClosed()) continue;
                    break;
                }
                if (this.abox.isClosed() || !this.abox.rulesNotApplied) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Applying RULE rule at branch:" + this.abox.getBranch());
                }
                this.abox.rulesNotApplied = false;
                this.applyRULERule();
            }
            if (this.abox.isClosed()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            if (PelletOptions.SATURATE_TABLEAU) {
                object = null;
                for (int i = this.abox.getBranches().size() - 1; i >= 0; --i) {
                    object = this.abox.getBranches().get(i);
                    ((Branch)object).setTryNext(((Branch)object).getTryNext() + 1);
                    if (((Branch)object).getTryNext() < ((Branch)object).getTryCount()) {
                        this.restore((Branch)object);
                        System.out.println("restoring branch " + ((Branch)object).getBranch() + " tryNext = " + ((Branch)object).getTryNext() + " tryCount = " + ((Branch)object).getTryCount());
                        ((Branch)object).tryNext();
                        break;
                    }
                    System.out.println("removing branch " + ((Branch)object).getBranch());
                    this.abox.getBranches().remove(i);
                    object = null;
                }
                if (object != null) continue;
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
    }

    private boolean isDisjunct(RuleAtom ruleAtom) {
        return !(ruleAtom instanceof BuiltInAtom) && !(ruleAtom instanceof DataRangeAtom);
    }

    private void createDisjunctionsFromBinding(VariableBinding variableBinding, Rule rule) {
        TrivialSatisfactionHelpers trivialSatisfactionHelpers = new TrivialSatisfactionHelpers(this.abox);
        RuleAtomAsserter ruleAtomAsserter = new RuleAtomAsserter();
        ArrayList<RuleAtom> arrayList = new ArrayList<RuleAtom>();
        for (RuleAtom object2 : rule.getBody()) {
            if (!this.isDisjunct(object2)) continue;
            arrayList.add(object2);
        }
        int n = arrayList.size();
        for (RuleAtom ruleAtom : rule.getHead()) {
            if (!this.isDisjunct(ruleAtom) || trivialSatisfactionHelpers.isAtomTrue(ruleAtom, variableBinding) != null) continue;
            arrayList.add(ruleAtom);
        }
        if (arrayList.size() == n) {
            return;
        }
        RuleBranch ruleBranch = new RuleBranch(this.abox, this, ruleAtomAsserter, arrayList, variableBinding, n, DependencySet.INDEPENDENT);
        this.addBranch(ruleBranch);
        ruleBranch.tryNext();
    }

    @Override
    public void restoreLocal(Individual individual, Branch branch) {
        this.restore(branch);
    }
}

