/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.exceptions.InternalReasonerException;

public class DataRangeBindingHelper
implements BindingHelper {
    private static final Logger log = Logger.getLogger(DataRangeBindingHelper.class.getCanonicalName());
    private DatatypeReasoner dtReasoner;
    private DataRangeAtom atom;
    private boolean hasNext;

    public DataRangeBindingHelper(ABox aBox, DataRangeAtom dataRangeAtom) {
        this.dtReasoner = aBox.getDatatypeReasoner();
        this.atom = dataRangeAtom;
        this.hasNext = false;
    }

    public Collection<AtomVariable> getBindableVars(Collection<AtomVariable> collection) {
        return Collections.emptySet();
    }

    public Collection<AtomVariable> getPrerequisiteVars(Collection<AtomVariable> collection) {
        return VariableUtils.getVars(this.atom);
    }

    @Override
    public void rebind(VariableBinding variableBinding) {
        Literal literal = variableBinding.get((AtomDObject)this.atom.getArgument());
        if (literal == null) {
            throw new InternalReasonerException("DataRangeBindingHelper cannot generate bindings for " + this.atom);
        }
        try {
            this.hasNext = this.dtReasoner.isSatisfiable(Collections.singleton(this.atom.getPredicate()), literal.getValue());
        }
        catch (DatatypeReasonerException datatypeReasonerException) {
            String string = "Unexpected datatype reasoner exception: " + datatypeReasonerException.getMessage();
            log.severe(string);
            throw new InternalReasonerException(datatypeReasonerException);
        }
    }

    @Override
    public boolean selectNextBinding() {
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public void setCurrentBinding(VariableBinding variableBinding) {
    }

    public String toString() {
        return this.atom.toString();
    }
}

