/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.ATermAppl;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class RoleRestrictionCache {
    private Map<ATermAppl, ATermAppl> m_Domains = CollectionUtils.makeMap();
    private Map<ATermAppl, ATermAppl> m_Ranges = CollectionUtils.makeMap();

    public RoleRestrictionCache(RBox rBox) {
        this.prepareDomainsRanges(rBox);
    }

    private void prepareDomainsRanges(RBox rBox) {
        for (Role role : rBox.getRoles()) {
            Iterator<ATermAppl> iterator;
            Iterator<ATermAppl> iterator2 = rBox.getAssertedDomains(role);
            if (iterator2.hasNext()) {
                RoleRestrictionCache.addTo(this.m_Domains, role.getName(), IteratorUtils.toSet(iterator2));
            }
            if (!(iterator = rBox.getAssertedRanges(role)).hasNext()) continue;
            RoleRestrictionCache.addTo(this.m_Ranges, role.getName(), IteratorUtils.toSet(iterator));
        }
    }

    private static void addTo(Map<ATermAppl, ATermAppl> map, ATermAppl aTermAppl, Set<ATermAppl> set) {
        if (set.isEmpty()) {
            return;
        }
        ATermAppl aTermAppl2 = null;
        aTermAppl2 = set.size() == 1 ? set.iterator().next() : ATermUtils.makeAnd(ATermUtils.toSet(set));
        aTermAppl2 = ELSyntaxUtils.simplify(ATermUtils.nnf(aTermAppl2));
        map.put(aTermAppl, aTermAppl2);
    }

    public Map<ATermAppl, ATermAppl> getDomains() {
        return this.m_Domains;
    }

    public Map<ATermAppl, ATermAppl> getRanges() {
        return this.m_Ranges;
    }

    public ATermAppl getDomain(ATermAppl aTermAppl) {
        return this.m_Domains.get(aTermAppl);
    }

    public ATermAppl getRange(ATermAppl aTermAppl) {
        return this.m_Ranges.get(aTermAppl);
    }
}

