/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.ConceptInfo;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.el.ELTaxonomyBuilder;
import com.clarkparsia.pellet.el.RoleChainCache;
import com.clarkparsia.pellet.el.RoleRestrictionCache;
import com.clarkparsia.pellet.el.Trigger;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.taxonomy.CDOptimizedTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.POTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.PartialOrderComparator;
import org.mindswap.pellet.utils.PartialOrderRelation;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public class ELClassifier
extends CDOptimizedTaxonomyBuilder
implements TaxonomyBuilder {
    public static final Logger logger = Logger.getLogger(ELClassifier.class.getName());
    public final Timers timers = new Timers();
    public ConceptInfo TOP;
    public ConceptInfo BOTTOM;
    private boolean hasComplexRoles;
    private MultiValueMap<ConceptInfo, Trigger> queue;
    private Map<ATermAppl, ConceptInfo> concepts;
    private RoleChainCache roleChains;
    private RoleRestrictionCache roleRestrictions;
    private PartialOrderComparator<ATermAppl> subsumptionComparator = new PartialOrderComparator<ATermAppl>(){

        @Override
        public PartialOrderRelation compare(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
            ConceptInfo conceptInfo;
            ConceptInfo conceptInfo2 = ELClassifier.this.getInfo(aTermAppl);
            if (conceptInfo2.hasSuperClass(conceptInfo = ELClassifier.this.getInfo(aTermAppl2))) {
                if (conceptInfo.hasSuperClass(conceptInfo2)) {
                    return PartialOrderRelation.EQUAL;
                }
                return PartialOrderRelation.LESS;
            }
            if (conceptInfo.hasSuperClass(conceptInfo2)) {
                return PartialOrderRelation.GREATER;
            }
            return PartialOrderRelation.INCOMPARABLE;
        }
    };

    @Override
    protected void reset() {
        super.reset();
        this.hasComplexRoles = this.kb.getExpressivity().hasTransitivity() || this.kb.getExpressivity().hasComplexSubRoles();
        this.queue = new MultiValueMap();
        this.concepts = CollectionUtils.makeMap();
        this.roleChains = new RoleChainCache(this.kb);
        this.roleRestrictions = new RoleRestrictionCache(this.kb.getRBox());
    }

    @Override
    public boolean classify() {
        this.reset();
        this.kb.prepare();
        Timer timer = this.timers.startTimer("createConcepts");
        logger.info("Creating structures");
        this.createConcepts();
        logger.info("Created structures");
        timer.stop();
        this.monitor.setProgressTitle("Classifiying");
        this.monitor.setProgressLength(this.queue.size());
        this.monitor.taskStarted();
        this.printStructures();
        logger.info("Processing queue");
        timer = this.timers.startTimer("processQueue");
        this.processQueue();
        timer.stop();
        logger.info("Processed queue");
        if (logger.isLoggable(Level.FINE)) {
            this.print();
        }
        logger.info("Building hierarchy");
        timer = this.timers.startTimer("buildHierarchy");
        this.taxonomy = new ELTaxonomyBuilder().build(this.concepts);
        timer.stop();
        logger.info("Builded hierarchy");
        this.monitor.taskFinished();
        return true;
    }

    private void buildTaxonomyWithPO() {
        POTaxonomyBuilder pOTaxonomyBuilder = new POTaxonomyBuilder(this.kb, this.subsumptionComparator);
        this.taxonomy = pOTaxonomyBuilder.getTaxonomy();
        for (ConceptInfo conceptInfo : this.concepts.values()) {
            this.classify(conceptInfo);
        }
    }

    private void classify(ConceptInfo conceptInfo) {
        ATermAppl aTermAppl = conceptInfo.getConcept();
        if (!ATermUtils.isPrimitive(aTermAppl)) {
            return;
        }
        if (conceptInfo.getSuperClasses().contains(this.BOTTOM)) {
            this.taxonomy.addEquivalentNode(aTermAppl, this.taxonomy.getBottom());
            return;
        }
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (ConceptInfo conceptInfo2 : conceptInfo.getSuperClasses()) {
            if (!ATermUtils.isPrimitive(conceptInfo2.getConcept()) || conceptInfo.equals(conceptInfo2)) continue;
            if (conceptInfo2.hasSuperClass(conceptInfo)) {
                hashSet.add(conceptInfo2.getConcept());
                continue;
            }
            this.classify(conceptInfo2);
        }
        this.taxonomy.addEquivalents(aTermAppl, hashSet);
    }

    private void addExistential(ConceptInfo conceptInfo, ATermAppl aTermAppl, ConceptInfo conceptInfo2) {
        if (conceptInfo.hasSuccessor(aTermAppl, conceptInfo2)) {
            return;
        }
        this.addExistentialP(conceptInfo, aTermAppl, conceptInfo2);
        Set<Set<ATermAppl>> set = this.kb.getSuperProperties(aTermAppl);
        for (Set<ATermAppl> set2 : set) {
            for (ATermAppl aTermAppl2 : set2) {
                this.addExistentialP(conceptInfo, aTermAppl2, conceptInfo2);
            }
        }
    }

    private void addExistentialP(ConceptInfo conceptInfo, ATermAppl aTermAppl, ConceptInfo conceptInfo2) {
        ATermAppl aTermAppl2;
        Object object2;
        ConceptInfo conceptInfo322;
        if (conceptInfo.hasSuccessor(aTermAppl, conceptInfo2)) {
            return;
        }
        for (ConceptInfo conceptInfo322 : conceptInfo2.getSuperClasses()) {
            ConceptInfo object3;
            if (!conceptInfo.addSuccessor(aTermAppl, conceptInfo322)) continue;
            if (conceptInfo322.equals(this.BOTTOM)) {
                this.addSubsumer(conceptInfo, this.BOTTOM);
                object2 = conceptInfo.getPredecessors().flattenedValues();
                while (object2.hasNext()) {
                    this.addSubsumer((ConceptInfo)object2.next(), this.BOTTOM);
                }
            }
            if ((object3 = this.getInfo((ATermAppl)(object2 = ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)conceptInfo322.getConcept())))) == null) continue;
            this.addToQueue(conceptInfo, object3.getTriggers());
        }
        ATermAppl aTermAppl3 = conceptInfo2.getConcept();
        if (ATermUtils.isAnd(aTermAppl3)) {
            conceptInfo322 = (ATermList)aTermAppl3.getArgument(0);
            while (!conceptInfo322.isEmpty()) {
                object2 = (ATermAppl)conceptInfo322.getFirst();
                ConceptInfo conceptInfo3 = this.createConcept((ATermAppl)object2);
                if (conceptInfo.addSuccessor(aTermAppl, conceptInfo3)) {
                    aTermAppl2 = ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)object2);
                    Iterator iterator = this.createConcept(aTermAppl2);
                    this.addToQueue(conceptInfo, ((ConceptInfo)((Object)iterator)).getTriggers());
                }
                conceptInfo322 = conceptInfo322.getNext();
            }
        }
        if ((conceptInfo322 = this.roleRestrictions.getRange(aTermAppl)) != null) {
            object2 = ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)conceptInfo322);
            ConceptInfo conceptInfo4 = this.createConcept((ATermAppl)object2);
            this.addSubsumer(conceptInfo, conceptInfo4);
        }
        if (this.hasComplexRoles) {
            for (Map.Entry entry : conceptInfo.getPredecessors().entrySet()) {
                aTermAppl2 = (ATermAppl)entry.getKey();
                for (ConceptInfo conceptInfo5 : (Set)entry.getValue()) {
                    for (ATermAppl aTermAppl4 : this.roleChains.getAllSuperRoles(aTermAppl2, aTermAppl)) {
                        this.addExistential(conceptInfo5, aTermAppl4, conceptInfo2);
                    }
                }
            }
            for (Map.Entry entry : conceptInfo2.getSuccessors().entrySet()) {
                aTermAppl2 = (ATermAppl)entry.getKey();
                for (ConceptInfo conceptInfo5 : (Set)entry.getValue()) {
                    for (ATermAppl aTermAppl4 : this.roleChains.getAllSuperRoles(aTermAppl, aTermAppl2)) {
                        this.addExistential(conceptInfo, aTermAppl4, conceptInfo5);
                    }
                }
            }
        }
    }

    private void addToQueue(ConceptInfo conceptInfo, Set<Trigger> set) {
        if (this.queue.addAll(conceptInfo, set) && logger.isLoggable(Level.FINE)) {
            logger.fine("Add to queue: " + conceptInfo + " " + set);
        }
    }

    private void addSubsumer(ConceptInfo conceptInfo, ConceptInfo conceptInfo2) {
        ConceptInfo conceptInfo3;
        Object object2;
        if (conceptInfo.hasSuperClass(conceptInfo2)) {
            return;
        }
        conceptInfo.addSuperClass(conceptInfo2);
        if (ATermUtils.isBottom(conceptInfo2.getConcept())) {
            Iterator<ConceptInfo> iterator = conceptInfo.getPredecessors().flattenedValues();
            while (iterator.hasNext()) {
                this.addSubsumer(iterator.next(), conceptInfo2);
            }
            return;
        }
        this.addToQueue(conceptInfo, conceptInfo2.getTriggers());
        ATermAppl aTermAppl = conceptInfo2.getConcept();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding subsumers to " + conceptInfo + " " + aTermAppl + " " + conceptInfo.getSuperClasses());
        }
        if (ATermUtils.isAnd(aTermAppl)) {
            object2 = (ATermList)aTermAppl.getArgument(0);
            while (!object2.isEmpty()) {
                ATermAppl object3 = (ATermAppl)object2.getFirst();
                this.addSubsumer(conceptInfo, this.createConcept(object3));
                object2 = object2.getNext();
            }
        } else if (ATermUtils.isSomeValues(aTermAppl)) {
            object2 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(1);
            conceptInfo3 = this.createConcept(aTermAppl2);
            this.addExistential(conceptInfo, (ATermAppl)object2, conceptInfo3);
        } else assert (ATermUtils.isPrimitive(aTermAppl));
        for (Map.Entry entry : conceptInfo.getPredecessors().entrySet()) {
            conceptInfo3 = (ATermAppl)entry.getKey();
            for (ConceptInfo conceptInfo4 : (Set)entry.getValue()) {
                ATermAppl aTermAppl3 = ATermUtils.makeSomeValues((ATerm)conceptInfo3, (ATerm)aTermAppl);
                ConceptInfo conceptInfo5 = this.getInfo(aTermAppl3);
                if (conceptInfo5 == null) continue;
                this.addToQueue(conceptInfo4, conceptInfo5.getTriggers());
            }
        }
    }

    private ConceptInfo createConcept(ATermAppl aTermAppl) {
        ConceptInfo conceptInfo = this.getInfo(aTermAppl);
        if (conceptInfo == null) {
            conceptInfo = new ConceptInfo(aTermAppl, this.hasComplexRoles, false);
            this.concepts.put(aTermAppl, conceptInfo);
            conceptInfo.addSuperClass(this.TOP);
            this.addSubsumer(conceptInfo, conceptInfo);
            if (ATermUtils.isAnd(aTermAppl)) {
                ConceptInfo[] conceptInfoArray;
                for (ConceptInfo conceptInfo2 : conceptInfoArray = this.createConceptArray((ATermList)aTermAppl.getArgument(0))) {
                    conceptInfo2.addTrigger(new Trigger(conceptInfoArray, conceptInfo));
                }
            } else if (ATermUtils.isSomeValues(aTermAppl)) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(1);
                this.createConcept(aTermAppl2);
                conceptInfo.addTrigger(new Trigger(conceptInfo));
            }
        }
        return conceptInfo;
    }

    private ConceptInfo[] createConceptArray(ATermList aTermList) {
        ConceptInfo[] conceptInfoArray = new ConceptInfo[aTermList.getLength()];
        int n = 0;
        while (!aTermList.isEmpty()) {
            conceptInfoArray[n++] = this.createConcept((ATermAppl)aTermList.getFirst());
            aTermList = aTermList.getNext();
        }
        return conceptInfoArray;
    }

    private void createConceptsFromAxiom(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        ConceptInfo conceptInfo = this.createConcept(aTermAppl);
        ConceptInfo conceptInfo2 = this.createConcept(aTermAppl2);
        Trigger trigger = new Trigger(conceptInfo2);
        conceptInfo.addTrigger(trigger);
    }

    private void toELSubClassAxioms(ATermAppl aTermAppl) {
        AFun aFun = aTermAppl.getAFun();
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
        ATermAppl aTermAppl4 = ELSyntaxUtils.simplify(aTermAppl2);
        if (aFun.equals(ATermUtils.SUBFUN)) {
            if (ATermUtils.isPrimitive(aTermAppl3) || ATermUtils.isBottom(aTermAppl3)) {
                this.createConceptsFromAxiom(aTermAppl4, aTermAppl3);
                return;
            }
            ATermAppl aTermAppl5 = ELSyntaxUtils.simplify(aTermAppl3);
            this.createConceptsFromAxiom(aTermAppl4, aTermAppl5);
        } else if (aFun.equals(ATermUtils.EQCLASSFUN)) {
            ATermAppl aTermAppl6 = ELSyntaxUtils.simplify(aTermAppl3);
            this.createConceptsFromAxiom(aTermAppl4, aTermAppl6);
            this.createConceptsFromAxiom(aTermAppl6, aTermAppl4);
        } else {
            throw new IllegalArgumentException("Axiom " + aTermAppl + " is not EL.");
        }
    }

    private void normalizeAxioms() {
        ATermAppl aTermAppl;
        Collection<ATermAppl> collection = this.kb.getTBox().getAssertedAxioms();
        for (ATermAppl object : collection) {
            this.toELSubClassAxioms(object);
        }
        for (Map.Entry entry : this.roleRestrictions.getDomains().entrySet()) {
            aTermAppl = (ATermAppl)entry.getKey();
            ATermAppl aTermAppl2 = (ATermAppl)entry.getValue();
            this.createConceptsFromAxiom(ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)ATermUtils.TOP), aTermAppl2);
        }
        for (Role role : this.kb.getRBox().getRoles()) {
            if (!role.isReflexive() || (aTermAppl = this.roleRestrictions.getRange(role.getName())) == null) continue;
            this.createConceptsFromAxiom(ATermUtils.TOP, aTermAppl);
        }
    }

    private void createConcepts() {
        this.TOP = new ConceptInfo(ATermUtils.TOP, this.hasComplexRoles, false);
        this.concepts.put(ATermUtils.TOP, this.TOP);
        this.TOP.addSuperClass(this.TOP);
        this.BOTTOM = new ConceptInfo(ATermUtils.BOTTOM, this.hasComplexRoles, false);
        this.concepts.put(ATermUtils.BOTTOM, this.BOTTOM);
        this.BOTTOM.addSuperClass(this.BOTTOM);
        for (ATermAppl object : this.kb.getClasses()) {
            this.createConcept(object);
        }
        this.normalizeAxioms();
        Set<Trigger> set = this.TOP.getTriggers();
        for (ConceptInfo conceptInfo : this.concepts.values()) {
            Set set2 = CollectionUtils.makeSet(set);
            set2.addAll(conceptInfo.getTriggers());
            if (set2.isEmpty()) continue;
            this.queue.addAll(conceptInfo, set2);
        }
    }

    private ConceptInfo getInfo(ATermAppl aTermAppl) {
        return this.concepts.get(aTermAppl);
    }

    public void print() {
        for (ConceptInfo conceptInfo : this.concepts.values()) {
            System.out.println(conceptInfo + " " + conceptInfo.getSuperClasses());
        }
        System.out.println();
        this.roleChains.print();
    }

    public void printStructures() {
        if (logger.isLoggable(Level.FINE)) {
            for (ConceptInfo conceptInfo : this.concepts.values()) {
                logger.fine(conceptInfo + "\t" + conceptInfo.getTriggers() + "\t" + conceptInfo.getSuperClasses());
            }
        }
    }

    private void processQueue() {
        int n = this.queue.size();
        while (!this.queue.isEmpty()) {
            int n2 = n - this.queue.size();
            if (this.monitor.getProgress() < n2) {
                this.monitor.setProgress(n2);
            }
            MultiValueMap<ConceptInfo, Trigger> multiValueMap = this.queue;
            this.queue = new MultiValueMap();
            for (Map.Entry entry : multiValueMap.entrySet()) {
                ConceptInfo conceptInfo = (ConceptInfo)entry.getKey();
                for (Trigger trigger : (Set)entry.getValue()) {
                    this.processTrigger(conceptInfo, trigger);
                }
            }
        }
    }

    private void processTrigger(ConceptInfo conceptInfo, Trigger trigger) {
        if (trigger.isTriggered(conceptInfo)) {
            this.addSubsumer(conceptInfo, trigger.getConsequence());
        }
    }
}

