/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.IntervalRelations;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class ContinuousRealInterval {
    private static final Logger log = Logger.getLogger(ContinuousRealInterval.class.getCanonicalName());
    private static ContinuousRealInterval unconstrained = new ContinuousRealInterval(null, null, true, true);
    private final boolean inclusiveLower;
    private final boolean inclusiveUpper;
    private final Number lower;
    private final boolean point;
    private final Number upper;

    public static ContinuousRealInterval allReals() {
        return unconstrained;
    }

    private static IntervalRelations compare(ContinuousRealInterval continuousRealInterval, ContinuousRealInterval continuousRealInterval2) {
        int n = ContinuousRealInterval.compareLowerLower(continuousRealInterval, continuousRealInterval2);
        if (n < 0) {
            int n2 = ContinuousRealInterval.compareUpperLower(continuousRealInterval, continuousRealInterval2);
            if (n2 < 0) {
                return IntervalRelations.PRECEDES;
            }
            if (n2 == 0) {
                if (continuousRealInterval.inclusiveUpper()) {
                    if (continuousRealInterval2.inclusiveLower()) {
                        return IntervalRelations.OVERLAPS;
                    }
                    return IntervalRelations.MEETS;
                }
                if (continuousRealInterval2.inclusiveLower()) {
                    return IntervalRelations.MEETS;
                }
                return IntervalRelations.PRECEDES;
            }
            int n3 = ContinuousRealInterval.compareUpperUpper(continuousRealInterval, continuousRealInterval2);
            if (n3 < 0) {
                return IntervalRelations.OVERLAPS;
            }
            if (n3 == 0) {
                return IntervalRelations.FINISHED_BY;
            }
            return IntervalRelations.CONTAINS;
        }
        if (n == 0) {
            int n4 = ContinuousRealInterval.compareUpperUpper(continuousRealInterval, continuousRealInterval2);
            if (n4 < 0) {
                return IntervalRelations.STARTS;
            }
            if (n4 == 0) {
                return IntervalRelations.EQUALS;
            }
            return IntervalRelations.STARTED_BY;
        }
        int n5 = -ContinuousRealInterval.compareUpperLower(continuousRealInterval2, continuousRealInterval);
        if (n5 < 0) {
            int n6 = ContinuousRealInterval.compareUpperUpper(continuousRealInterval, continuousRealInterval2);
            if (n6 < 0) {
                return IntervalRelations.DURING;
            }
            if (n6 == 0) {
                return IntervalRelations.FINISHES;
            }
            return IntervalRelations.OVERLAPPED_BY;
        }
        if (n5 == 0) {
            if (continuousRealInterval2.inclusiveUpper()) {
                if (continuousRealInterval.inclusiveLower()) {
                    return IntervalRelations.OVERLAPPED_BY;
                }
                return IntervalRelations.MET_BY;
            }
            if (continuousRealInterval.inclusiveLower()) {
                return IntervalRelations.MET_BY;
            }
            return IntervalRelations.PRECEDED_BY;
        }
        return IntervalRelations.PRECEDED_BY;
    }

    private static int compareLowerLower(ContinuousRealInterval continuousRealInterval, ContinuousRealInterval continuousRealInterval2) {
        int n;
        if (!continuousRealInterval.boundLower()) {
            n = !continuousRealInterval2.boundLower() ? 0 : -1;
        } else if (!continuousRealInterval2.boundLower()) {
            n = 1;
        } else {
            n = OWLRealUtils.compare(continuousRealInterval.getLower(), continuousRealInterval2.getLower());
            if (n == 0) {
                if (continuousRealInterval.inclusiveLower()) {
                    if (!continuousRealInterval2.inclusiveLower()) {
                        n = -1;
                    }
                } else if (continuousRealInterval2.inclusiveLower()) {
                    n = 1;
                }
            }
        }
        return n;
    }

    private static int compareUpperLower(ContinuousRealInterval continuousRealInterval, ContinuousRealInterval continuousRealInterval2) {
        int n = !continuousRealInterval.boundUpper() ? 1 : (!continuousRealInterval2.boundLower() ? 1 : OWLRealUtils.compare(continuousRealInterval.getUpper(), continuousRealInterval2.getLower()));
        return n;
    }

    private static int compareUpperUpper(ContinuousRealInterval continuousRealInterval, ContinuousRealInterval continuousRealInterval2) {
        int n;
        if (!continuousRealInterval.boundUpper()) {
            n = !continuousRealInterval2.boundUpper() ? 0 : 1;
        } else if (!continuousRealInterval2.boundUpper()) {
            n = -1;
        } else {
            n = OWLRealUtils.compare(continuousRealInterval.getUpper(), continuousRealInterval2.getUpper());
            if (n == 0) {
                if (continuousRealInterval.inclusiveUpper()) {
                    if (!continuousRealInterval2.inclusiveUpper()) {
                        n = 1;
                    }
                } else if (continuousRealInterval2.inclusiveUpper()) {
                    n = -1;
                }
            }
        }
        return n;
    }

    public ContinuousRealInterval(Number number) {
        this.lower = number;
        this.upper = number;
        this.point = true;
        this.inclusiveLower = true;
        this.inclusiveUpper = true;
    }

    public ContinuousRealInterval(Number number, Number number2, boolean bl, boolean bl2) {
        if (number != null && number2 != null) {
            int n = OWLRealUtils.compare(number, number2);
            if (n > 0) {
                String string = String.format("Lower bound of interval (%s) should not be greater than upper bound of interval (%s)", number, number2);
                log.severe(string);
                throw new IllegalArgumentException(string);
            }
            if (!(n != 0 || bl && bl2)) {
                log.severe("Point intervals must be inclusive");
                throw new IllegalArgumentException("Point intervals must be inclusive");
            }
        }
        this.lower = number;
        this.upper = number2;
        this.inclusiveLower = number == null ? false : bl;
        this.inclusiveUpper = number2 == null ? false : bl2;
        this.point = number != null && number2 != null && number.equals(number2);
    }

    public boolean boundLower() {
        return this.lower != null;
    }

    public boolean boundUpper() {
        return this.upper != null;
    }

    public boolean canUnionWith(ContinuousRealInterval continuousRealInterval) {
        return EnumSet.complementOf(EnumSet.of(IntervalRelations.PRECEDES, IntervalRelations.PRECEDED_BY)).contains((Object)this.compare(continuousRealInterval));
    }

    public IntervalRelations compare(ContinuousRealInterval continuousRealInterval) {
        return ContinuousRealInterval.compare(this, continuousRealInterval);
    }

    public boolean contains(Number number) {
        int n;
        if (this.boundLower()) {
            n = OWLRealUtils.compare(this.getLower(), number);
            if (n > 0) {
                return false;
            }
            if (n == 0 && !this.inclusiveLower()) {
                return false;
            }
        }
        if (this.boundUpper()) {
            n = OWLRealUtils.compare(this.getUpper(), number);
            if (n < 0) {
                return false;
            }
            if (n == 0 && !this.inclusiveUpper()) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ContinuousRealInterval continuousRealInterval = (ContinuousRealInterval)object;
        if (this.inclusiveLower != continuousRealInterval.inclusiveLower) {
            return false;
        }
        if (this.inclusiveUpper != continuousRealInterval.inclusiveUpper) {
            return false;
        }
        if (this.lower == null ? continuousRealInterval.lower != null : OWLRealUtils.compare(this.lower, continuousRealInterval.lower) != 0) {
            return false;
        }
        return !(this.upper == null ? continuousRealInterval.upper != null : OWLRealUtils.compare(this.upper, continuousRealInterval.upper) != 0);
    }

    public Number getLower() {
        return this.lower;
    }

    public Number getUpper() {
        return this.upper;
    }

    public ContinuousRealInterval greater(Number number) {
        if (this.boundLower() && OWLRealUtils.compare(number, this.getLower()) < 0) {
            return this;
        }
        if (this.boundUpper() && OWLRealUtils.compare(number, this.getUpper()) >= 0) {
            return null;
        }
        return new ContinuousRealInterval(number, this.getUpper(), false, this.inclusiveUpper());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.inclusiveLower ? 1231 : 1237);
        n = 31 * n + (this.inclusiveUpper ? 1231 : 1237);
        n = 31 * n + (this.lower == null ? 0 : this.lower.hashCode());
        n = 31 * n + (this.upper == null ? 0 : this.upper.hashCode());
        return n;
    }

    public boolean inclusiveLower() {
        return this.inclusiveLower;
    }

    public boolean inclusiveUpper() {
        return this.inclusiveUpper;
    }

    public ContinuousRealInterval intersection(ContinuousRealInterval continuousRealInterval) {
        boolean bl;
        Number number;
        boolean bl2;
        Number number2;
        switch (this.compare(continuousRealInterval)) {
            case CONTAINS: 
            case STARTED_BY: {
                number2 = continuousRealInterval.getLower();
                bl2 = continuousRealInterval.inclusiveLower();
                number = continuousRealInterval.getUpper();
                bl = continuousRealInterval.inclusiveUpper();
                break;
            }
            case EQUALS: {
                number2 = this.getLower();
                bl2 = this.inclusiveLower();
                number = this.getUpper();
                bl = this.inclusiveUpper();
                break;
            }
            case DURING: 
            case STARTS: {
                number2 = this.getLower();
                bl2 = this.inclusiveLower();
                number = this.getUpper();
                bl = this.inclusiveUpper();
                break;
            }
            case FINISHED_BY: {
                number2 = continuousRealInterval.getLower();
                bl2 = continuousRealInterval.inclusiveLower();
                number = continuousRealInterval.getUpper();
                bl = this.inclusiveUpper() && continuousRealInterval.inclusiveUpper();
                break;
            }
            case FINISHES: {
                number2 = this.getLower();
                bl2 = this.inclusiveLower();
                number = this.getUpper();
                bl = this.inclusiveUpper() && continuousRealInterval.inclusiveUpper();
                break;
            }
            case MEETS: 
            case MET_BY: {
                return null;
            }
            case OVERLAPPED_BY: {
                number2 = this.getLower();
                bl2 = this.inclusiveLower();
                number = continuousRealInterval.getUpper();
                bl = continuousRealInterval.inclusiveUpper();
                break;
            }
            case OVERLAPS: {
                number2 = continuousRealInterval.getLower();
                bl2 = continuousRealInterval.inclusiveLower();
                number = this.getUpper();
                bl = this.inclusiveUpper();
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return null;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new ContinuousRealInterval(number2, number, bl2, bl);
    }

    public boolean isPoint() {
        return this.point;
    }

    public ContinuousRealInterval less(Number number) {
        if (this.boundUpper() && OWLRealUtils.compare(number, this.getUpper()) > 0) {
            return this;
        }
        if (this.boundLower() && OWLRealUtils.compare(number, this.getLower()) <= 0) {
            return null;
        }
        return new ContinuousRealInterval(this.getLower(), number, this.inclusiveLower(), false);
    }

    public List<ContinuousRealInterval> remove(ContinuousRealInterval continuousRealInterval) {
        ContinuousRealInterval continuousRealInterval2;
        ContinuousRealInterval continuousRealInterval3;
        switch (this.compare(continuousRealInterval)) {
            case CONTAINS: {
                continuousRealInterval3 = new ContinuousRealInterval(this.getLower(), continuousRealInterval.getLower(), this.inclusiveLower(), !continuousRealInterval.inclusiveLower());
                continuousRealInterval2 = new ContinuousRealInterval(continuousRealInterval.getUpper(), this.getUpper(), !continuousRealInterval.inclusiveUpper(), this.inclusiveUpper());
                break;
            }
            case EQUALS: 
            case DURING: 
            case STARTS: 
            case FINISHES: {
                return Collections.emptyList();
            }
            case MEETS: {
                continuousRealInterval3 = new ContinuousRealInterval(this.getLower(), this.getUpper(), this.inclusiveLower(), false);
                continuousRealInterval2 = null;
                break;
            }
            case MET_BY: {
                continuousRealInterval3 = null;
                continuousRealInterval2 = new ContinuousRealInterval(this.getLower(), this.getUpper(), false, this.inclusiveUpper());
                break;
            }
            case STARTED_BY: 
            case OVERLAPPED_BY: {
                continuousRealInterval3 = null;
                continuousRealInterval2 = new ContinuousRealInterval(continuousRealInterval.getUpper(), this.getUpper(), !continuousRealInterval.inclusiveUpper(), this.inclusiveUpper());
                break;
            }
            case FINISHED_BY: 
            case OVERLAPS: {
                continuousRealInterval3 = new ContinuousRealInterval(this.getLower(), continuousRealInterval.getLower(), this.inclusiveLower(), !continuousRealInterval.inclusiveLower());
                continuousRealInterval2 = null;
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return Collections.singletonList(this);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ArrayList<ContinuousRealInterval> arrayList = new ArrayList<ContinuousRealInterval>();
        if (continuousRealInterval3 != null) {
            arrayList.add(continuousRealInterval3);
        }
        if (continuousRealInterval2 != null) {
            arrayList.add(continuousRealInterval2);
        }
        return arrayList;
    }

    public Number size() {
        if (!this.point) {
            throw new IllegalStateException();
        }
        return 1;
    }

    public String toString() {
        return String.format("%s%s,%s%s", this.inclusiveLower() ? "[" : "(", this.boundLower() ? this.getLower() : "-Inf", this.boundUpper() ? this.getUpper() : "+Inf", this.inclusiveUpper() ? "]" : ")");
    }

    public List<ContinuousRealInterval> union(ContinuousRealInterval continuousRealInterval) {
        switch (this.compare(continuousRealInterval)) {
            case CONTAINS: 
            case STARTED_BY: 
            case EQUALS: 
            case FINISHED_BY: {
                return Collections.singletonList(this);
            }
            case DURING: 
            case STARTS: 
            case FINISHES: {
                return Collections.singletonList(continuousRealInterval);
            }
            case MEETS: {
                return Collections.singletonList(new ContinuousRealInterval(this.getLower(), continuousRealInterval.getUpper(), this.inclusiveLower(), continuousRealInterval.inclusiveUpper()));
            }
            case MET_BY: {
                return Collections.singletonList(new ContinuousRealInterval(continuousRealInterval.getLower(), this.getUpper(), continuousRealInterval.inclusiveLower(), this.inclusiveUpper()));
            }
            case OVERLAPPED_BY: {
                return Collections.singletonList(new ContinuousRealInterval(continuousRealInterval.getLower(), this.getUpper(), continuousRealInterval.inclusiveLower(), this.inclusiveUpper()));
            }
            case OVERLAPS: {
                return Collections.singletonList(new ContinuousRealInterval(this.getLower(), continuousRealInterval.getUpper(), this.inclusiveLower(), continuousRealInterval.inclusiveUpper()));
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return Arrays.asList(this, continuousRealInterval);
            }
        }
        throw new IllegalStateException();
    }

    public Iterator<Number> valueIterator() {
        if (this.isPoint()) {
            return Collections.singletonList(this.getUpper()).iterator();
        }
        throw new IllegalStateException();
    }
}

