/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.datetime;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.datetime.RestrictedTimelineDatatype;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class AbstractTimelineDatatype
extends AbstractBaseDatatype<XMLGregorianCalendar> {
    private final QName schemaType;

    public AbstractTimelineDatatype(ATermAppl aTermAppl, QName qName) {
        super(aTermAppl);
        this.schemaType = qName;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        XMLGregorianCalendar xMLGregorianCalendar = this.getValue(aTermAppl);
        String string = xMLGregorianCalendar.toXMLFormat();
        if (string.equals(ATermUtils.getLiteralValue(aTermAppl))) {
            return aTermAppl;
        }
        return ATermUtils.makeTypedLiteral(string, this.getName());
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        if (object instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)object;
            if (!this.schemaType.equals(xMLGregorianCalendar.getXMLSchemaType())) {
                throw new IllegalArgumentException();
            }
            return ATermUtils.makeTypedLiteral(xMLGregorianCalendar.toXMLFormat(), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public XMLGregorianCalendar getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = RestrictedTimelineDatatype.getDatatypeFactory().newXMLGregorianCalendar(string);
            if (!this.schemaType.equals(xMLGregorianCalendar.getXMLSchemaType())) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            return xMLGregorianCalendar;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
        catch (IllegalStateException illegalStateException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

