/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import aterm.ATermAppl;
import com.clarkparsia.owlapi.explanation.SingleExplanationGeneratorImpl;
import com.clarkparsia.owlapi.explanation.util.DefinitionTracker;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.AxiomConverter;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class GlassBoxExplanation
extends SingleExplanationGeneratorImpl {
    public static final Logger log;
    private PelletReasoner altReasoner = null;
    private boolean altReasonerEnabled = false;
    private AxiomConverter axiomConverter;

    public static void setup() {
        PelletOptions.USE_TRACING = true;
    }

    public GlassBoxExplanation(OWLOntology oWLOntology, PelletReasonerFactory pelletReasonerFactory) {
        this(pelletReasonerFactory, pelletReasonerFactory.createReasoner(oWLOntology));
    }

    public GlassBoxExplanation(PelletReasoner pelletReasoner) {
        this(new PelletReasonerFactory(), pelletReasoner);
    }

    public GlassBoxExplanation(PelletReasonerFactory pelletReasonerFactory, PelletReasoner pelletReasoner) {
        super(pelletReasoner.getRootOntology(), (OWLReasonerFactory)pelletReasonerFactory, (OWLReasoner)pelletReasoner);
        this.axiomConverter = new AxiomConverter(pelletReasoner);
    }

    private void setAltReasonerEnabled(boolean bl) {
        if (bl && this.altReasoner == null) {
            log.fine("Create alt reasoner");
            this.altReasoner = this.getReasonerFactory().createNonBufferingReasoner(this.getOntology());
        }
        this.altReasonerEnabled = bl;
    }

    private OWLClass getNegation(OWLClassExpression oWLClassExpression) {
        if (!(oWLClassExpression instanceof OWLObjectComplementOf)) {
            return null;
        }
        OWLClassExpression oWLClassExpression2 = ((OWLObjectComplementOf)oWLClassExpression).getOperand();
        if (oWLClassExpression2.isAnonymous()) {
            return null;
        }
        return (OWLClass)oWLClassExpression2;
    }

    private Pair<OWLClass, OWLClass> getSubClassAxiom(OWLClassExpression oWLClassExpression) {
        if (!(oWLClassExpression instanceof OWLObjectIntersectionOf)) {
            return null;
        }
        OWLObjectIntersectionOf oWLObjectIntersectionOf = (OWLObjectIntersectionOf)oWLClassExpression;
        if (oWLObjectIntersectionOf.getOperands().size() != 2) {
            return null;
        }
        Iterator iterator = oWLObjectIntersectionOf.getOperands().iterator();
        OWLClassExpression oWLClassExpression2 = (OWLClassExpression)iterator.next();
        OWLClassExpression oWLClassExpression3 = (OWLClassExpression)iterator.next();
        OWLClass oWLClass = null;
        OWLClass oWLClass2 = null;
        if (!oWLClassExpression2.isAnonymous()) {
            oWLClass = (OWLClass)oWLClassExpression2;
            oWLClass2 = this.getNegation(oWLClassExpression3);
        } else if (!oWLClassExpression3.isAnonymous()) {
            oWLClass = (OWLClass)oWLClassExpression3;
            oWLClass2 = this.getNegation(oWLClassExpression3);
        }
        if (oWLClass2 == null) {
            return null;
        }
        return new Pair<OWLClass, OWLClass>(oWLClass, oWLClass2);
    }

    private Set<OWLAxiom> getCachedExplanation(OWLClassExpression oWLClassExpression) {
        Set<Set<ATermAppl>> set;
        PelletReasoner pelletReasoner = this.getReasoner();
        if (!pelletReasoner.getKB().isClassified()) {
            return null;
        }
        Pair<OWLClass, OWLClass> pair = this.getSubClassAxiom(oWLClassExpression);
        if (pair != null && (set = TaxonomyUtils.getSuperExplanations(pelletReasoner.getKB().getTaxonomy(), pelletReasoner.term((OWLObject)pair.first), pelletReasoner.term((OWLObject)pair.second))) != null) {
            Set<OWLAxiom> set2 = this.convertExplanation(set.iterator().next());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cached explanation: " + set2);
            }
            return set2;
        }
        return null;
    }

    public Set<OWLAxiom> getExplanation(OWLClassExpression oWLClassExpression) {
        Set<OWLAxiom> set = null;
        boolean bl = this.isFirstExplanation();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Explain: " + oWLClassExpression + " " + "First: " + bl);
        }
        if (bl) {
            this.altReasoner = null;
            set = this.getCachedExplanation(oWLClassExpression);
            if (set == null) {
                set = this.getPelletExplanation(oWLClassExpression);
            }
        } else {
            this.setAltReasonerEnabled(true);
            try {
                set = this.getPelletExplanation(oWLClassExpression);
            }
            catch (RuntimeException runtimeException) {
                log.log(Level.SEVERE, "Unexpected error while trying to get explanation set from Pellet", runtimeException);
                throw new OWLRuntimeException((Throwable)runtimeException);
            }
            finally {
                this.setAltReasonerEnabled(false);
            }
        }
        return set;
    }

    private Set<OWLAxiom> getPelletExplanation(OWLClassExpression oWLClassExpression) {
        boolean bl;
        PelletReasoner pelletReasoner = this.getReasoner();
        pelletReasoner.getKB().prepare();
        boolean bl2 = bl = !this.getDefinitionTracker().isDefined(oWLClassExpression);
        if (!bl) {
            bl = this.isSatisfiable(pelletReasoner, oWLClassExpression, true);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Undefined entity in " + oWLClassExpression);
        }
        if (bl) {
            return Collections.emptySet();
        }
        Set<OWLAxiom> set = this.convertExplanation(pelletReasoner.getKB().getExplanationSet());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Explanation " + set);
        }
        Set<OWLAxiom> set2 = this.pruneExplanation(oWLClassExpression, set, true);
        int n = set.size() - set2.size();
        if (log.isLoggable(Level.FINE) && n > 0) {
            log.fine("Pruned " + n + " axioms from the explanation: " + SetUtils.difference(set, set2));
            log.fine("New explanation " + set2);
        }
        return set2;
    }

    private boolean isSatisfiable(PelletReasoner pelletReasoner, OWLClassExpression oWLClassExpression, boolean bl) {
        pelletReasoner.getKB().setDoExplanation(bl);
        boolean bl2 = oWLClassExpression.isOWLThing() ? pelletReasoner.isConsistent() : pelletReasoner.isSatisfiable(oWLClassExpression);
        pelletReasoner.getKB().setDoExplanation(false);
        return bl2;
    }

    private Set<OWLAxiom> convertExplanation(Set<ATermAppl> set) {
        if (set == null || set.isEmpty()) {
            throw new OWLRuntimeException("No explanation computed");
        }
        HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>();
        for (ATermAppl aTermAppl : set) {
            OWLAxiom oWLAxiom = this.axiomConverter.convert(aTermAppl);
            if (oWLAxiom == null) {
                throw new OWLRuntimeException("Cannot convert: " + aTermAppl);
            }
            hashSet.add(oWLAxiom);
        }
        return hashSet;
    }

    private Set<OWLAxiom> pruneExplanation(OWLClassExpression oWLClassExpression, Set<OWLAxiom> set, boolean bl) {
        try {
            HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>(set);
            if (hashSet.size() <= 1) {
                return hashSet;
            }
            OWLOntology oWLOntology = OWL.Ontology(set);
            DefinitionTracker definitionTracker = new DefinitionTracker(oWLOntology);
            PelletReasoner pelletReasoner = this.getReasonerFactory().createNonBufferingReasoner(oWLOntology);
            if (!definitionTracker.isDefined(oWLClassExpression)) {
                log.warning("Some of the entities in " + oWLClassExpression + " are not defined in the explanation " + set);
            }
            if (this.isSatisfiable(pelletReasoner, oWLClassExpression, true)) {
                log.warning("Explanation incomplete: Concept " + oWLClassExpression + " is satisfiable in the explanation " + set);
            }
            for (OWLAxiom oWLAxiom : set) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Try pruning " + oWLAxiom);
                }
                if (!bl) {
                    pelletReasoner.dispose();
                }
                OntologyUtils.removeAxioms(oWLOntology, oWLAxiom);
                if (!bl) {
                    pelletReasoner = this.getReasonerFactory().createNonBufferingReasoner(oWLOntology);
                }
                pelletReasoner.getKB().prepare();
                if (definitionTracker.isDefined(oWLClassExpression) && !this.isSatisfiable(pelletReasoner, oWLClassExpression, false)) {
                    hashSet.remove(oWLAxiom);
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.finer("Pruned " + oWLAxiom);
                    continue;
                }
                OntologyUtils.addAxioms(oWLOntology, oWLAxiom);
            }
            if (bl) {
                pelletReasoner.dispose();
            }
            OWL.manager.removeOntology(oWLOntology);
            OWL.manager.removeOntologyChangeListener((OWLOntologyChangeListener)definitionTracker);
            return hashSet;
        }
        catch (OWLOntologyChangeException oWLOntologyChangeException) {
            throw new OWLRuntimeException((Throwable)oWLOntologyChangeException);
        }
    }

    public PelletReasoner getReasoner() {
        return this.altReasonerEnabled ? this.altReasoner : (PelletReasoner)super.getReasoner();
    }

    public PelletReasonerFactory getReasonerFactory() {
        return (PelletReasonerFactory)super.getReasonerFactory();
    }

    public void dispose() {
        this.getOntologyManager().removeOntologyChangeListener((OWLOntologyChangeListener)this.getDefinitionTracker());
        if (this.altReasoner != null) {
            this.altReasoner.dispose();
        }
    }

    public String toString() {
        return "GlassBox";
    }

    static {
        GlassBoxExplanation.setup();
        log = Logger.getLogger(GlassBoxExplanation.class.getName());
    }
}

