/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.ChangeTypeDetector;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.io.ModuleExtractorPersistence;
import com.clarkparsia.modularity.io.UncloseableOutputStream;
import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.LocalityEvaluator;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.expressivity.Expressivity;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public abstract class AbstractModuleExtractor
implements ModuleExtractor {
    public static final Logger log = Logger.getLogger(AbstractModuleExtractor.class.getName());
    private Set<OWLAxiom> additions = new HashSet<OWLAxiom>();
    private Set<OWLClass> allClasses = new HashSet<OWLClass>();
    private OWLOntology axiomOntology = null;
    private MultiValueMap<OWLAxiom, OWLEntity> axiomEntities = new MultiValueMap();
    private Set<OWLAxiom> deletions = new HashSet<OWLAxiom>();
    protected EnumSet<KnowledgeBase.ChangeType> changes = EnumSet.noneOf(KnowledgeBase.ChangeType.class);
    protected MultiValueMap<OWLEntity, OWLAxiom> entityAxioms = new MultiValueMap();
    private LocalityEvaluator localityEvaluator = null;
    protected MultiValueMap<OWLEntity, OWLEntity> modules = null;
    private boolean nonLocalAxioms = false;
    private Timers timers = new Timers();
    private static final String MODULE_EXTRACTOR_AXIOMS_FILE_NAME = "ModuleExtractorAxioms";
    private static final String MODULE_EXTRACTOR_MODULES_FILE_NAME = "ModuleExtractorModules";

    public AbstractModuleExtractor() {
        this((LocalityEvaluator)new SyntacticLocalityEvaluator(LocalityClass.BOTTOM_BOTTOM));
    }

    public AbstractModuleExtractor(LocalityEvaluator localityEvaluator) {
        this.localityEvaluator = localityEvaluator;
    }

    @Override
    public void addAxiom(OWLAxiom oWLAxiom) {
        this.checkNonLocalAxiom(oWLAxiom);
        if (this.axiomEntities.containsKey(oWLAxiom)) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding " + oWLAxiom);
        }
        this.deletions.remove(oWLAxiom);
        this.additions.add(oWLAxiom);
        this.categorizeAddedAxiom(oWLAxiom);
    }

    @Override
    public boolean canUpdate() {
        return this.modules != null && !this.nonLocalAxioms;
    }

    private void checkNonLocalAxiom(OWLAxiom oWLAxiom) {
        if (!oWLAxiom.isLogicalAxiom()) {
            return;
        }
        if (this.canUpdate() && !this.isLocal(oWLAxiom, Collections.emptySet())) {
            log.warning("*** Non-local axiom: " + oWLAxiom);
            this.nonLocalAxioms = true;
        }
    }

    @Override
    public void deleteAxiom(OWLAxiom oWLAxiom) {
        this.checkNonLocalAxiom(oWLAxiom);
        if (!this.axiomEntities.containsKey(oWLAxiom)) {
            if (this.additions.remove(oWLAxiom) && log.isLoggable(Level.FINE)) {
                log.fine("Deleted axiom from add queue before processing " + oWLAxiom);
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Deleting " + oWLAxiom);
        }
        this.additions.remove(oWLAxiom);
        this.deletions.add(oWLAxiom);
        this.categorizeRemovedAxiom(oWLAxiom);
    }

    @Override
    public MultiValueMap<OWLEntity, OWLEntity> getModules() {
        return this.modules;
    }

    @Override
    public MultiValueMap<OWLEntity, OWLEntity> extractModules() {
        Timer timer = this.timers.startTimer("extractModules");
        this.processAdditions();
        this.additions.clear();
        this.deletions.clear();
        this.changes.clear();
        this.nonLocalAxioms = false;
        this.modules = new MultiValueMap();
        this.extractModuleSignatures(this.allClasses);
        timer.stop();
        return this.modules;
    }

    protected abstract void extractModuleSignatures(Set<? extends OWLEntity> var1);

    private Set<OWLEntity> getAffectedRoots(OWLAxiom oWLAxiom, Taxonomy<OWLClass> taxonomy, boolean bl) {
        HashSet<OWLEntity> hashSet = new HashSet<OWLEntity>();
        HashSet<TaxonomyNode<OWLClass>> hashSet2 = new HashSet<TaxonomyNode<OWLClass>>();
        hashSet2.add(taxonomy.getBottom());
        this.getAffectedRoots(oWLAxiom, taxonomy.getTop(), hashSet, bl, hashSet2);
        if (!bl && hashSet.isEmpty()) {
            for (OWLClass oWLClass : taxonomy.getEquivalents(OWL.Nothing)) {
                Set set = (Set)this.modules.get(oWLClass);
                if (set == null || !set.containsAll(this.getSignature(oWLAxiom))) continue;
                hashSet.add((OWLEntity)oWLClass);
            }
        }
        return hashSet;
    }

    private void getAffectedRoots(OWLAxiom oWLAxiom, TaxonomyNode<OWLClass> taxonomyNode, Set<OWLEntity> set, boolean bl, Set<TaxonomyNode<OWLClass>> set2) {
        if (set2.contains(taxonomyNode)) {
            return;
        }
        set2.add(taxonomyNode);
        OWLEntity oWLEntity = (OWLEntity)taxonomyNode.getName();
        Set set3 = (Set)this.modules.get(oWLEntity);
        boolean bl2 = false;
        if (set3 == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Removed entity " + oWLEntity);
            }
        } else {
            bl2 = bl ? !this.isLocal(oWLAxiom, set3) : set3.containsAll(this.getSignature(oWLAxiom));
        }
        if (bl2) {
            set.addAll(taxonomyNode.getEquivalents());
        } else {
            for (TaxonomyNode<OWLClass> taxonomyNode2 : taxonomyNode.getSubs()) {
                this.getAffectedRoots(oWLAxiom, taxonomyNode2, set, bl, set2);
            }
        }
    }

    @Override
    public Set<OWLAxiom> getAxioms(OWLEntity oWLEntity) {
        Set<OWLAxiom> set = (Set<OWLAxiom>)this.entityAxioms.get(oWLEntity);
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    @Override
    public OWLOntology getModule(OWLEntity oWLEntity) {
        return this.getModuleFromSignature((Set)this.modules.get(oWLEntity));
    }

    protected Set<OWLAxiom> getModuleAxioms(Set<OWLEntity> set) {
        Set set2;
        HashSet hashSet = new HashSet();
        HashSet<OWLEntity> hashSet2 = new HashSet<OWLEntity>(set);
        hashSet2.add((OWLEntity)OWL.Thing);
        HashSet<OWLAxiom> hashSet3 = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> hashSet4 = new HashSet<OWLAxiom>();
        for (OWLEntity object2 : set) {
            hashSet4.addAll(this.getAxioms(object2));
        }
        for (OWLAxiom oWLAxiom : hashSet4) {
            set2 = (Set)this.axiomEntities.get(oWLAxiom);
            if (!hashSet2.containsAll(set2) || this.isLocal(oWLAxiom, set)) continue;
            hashSet3.add(oWLAxiom);
            hashSet.addAll(set2);
        }
        HashSet<OWLEntity> hashSet5 = new HashSet<OWLEntity>(set);
        hashSet5.removeAll(hashSet);
        Iterator iterator = hashSet5.iterator();
        while (iterator.hasNext()) {
            set2 = (OWLEntity)iterator.next();
            if (this.entityAxioms.get(set2) == null) continue;
            hashSet3.add((OWLAxiom)OWL.declaration((OWLEntity)set2));
        }
        return hashSet3;
    }

    @Override
    public OWLOntology getModuleFromSignature(Set<OWLEntity> set) {
        Set<OWLAxiom> set2 = this.getModuleAxioms(set);
        return OWL.Ontology(set2);
    }

    protected Set<OWLEntity> getSignature(OWLAxiom oWLAxiom) {
        return (Set)this.axiomEntities.get(oWLAxiom);
    }

    @Override
    public boolean isChanged() {
        return !this.additions.isEmpty() || !this.deletions.isEmpty() || this.nonLocalAxioms;
    }

    protected boolean isLocal(OWLAxiom oWLAxiom, Set<OWLEntity> set) {
        return this.localityEvaluator.isLocal(oWLAxiom, set);
    }

    @Override
    public void addOntologies(Set<OWLOntology> set) {
        for (OWLOntology oWLOntology : set) {
            this.addOntology(oWLOntology);
        }
    }

    @Override
    public void addOntology(OWLOntology oWLOntology) {
        for (OWLAxiom oWLAxiom : oWLOntology.getAxioms()) {
            this.addAxiom(oWLAxiom);
        }
    }

    private void processAdditions() {
        for (OWLAxiom oWLAxiom : this.additions) {
            Set<OWLEntity> set = OntologyUtils.getSignature(oWLAxiom);
            this.axiomEntities.put(oWLAxiom, set);
            for (OWLEntity oWLEntity : set) {
                this.entityAxioms.add(oWLEntity, oWLAxiom);
                if (!(oWLEntity instanceof OWLClass)) continue;
                OWLClass oWLClass = (OWLClass)oWLEntity;
                this.allClasses.add(oWLClass);
            }
        }
    }

    private void processDeletions() {
        for (OWLAxiom oWLAxiom : this.deletions) {
            Set set = (Set)this.axiomEntities.remove(oWLAxiom);
            for (OWLEntity oWLEntity : set) {
                this.entityAxioms.remove(oWLEntity, oWLAxiom);
                if (this.entityAxioms.containsKey(oWLEntity)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Remove " + oWLEntity + " which is not mentioned anymore");
                }
                this.allClasses.remove(oWLEntity);
                this.modules.remove(oWLEntity);
            }
        }
    }

    private Set<OWLEntity> updateEffectedModules(Set<OWLAxiom> set, Taxonomy<OWLClass> taxonomy, boolean bl) {
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashSet<OWLEntity> hashSet3 = new HashSet<OWLEntity>();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Update modules for " + (bl ? "additions" : "deletions"));
        }
        hashSet.addAll(this.allClasses);
        hashSet.removeAll(this.modules.keySet());
        for (OWLAxiom oWLAxiom : set) {
            hashSet.addAll(this.getAffectedRoots(oWLAxiom, taxonomy, bl));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Affected roots " + hashSet);
        }
        for (OWLEntity oWLEntity : hashSet) {
            hashSet2.add(oWLEntity);
            if (!(oWLEntity instanceof OWLClass) || !taxonomy.contains((OWLClass)oWLEntity)) continue;
            hashSet2.addAll(taxonomy.getFlattenedSubs((OWLClass)oWLEntity, false));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Affected entities " + hashSet2);
        }
        for (OWLEntity oWLEntity : hashSet2) {
            this.modules.remove(oWLEntity);
        }
        this.extractModuleSignatures(hashSet2);
        for (OWLEntity oWLEntity : hashSet2) {
            Set set2 = (Set)this.modules.get(oWLEntity);
            if (set2 == null) {
                String string = "No module for " + oWLEntity;
                log.log(Level.SEVERE, string, new RuntimeException(string));
            }
            hashSet3.addAll(set2);
        }
        return hashSet3;
    }

    @Override
    public Set<OWLEntity> updateModules(Taxonomy<OWLClass> taxonomy, boolean bl) throws UnsupportedOperationException {
        Timer timer = this.timers.startTimer("updateModules");
        if (!this.canUpdate()) {
            throw new UnsupportedOperationException("Modules cannot be updated!");
        }
        Set<OWLEntity> set = null;
        if (bl) {
            this.processAdditions();
            set = this.updateEffectedModules(this.additions, taxonomy, bl);
            this.additions.clear();
            this.changes.remove((Object)KnowledgeBase.ChangeType.ABOX_ADD);
            this.changes.remove((Object)KnowledgeBase.ChangeType.RBOX_ADD);
            this.changes.remove((Object)KnowledgeBase.ChangeType.TBOX_ADD);
        } else {
            set = this.updateEffectedModules(this.deletions, taxonomy, bl);
            this.processDeletions();
            this.deletions.clear();
            this.changes.remove((Object)KnowledgeBase.ChangeType.ABOX_DEL);
            this.changes.remove((Object)KnowledgeBase.ChangeType.RBOX_DEL);
            this.changes.remove((Object)KnowledgeBase.ChangeType.TBOX_DEL);
        }
        timer.stop();
        return set;
    }

    @Override
    public Timers getTimers() {
        return this.timers;
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        return Collections.unmodifiableSet(this.axiomEntities.keySet());
    }

    @Override
    public OWLOntology getAxiomOntology() {
        if (null == this.axiomOntology) {
            this.axiomOntology = OWL.Ontology(this.axiomEntities.keySet());
        }
        return this.axiomOntology;
    }

    @Override
    public Set<OWLEntity> getEntities() {
        return Collections.unmodifiableSet(this.entityAxioms.keySet());
    }

    public void resetModules() {
        this.processAdditions();
        this.additions.clear();
        this.deletions.clear();
        this.changes.clear();
        this.nonLocalAxioms = false;
        this.modules = new MultiValueMap();
    }

    @Override
    public boolean isClassificationNeeded(Expressivity expressivity) {
        return this.isTBoxChanged() || this.isRBoxChanged() || expressivity.hasNominal() && !PelletOptions.USE_PSEUDO_NOMINALS;
    }

    public boolean isTBoxChanged() {
        return this.changes.contains((Object)KnowledgeBase.ChangeType.TBOX_ADD) || this.changes.contains((Object)KnowledgeBase.ChangeType.TBOX_DEL);
    }

    public boolean isRBoxChanged() {
        return this.changes.contains((Object)KnowledgeBase.ChangeType.RBOX_ADD) || this.changes.contains((Object)KnowledgeBase.ChangeType.RBOX_DEL);
    }

    public boolean isABoxChanged() {
        return this.changes.contains((Object)KnowledgeBase.ChangeType.ABOX_ADD) || this.changes.contains((Object)KnowledgeBase.ChangeType.ABOX_DEL);
    }

    private void categorizeAddedAxiom(OWLAxiom oWLAxiom) {
        if (ChangeTypeDetector.isTBoxAxiom(oWLAxiom)) {
            this.changes.add(KnowledgeBase.ChangeType.TBOX_ADD);
        } else if (ChangeTypeDetector.isRBoxAxiom(oWLAxiom)) {
            this.changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
        } else if (ChangeTypeDetector.isABoxAxiom(oWLAxiom)) {
            this.changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        }
    }

    private void categorizeRemovedAxiom(OWLAxiom oWLAxiom) {
        if (ChangeTypeDetector.isTBoxAxiom(oWLAxiom)) {
            this.changes.add(KnowledgeBase.ChangeType.TBOX_DEL);
        } else if (ChangeTypeDetector.isRBoxAxiom(oWLAxiom)) {
            this.changes.add(KnowledgeBase.ChangeType.RBOX_DEL);
        } else if (ChangeTypeDetector.isABoxAxiom(oWLAxiom)) {
            this.changes.add(KnowledgeBase.ChangeType.ABOX_DEL);
        }
    }

    @Override
    public void save(ZipOutputStream zipOutputStream) throws IOException, IllegalStateException {
        if (!this.additions.isEmpty() || !this.deletions.isEmpty()) {
            throw new IllegalStateException("The module extractor contains unapplied changes to the modules, and therefore cannot be saved.");
        }
        ZipEntry zipEntry = new ZipEntry(MODULE_EXTRACTOR_AXIOMS_FILE_NAME);
        zipOutputStream.putNextEntry(zipEntry);
        ModuleExtractorPersistence.saveAxioms(this.axiomEntities.keySet(), new UncloseableOutputStream(zipOutputStream));
        ZipEntry zipEntry2 = new ZipEntry(MODULE_EXTRACTOR_MODULES_FILE_NAME);
        zipOutputStream.putNextEntry(zipEntry2);
        ModuleExtractorPersistence.saveModules(this.modules, new UncloseableOutputStream(zipOutputStream));
        zipOutputStream.flush();
    }

    @Override
    public void load(ZipInputStream zipInputStream) throws IOException, IllegalArgumentException {
        this.resetModules();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (!MODULE_EXTRACTOR_AXIOMS_FILE_NAME.equals(zipEntry.getName())) {
            throw new IllegalArgumentException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", zipEntry.getName(), MODULE_EXTRACTOR_AXIOMS_FILE_NAME));
        }
        this.axiomOntology = ModuleExtractorPersistence.loadAxiomOntology(zipInputStream);
        Set set = this.axiomOntology.getAxioms();
        this.additions.addAll(set);
        this.processAdditions();
        this.additions.clear();
        zipEntry = zipInputStream.getNextEntry();
        if (!MODULE_EXTRACTOR_MODULES_FILE_NAME.equals(zipEntry.getName())) {
            throw new IllegalArgumentException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", zipEntry.getName(), MODULE_EXTRACTOR_MODULES_FILE_NAME));
        }
        this.modules = ModuleExtractorPersistence.loadModules(zipInputStream);
    }
}

