/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.AltHasNoDefaultException;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ContainerImpl;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.vocabulary.RDF;

public class AltImpl
extends ContainerImpl
implements Alt {
    public static final Implementation factory = new Implementation(){

        @Override
        public boolean canWrap(Node n, EnhGraph eg) {
            return true;
        }

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            return new AltImpl(n, eg);
        }
    };

    public AltImpl(ModelCom model) {
        super(model);
    }

    public AltImpl(String uri, ModelCom model) {
        super(uri, model);
    }

    public AltImpl(Resource r, ModelCom m) {
        super(r, m);
    }

    public AltImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    private Statement needDefaultStatement() {
        Statement stmt = this.getDefaultStatement();
        if (stmt == null) {
            throw new AltHasNoDefaultException(this);
        }
        return stmt;
    }

    @Override
    public RDFNode getDefault() {
        return this.needDefaultStatement().getObject();
    }

    @Override
    public Resource getDefaultResource() {
        return this.needDefaultStatement().getResource();
    }

    @Override
    public Literal getDefaultLiteral() {
        return this.needDefaultStatement().getLiteral();
    }

    @Override
    public boolean getDefaultBoolean() {
        return this.needDefaultStatement().getBoolean();
    }

    @Override
    public byte getDefaultByte() {
        return this.needDefaultStatement().getByte();
    }

    @Override
    public short getDefaultShort() {
        return this.needDefaultStatement().getShort();
    }

    @Override
    public int getDefaultInt() {
        return this.needDefaultStatement().getInt();
    }

    @Override
    public long getDefaultLong() {
        return this.needDefaultStatement().getLong();
    }

    @Override
    public char getDefaultChar() {
        return this.needDefaultStatement().getChar();
    }

    @Override
    public float getDefaultFloat() {
        return this.needDefaultStatement().getFloat();
    }

    @Override
    public double getDefaultDouble() {
        return this.needDefaultStatement().getDouble();
    }

    @Override
    public String getDefaultString() {
        return this.needDefaultStatement().getString();
    }

    @Override
    public String getDefaultLanguage() {
        return this.needDefaultStatement().getLanguage();
    }

    @Override
    @Deprecated
    public Resource getDefaultResource(ResourceF f) {
        return this.needDefaultStatement().getResource();
    }

    @Override
    public Alt getDefaultAlt() {
        return this.needDefaultStatement().getAlt();
    }

    @Override
    public Bag getDefaultBag() {
        return this.needDefaultStatement().getBag();
    }

    @Override
    public Seq getDefaultSeq() {
        return this.needDefaultStatement().getSeq();
    }

    @Override
    public Alt setDefault(RDFNode o) {
        Statement stmt = this.getDefaultStatement();
        if (stmt != null) {
            this.getModel().remove(stmt);
        }
        this.getModel().add((Resource)this, RDF.li(1), o);
        return this;
    }

    @Override
    public Alt setDefault(boolean o) {
        return this.setDefault(String.valueOf(o));
    }

    @Override
    public Alt setDefault(long o) {
        return this.setDefault(String.valueOf(o));
    }

    @Override
    public Alt setDefault(char o) {
        return this.setDefault(String.valueOf(o));
    }

    @Override
    public Alt setDefault(float o) {
        return this.setDefault(String.valueOf(o));
    }

    @Override
    public Alt setDefault(double o) {
        return this.setDefault(String.valueOf(o));
    }

    @Override
    public Alt setDefault(Object o) {
        return this.setDefault(String.valueOf(o));
    }

    @Override
    public Alt setDefault(String o) {
        return this.setDefault(o, "");
    }

    @Override
    public Alt setDefault(String o, String l) {
        return this.setDefault(new LiteralImpl(Node.createLiteral(o, l, false), this.getModelCom()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement getDefaultStatement() {
        StmtIterator iter = this.getModel().listStatements((Resource)this, RDF.li(1), (RDFNode)null);
        try {
            Statement statement = iter.hasNext() ? iter.nextStatement() : null;
            return statement;
        }
        finally {
            iter.close();
        }
    }
}

