/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import org.apache.jena.atlas.lib.Lib;

public class Quad {
    public static final Node defaultGraphNodeGenerated = Node.createURI((String)"urn:x-arq:DefaultGraphNode");
    public static final Node defaultGraphIRI = Node.createURI((String)"urn:x-arq:DefaultGraph");
    public static final Node unionGraph = Node.createURI((String)"urn:x-arq:UnionGraph");
    public static final Node tripleInQuad = null;
    private final Node graph;
    private final Node subject;
    private final Node predicate;
    private final Node object;

    public Quad(Node graph, Triple triple) {
        this(graph, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public Quad(Node g, Node s, Node p, Node o) {
        if (s == null) {
            throw new UnsupportedOperationException("Quad: subject cannot be null");
        }
        if (p == null) {
            throw new UnsupportedOperationException("Quad: predicate cannot be null");
        }
        if (o == null) {
            throw new UnsupportedOperationException("Quad: object cannot be null");
        }
        this.graph = g;
        this.subject = s;
        this.predicate = p;
        this.object = o;
    }

    public static Quad create(Node g, Node s, Node p, Node o) {
        return new Quad(g, s, p, o);
    }

    public static Quad create(Node g, Triple t) {
        return new Quad(g, t);
    }

    public final Node getGraph() {
        return this.graph;
    }

    public final Node getSubject() {
        return this.subject;
    }

    public final Node getPredicate() {
        return this.predicate;
    }

    public final Node getObject() {
        return this.object;
    }

    public Triple asTriple() {
        return new Triple(this.subject, this.predicate, this.object);
    }

    public boolean isConcrete() {
        return this.subject.isConcrete() && this.predicate.isConcrete() && this.object.isConcrete() && this.graph.isConcrete();
    }

    public static boolean isDefaultGraphGenerated(Node node) {
        return defaultGraphNodeGenerated.equals((Object)node);
    }

    public static boolean isDefaultGraphExplicit(Node node) {
        return defaultGraphIRI.equals((Object)node);
    }

    public static boolean isDefaultGraph(Node node) {
        return Quad.isDefaultGraphGenerated(node) || Quad.isDefaultGraphExplicit(node);
    }

    public static boolean isUnionGraph(Node node) {
        return unionGraph.equals((Object)node);
    }

    public boolean isDefaultGraphExplicit() {
        return Quad.isDefaultGraphExplicit(this.getGraph());
    }

    public boolean isDefaultGraphGenerated() {
        return Quad.isDefaultGraphGenerated(this.getGraph());
    }

    public boolean isDefaultGraph() {
        return Quad.isDefaultGraph(this.getGraph());
    }

    public boolean isUnionGraph() {
        return Quad.isUnionGraph(this.graph);
    }

    public boolean isTriple() {
        return Lib.equal(this.graph, tripleInQuad);
    }

    public boolean isLegalAsData() {
        Node sNode = this.getSubject();
        Node pNode = this.getPredicate();
        Node oNode = this.getObject();
        Node gNode = this.getGraph();
        if (sNode.isLiteral() || sNode.isVariable()) {
            return false;
        }
        if (!pNode.isURI()) {
            return false;
        }
        if (oNode.isVariable()) {
            return false;
        }
        return gNode == null || gNode.isURI();
    }

    public int hashCode() {
        int x = this.subject.hashCode() >> 1 ^ this.predicate.hashCode() ^ this.object.hashCode() << 1;
        x = this.graph != null ? (x ^= this.graph.hashCode() >> 2) : ++x;
        return x;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Quad)) {
            return false;
        }
        Quad quad = (Quad)other;
        if (!Lib.equal(this.graph, quad.graph)) {
            return false;
        }
        if (!this.subject.equals((Object)quad.subject)) {
            return false;
        }
        if (!this.predicate.equals((Object)quad.predicate)) {
            return false;
        }
        return this.object.equals((Object)quad.object);
    }

    public boolean matches(Node g, Node s, Node p, Node o) {
        return Quad.nodeMatches(this.getGraph(), g) && Quad.nodeMatches(this.getSubject(), s) && Quad.nodeMatches(this.getPredicate(), p) && Quad.nodeMatches(this.getObject(), o);
    }

    private static boolean nodeMatches(Node thisNode, Node otherNode) {
        return otherNode.matches(thisNode);
    }

    public String toString() {
        String str2 = this.graph == null ? "_" : this.graph.toString();
        return "[" + str2 + " " + this.subject.toString() + " " + this.predicate.toString() + " " + this.object.toString() + "]";
    }
}

