/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import aterm.ATermAppl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;

public class TaxonomyUtils {
    public static final Object INSTANCES_KEY = new Object();
    public static final Object SUPER_EXPLANATION_KEY = new Object();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean addSuperExplanation(Taxonomy<ATermAppl> taxonomy, ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        HashSet<Set<ATermAppl>> hashSet;
        HashMap<ATermAppl, HashSet<Set<ATermAppl>>> hashMap = (HashMap<ATermAppl, HashSet<Set<ATermAppl>>>)taxonomy.getDatum(aTermAppl, SUPER_EXPLANATION_KEY);
        if (hashMap == null) {
            if (!taxonomy.contains(aTermAppl)) throw new RuntimeException(aTermAppl + " is an unknown class!");
            hashMap = new HashMap<ATermAppl, HashSet<Set<ATermAppl>>>();
            taxonomy.putDatum(aTermAppl, SUPER_EXPLANATION_KEY, hashMap);
            hashSet = null;
        } else {
            hashSet = (HashSet<Set<ATermAppl>>)hashMap.get(aTermAppl2);
        }
        if (hashSet != null) return hashSet.add(set);
        hashSet = new HashSet<Set<ATermAppl>>();
        hashMap.put(aTermAppl2, hashSet);
        return hashSet.add(set);
    }

    public static void clearSuperExplanation(Taxonomy<ATermAppl> taxonomy, ATermAppl aTermAppl) {
        taxonomy.removeDatum(aTermAppl, SUPER_EXPLANATION_KEY);
    }

    public static void clearAllInstances(Taxonomy<?> taxonomy) {
        for (TaxonomyNode<?> taxonomyNode : taxonomy.getNodes()) {
            taxonomyNode.removeDatum(INSTANCES_KEY);
        }
    }

    public static <T, I> Set<I> getAllInstances(Taxonomy<T> taxonomy, T t) {
        Iterator<Object> iterator = taxonomy.depthFirstDatumOnly(t, INSTANCES_KEY);
        if (!iterator.hasNext()) {
            throw new RuntimeException(t + " is an unknown class!");
        }
        HashSet hashSet = new HashSet();
        do {
            Set set;
            if ((set = (Set)iterator.next()) == null) continue;
            hashSet.addAll(set);
        } while (iterator.hasNext());
        return Collections.unmodifiableSet(hashSet);
    }

    public static <T, I> Set<I> getDirectInstances(Taxonomy<T> taxonomy, T t) {
        Set set = (Set)taxonomy.getDatum(t, INSTANCES_KEY);
        if (set == null) {
            if (taxonomy.contains(t)) {
                return Collections.emptySet();
            }
            throw new RuntimeException(t + " is an unknown class!");
        }
        return Collections.unmodifiableSet(set);
    }

    public static Set<Set<ATermAppl>> getSuperExplanations(Taxonomy<ATermAppl> taxonomy, ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Map map = (Map)taxonomy.getDatum(aTermAppl, SUPER_EXPLANATION_KEY);
        if (map == null) {
            return null;
        }
        Set set = (Set)map.get(aTermAppl2);
        if (set == null) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<Set<T>> getTypes(Taxonomy<T> taxonomy, Object object, boolean bl) {
        HashSet<Set<T>> hashSet = new HashSet<Set<T>>();
        Iterator<Map.Entry<Set<T>, Object>> iterator = taxonomy.datumEquivalentsPair(INSTANCES_KEY);
        while (iterator.hasNext()) {
            Map.Entry<Set<T>, Object> entry = iterator.next();
            Set set = (Set)entry.getValue();
            if (set == null || !set.contains(object)) continue;
            hashSet.add(entry.getKey());
            if (bl) continue;
            T t = entry.getKey().iterator().next();
            hashSet.addAll(taxonomy.getSupers(t));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static boolean isType(Taxonomy<ATermAppl> taxonomy, ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Iterator<Object> iterator = taxonomy.depthFirstDatumOnly(aTermAppl2, INSTANCES_KEY);
        if (!iterator.hasNext()) {
            throw new RuntimeException(aTermAppl2 + " is an unknown class!");
        }
        do {
            Set set;
            if ((set = (Set)iterator.next()) == null || !set.contains(aTermAppl)) continue;
            return true;
        } while (iterator.hasNext());
        return false;
    }
}

