/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class QNameProvider {
    private static String OWL = "http://www.w3.org/2002/07/owl#";
    private static String RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    private static String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static String XSD = "http://www.w3.org/2001/XMLSchema#";
    private static String DC = "http://purl.org/dc/elements/1.1/";
    Map uriToPrefix = new Hashtable();
    Map prefixToUri = new Hashtable();

    public QNameProvider() {
        this.setMapping("owl", OWL);
        this.setMapping("rdf", RDF);
        this.setMapping("rdfs", RDFS);
        this.setMapping("xsd", XSD);
        this.setMapping("dc", DC);
    }

    public static boolean isNameStartChar(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public static boolean isNameChar(char c) {
        return QNameProvider.isNameStartChar(c) || Character.isDigit(c) || c == '.' || c == '-';
    }

    public static int findNameStartIndex(String string) {
        char[] cArray = string.toCharArray();
        int n = -1;
        boolean bl = false;
        for (int i = cArray.length - 1; i >= 0; --i) {
            char c = cArray[i];
            if (QNameProvider.isNameStartChar(c)) {
                n = i;
                bl = true;
                continue;
            }
            if (bl && !QNameProvider.isNameChar(c)) break;
        }
        return n;
    }

    public static int findLastNameIndex(String string) {
        char c;
        char[] cArray = string.toCharArray();
        int n = -1;
        int n2 = cArray.length - 1;
        while (n2 >= 0 && QNameProvider.isNameChar(c = cArray[n2])) {
            n = n2--;
        }
        return n;
    }

    public static int findNextNonNameIndex(String string, int n) {
        char c;
        char[] cArray = string.toCharArray();
        int n2 = n;
        for (n2 = n; n2 < cArray.length && QNameProvider.isNameChar(c = cArray[n2]); ++n2) {
        }
        return n2;
    }

    protected static String[] splitURI(String string) {
        String string2;
        String string3;
        String[] stringArray = new String[3];
        int n = QNameProvider.findLastNameIndex(string);
        if (n < 0) {
            return null;
        }
        String string4 = string.substring(n);
        if (n == 0) {
            string3 = "";
            string2 = "a";
        } else {
            string3 = string.substring(0, n);
            int n2 = QNameProvider.findNameStartIndex(string3);
            if (n2 < 0) {
                string2 = "b";
            } else {
                int n3 = QNameProvider.findNextNonNameIndex(string3, n2 + 1);
                string2 = string.substring(n2, n3);
            }
        }
        stringArray[0] = string3;
        stringArray[1] = string2;
        stringArray[2] = string4;
        return stringArray;
    }

    public String getPrefix(String string) {
        return (String)this.uriToPrefix.get(string);
    }

    public String getURI(String string) {
        return (String)this.prefixToUri.get(string);
    }

    public boolean setMapping(String string, String string2) {
        String string3 = this.getURI(string);
        if (string3 == null) {
            this.prefixToUri.put(string, string2);
            this.uriToPrefix.put(string2, string);
            return true;
        }
        return string3.equals(string2);
    }

    public Set getPrefixSet() {
        return this.prefixToUri.keySet();
    }

    public Set getURISet() {
        return this.uriToPrefix.keySet();
    }

    public String shortForm(URI uRI) {
        return this.shortForm(uRI.toString());
    }

    public String shortForm(String string) {
        return this.shortForm(string, true);
    }

    public String shortForm(String string, boolean bl) {
        String string2;
        String[] stringArray = QNameProvider.splitURI(string);
        if (stringArray == null) {
            if (bl) {
                return string;
            }
            return null;
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        if (string4.endsWith(".owl") || string4.endsWith(".rdf") || string4.endsWith(".xml")) {
            string4 = string4.substring(0, string4.length() - 4);
        }
        if (string4.length() > 1 && !Character.isUpperCase(string4.charAt(1))) {
            string4 = Character.toLowerCase(string4.charAt(0)) + string4.substring(1, string4.length());
        }
        if ((string2 = this.getPrefix(string3)) == null) {
            string2 = string4;
            int n = 0;
            while (!this.setMapping(string2, string3)) {
                string2 = string4 + n;
                ++n;
            }
        }
        String string6 = string2 + ":" + string5;
        return string6;
    }

    public String longForm(String string) {
        String[] stringArray = string.split(":");
        return this.getURI(stringArray[0]) + stringArray[1];
    }

    public String toString() {
        return this.prefixToUri.toString();
    }
}

