/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.taxonomy.DefinitionOrder;
import org.mindswap.pellet.taxonomy.DefinitionOrderFactory;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MemUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.iterator.IteratorUtils;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.mindswap.pellet.utils.progress.SilentProgressMonitor;

public class CDOptimizedTaxonomyBuilder
implements TaxonomyBuilder {
    protected static Logger log = Logger.getLogger(Taxonomy.class.getName());
    protected ProgressMonitor monitor = PelletOptions.USE_CLASSIFICATION_MONITOR.create();
    private static final Set<ConceptFlag> PHASE1_FLAGS = EnumSet.of(ConceptFlag.COMPLETELY_DEFINED, ConceptFlag.PRIMITIVE, ConceptFlag.OTHER);
    protected Collection<ATermAppl> classes;
    private Map<ATermAppl, Set<ATermAppl>> toldDisjoints;
    private Map<ATermAppl, ATermList> unionClasses;
    private DefinitionOrder definitionOrder;
    protected Taxonomy<ATermAppl> toldTaxonomy;
    protected Taxonomy<ATermAppl> taxonomy;
    protected KnowledgeBase kb;
    private boolean useCD;
    private List<TaxonomyNode<ATermAppl>> markedNodes;
    private Map<ATermAppl, ConceptFlag> conceptFlags;
    private boolean prepared = false;

    @Override
    public void setKB(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    @Override
    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor == null ? new SilentProgressMonitor() : progressMonitor;
    }

    @Override
    public Taxonomy<ATermAppl> getTaxonomy() {
        return this.taxonomy;
    }

    @Override
    public Taxonomy<ATermAppl> getToldTaxonomy() {
        if (!this.prepared) {
            this.reset();
            this.computeToldInformation();
        }
        return this.toldTaxonomy;
    }

    @Override
    public Map<ATermAppl, Set<ATermAppl>> getToldDisjoints() {
        if (!this.prepared) {
            this.reset();
            this.computeToldInformation();
        }
        return this.toldDisjoints;
    }

    @Override
    public boolean classify() {
        Iterator<Object> iterator;
        Iterator iterator2;
        this.classes = this.kb.getClasses();
        int n = this.classes.size();
        if (!this.classes.contains(ATermUtils.TOP)) {
            ++n;
        }
        if (!this.classes.contains(ATermUtils.BOTTOM)) {
            ++n;
        }
        this.monitor.setProgressTitle("Classifying");
        this.monitor.setProgressLength(n);
        this.monitor.taskStarted();
        if (this.classes.isEmpty()) {
            this.taxonomy = new Taxonomy<ATermAppl>(null, ATermUtils.TOP, ATermUtils.BOTTOM);
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            this.kb.timers.createTimer("classifySub");
            log.fine("Classes: " + n + " Individuals: " + this.kb.getIndividuals().size());
        }
        if (!this.prepared) {
            iterator2 = this.kb.timers.startTimer("taxBuilder.prepare");
            this.prepare();
            ((Timer)((Object)iterator2)).stop();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Starting classification...");
        }
        if (this.useCD) {
            ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
            ArrayList<ATermAppl> arrayList2 = new ArrayList<ATermAppl>();
            for (ATermAppl aTermAppl : this.definitionOrder) {
                if (PHASE1_FLAGS.contains((Object)this.conceptFlags.get(aTermAppl))) {
                    arrayList.add(aTermAppl);
                    continue;
                }
                arrayList2.add(aTermAppl);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Using CD classification with phase1: " + arrayList.size() + " phase2: " + arrayList2.size());
                this.logList(Level.FINER, "Phase 1", arrayList);
                this.logList(Level.FINER, "Phase 2", arrayList2);
            }
            iterator2 = arrayList.iterator();
            iterator = arrayList2.iterator();
        } else {
            iterator2 = IteratorUtils.emptyIterator();
            iterator = this.definitionOrder.iterator();
            if (log.isLoggable(Level.FINE)) {
                log.fine("CD classification disabled");
            }
        }
        boolean bl = true;
        bl = bl && this.classify(iterator2, false);
        bl = bl && this.classify(iterator, true);
        this.monitor.taskFinished();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Satisfiability Count: " + (this.kb.getABox().stats.satisfiabilityCount - (long)(2 * this.kb.getClasses().size())));
        }
        this.definitionOrder = null;
        this.taxonomy.assertValid();
        if (log.isLoggable(Level.FINER)) {
            log.finer("Tax size : " + this.taxonomy.getNodes().size());
            log.finer("Tax depth: " + this.taxonomy.depth);
            log.finer("Branching: " + (double)this.taxonomy.totalBranching / (double)this.taxonomy.getNodes().size());
            log.finer("Leaf size: " + this.taxonomy.getBottom().getSupers().size());
        }
        return bl;
    }

    private void logList(Level level, String string, List<ATermAppl> list) {
        if (!log.isLoggable(Level.FINER)) {
            return;
        }
        log.log(level, string);
        int n = 0;
        for (ATermAppl aTermAppl : list) {
            log.log(level, n + ") " + aTermAppl);
            ++n;
        }
    }

    protected boolean classify(Iterator<ATermAppl> iterator, boolean bl) {
        while (iterator.hasNext()) {
            ATermAppl aTermAppl = iterator.next();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Classify (" + this.taxonomy.getNodes().size() + ") " + this.format(aTermAppl) + "...");
            }
            this.classify(aTermAppl, bl);
            this.monitor.incrementProgress();
            this.kb.timers.getTimer("classify").check();
            if (!this.monitor.isCanceled()) continue;
            return false;
        }
        return true;
    }

    private void prepare() {
        this.reset();
        this.computeToldInformation();
        this.createDefinitionOrder();
        this.computeConceptFlags();
        this.prepared = true;
    }

    protected void reset() {
        this.kb.prepare();
        this.classes = new ArrayList<ATermAppl>(this.kb.getClasses());
        this.useCD = PelletOptions.USE_CD_CLASSIFICATION && !this.kb.getTBox().unfold(ATermUtils.TOP).hasNext() && !this.kb.getExpressivity().hasNominal();
        this.toldDisjoints = CollectionUtils.makeIdentityMap();
        this.unionClasses = CollectionUtils.makeIdentityMap();
        this.markedNodes = CollectionUtils.makeList();
        this.taxonomy = new Taxonomy<ATermAppl>(null, ATermUtils.TOP, ATermUtils.BOTTOM);
        this.toldTaxonomy = new Taxonomy();
        this.definitionOrder = null;
        this.conceptFlags = CollectionUtils.makeIdentityMap();
    }

    private void computeToldInformation() {
        ATermAppl aTermAppl;
        Object object;
        Object object2;
        Timer timer = this.kb.timers.startTimer("computeToldInformation");
        this.toldTaxonomy = new Taxonomy<ATermAppl>(this.classes, ATermUtils.TOP, ATermUtils.BOTTOM);
        TBox tBox = this.kb.getTBox();
        Collection<ATermAppl> collection = tBox.getAxioms();
        for (ATermAppl aTermAppl2 : collection) {
            boolean bl;
            object2 = (ATermAppl)aTermAppl2.getArgument(0);
            object = (ATermAppl)aTermAppl2.getArgument(1);
            boolean bl2 = aTermAppl2.getAFun().equals(ATermUtils.EQCLASSFUN);
            aTermAppl = tBox.getAxiomExplanation(aTermAppl2);
            boolean bl3 = bl = !ATermUtils.isPrimitive((ATermAppl)object2) && ATermUtils.isPrimitive((ATermAppl)object);
            if (bl2 && bl) {
                this.addToldRelation((ATermAppl)object, (ATermAppl)object2, bl2, (Set<ATermAppl>)aTermAppl);
                continue;
            }
            this.addToldRelation((ATermAppl)object2, (ATermAppl)object, bl2, (Set<ATermAppl>)aTermAppl);
        }
        for (ATermAppl aTermAppl2 : this.unionClasses.keySet()) {
            object2 = new ArrayList();
            object = this.unionClasses.get(aTermAppl2);
            while (!object.isEmpty()) {
                object2.add((ATermAppl)object.getFirst());
                object = object.getNext();
            }
            object = this.toldTaxonomy.computeLCA((List<ATermAppl>)object2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                aTermAppl = (ATermAppl)iterator.next();
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Union subsumption " + this.format(aTermAppl2) + " " + this.format(aTermAppl));
                }
                this.addToldSubsumer(aTermAppl2, aTermAppl);
            }
        }
        this.unionClasses = null;
        this.toldTaxonomy.assertValid();
        timer.stop();
    }

    private void createDefinitionOrder() {
        this.definitionOrder = DefinitionOrderFactory.createDefinitionOrder(this.kb);
    }

    private void computeConceptFlags() {
        if (!this.useCD) {
            return;
        }
        for (Role object2 : this.kb.getRBox().getRoles()) {
            for (ATermAppl aTermAppl : object2.getDomains()) {
                ATermList aTermList;
                if (ATermUtils.isPrimitive(aTermAppl)) {
                    this.conceptFlags.put(aTermAppl, ConceptFlag.OTHER);
                    continue;
                }
                if (ATermUtils.isAnd(aTermAppl)) {
                    aTermList = (ATermList)aTermAppl.getArgument(0);
                    while (!aTermList.isEmpty()) {
                        ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
                        if (ATermUtils.isPrimitive(aTermAppl2)) {
                            this.conceptFlags.put(aTermAppl2, ConceptFlag.OTHER);
                        }
                        aTermList = aTermList.getNext();
                    }
                    continue;
                }
                if (!ATermUtils.isNot(aTermAppl) || !ATermUtils.isAnd((ATermAppl)aTermAppl.getArgument(0))) continue;
                aTermList = (ATermList)((ATermAppl)aTermAppl.getArgument(0)).getArgument(0);
                while (!aTermList.isEmpty()) {
                    ATermAppl aTermAppl3 = (ATermAppl)aTermList.getFirst();
                    if (ATermUtils.isNegatedPrimitive(aTermAppl3)) {
                        this.conceptFlags.put((ATermAppl)aTermAppl3.getArgument(0), ConceptFlag.OTHER);
                    }
                    aTermList = aTermList.getNext();
                }
            }
        }
        TBox tBox = this.kb.getTBox();
        for (Object object : this.definitionOrder) {
            ConceptFlag conceptFlag;
            Iterator<Unfolding> iterator = this.kb.getTBox().unfold((ATermAppl)object);
            if (!tBox.isPrimitive((ATermAppl)object) || this.definitionOrder.isCyclic((ATermAppl)object) || this.toldTaxonomy.getAllEquivalents((ATermAppl)object).size() > 1) {
                this.conceptFlags.put((ATermAppl)object, ConceptFlag.NONPRIMITIVE);
                while (iterator.hasNext()) {
                    Unfolding unfolding = iterator.next();
                    for (ATermAppl aTermAppl : ATermUtils.findPrimitives(unfolding.getResult())) {
                        conceptFlag = this.conceptFlags.get(aTermAppl);
                        if (conceptFlag != null && conceptFlag != ConceptFlag.COMPLETELY_DEFINED) continue;
                        this.conceptFlags.put(aTermAppl, ConceptFlag.PRIMITIVE);
                    }
                }
                continue;
            }
            boolean bl = false;
            for (ATermAppl aTermAppl : this.toldTaxonomy.getFlattenedSupers((ATermAppl)object, true)) {
                conceptFlag = this.conceptFlags.get(aTermAppl);
                if (conceptFlag != ConceptFlag.NONPRIMITIVE && conceptFlag != ConceptFlag.NONPRIMITIVE_TA) continue;
                this.conceptFlags.put((ATermAppl)object, ConceptFlag.NONPRIMITIVE_TA);
                bl = true;
                break;
            }
            if (bl || this.conceptFlags.get(object) != null) continue;
            this.conceptFlags.put((ATermAppl)object, this.isCDDesc(iterator) ? ConceptFlag.COMPLETELY_DEFINED : ConceptFlag.PRIMITIVE);
        }
        if (log.isLoggable(Level.FINE)) {
            int[] nArray = new int[ConceptFlag.values().length];
            Arrays.fill(nArray, 0);
            for (ATermAppl aTermAppl : this.classes) {
                int n = this.conceptFlags.get(aTermAppl).ordinal();
                nArray[n] = nArray[n] + 1;
            }
            log.fine("Concept flags:");
            for (ConceptFlag conceptFlag : ConceptFlag.values()) {
                log.fine("\t" + conceptFlag + " = " + nArray[conceptFlag.ordinal()]);
            }
        }
    }

    private void clearMarks() {
        for (TaxonomyNode<ATermAppl> taxonomyNode : this.markedNodes) {
            taxonomyNode.mark = null;
        }
        this.markedNodes.clear();
    }

    private boolean isCDDesc(Iterator<Unfolding> iterator) {
        while (iterator.hasNext()) {
            Unfolding unfolding = iterator.next();
            if (this.isCDDesc(unfolding.getResult())) continue;
            return false;
        }
        return true;
    }

    private boolean isCDDesc(ATermAppl aTermAppl) {
        ATermAppl aTermAppl2;
        if (aTermAppl == null) {
            return true;
        }
        if (ATermUtils.isPrimitive(aTermAppl)) {
            return true;
        }
        if (ATermUtils.isAllValues(aTermAppl)) {
            return true;
        }
        if (ATermUtils.isAnd(aTermAppl)) {
            ATermList aTermList;
            boolean bl = true;
            ATermList aTermList2 = aTermList = (ATermList)aTermAppl.getArgument(0);
            while (bl && !aTermList2.isEmpty()) {
                ATermAppl aTermAppl3 = (ATermAppl)aTermList2.getFirst();
                bl = this.isCDDesc(aTermAppl3);
                aTermList2 = aTermList2.getNext();
            }
            return bl;
        }
        return ATermUtils.isNot(aTermAppl) && ATermUtils.isPrimitive(aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0));
    }

    private void addToldRelation(ATermAppl aTermAppl, ATermAppl aTermAppl2, boolean bl, Set<ATermAppl> set) {
        ATermAppl aTermAppl3;
        if (!(bl || aTermAppl != ATermUtils.BOTTOM && aTermAppl2 != ATermUtils.TOP)) {
            return;
        }
        if (!ATermUtils.isPrimitive(aTermAppl)) {
            if (aTermAppl.getAFun().equals(ATermUtils.ORFUN)) {
                ATermList aTermList;
                ATermList aTermList2 = aTermList = (ATermList)aTermAppl.getArgument(0);
                while (!aTermList2.isEmpty()) {
                    ATermAppl aTermAppl4 = (ATermAppl)aTermList2.getFirst();
                    this.addToldRelation(aTermAppl4, aTermAppl2, false, set);
                    aTermList2 = aTermList2.getNext();
                }
            }
        } else if (ATermUtils.isPrimitive(aTermAppl2)) {
            if (ATermUtils.isBnode(aTermAppl2)) {
                return;
            }
            if (!bl) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Preclassify (1) " + this.format(aTermAppl) + " " + this.format(aTermAppl2));
                }
                this.addToldSubsumer(aTermAppl, aTermAppl2, set);
            } else {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Preclassify (2) " + this.format(aTermAppl) + " " + this.format(aTermAppl2));
                }
                this.addToldEquivalent(aTermAppl, aTermAppl2);
            }
        } else if (aTermAppl2.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList aTermList = (ATermList)aTermAppl2.getArgument(0);
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl5 = (ATermAppl)aTermList.getFirst();
                this.addToldRelation(aTermAppl, aTermAppl5, false, set);
                aTermList = aTermList.getNext();
            }
        } else if (aTermAppl2.getAFun().equals(ATermUtils.ORFUN)) {
            ATermList aTermList;
            boolean bl2 = true;
            ATermList aTermList3 = aTermList = (ATermList)aTermAppl2.getArgument(0);
            while (!aTermList3.isEmpty()) {
                ATermAppl aTermAppl6 = (ATermAppl)aTermList3.getFirst();
                if (ATermUtils.isPrimitive(aTermAppl6)) {
                    if (bl) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Preclassify (3) " + this.format(aTermAppl) + " " + this.format(aTermAppl6));
                        }
                        this.addToldSubsumer(aTermAppl6, aTermAppl);
                    }
                } else {
                    bl2 = false;
                }
                aTermList3 = aTermList3.getNext();
            }
            if (bl2) {
                this.unionClasses.put(aTermAppl, aTermList);
            }
        } else if (aTermAppl2.equals(ATermUtils.BOTTOM)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Preclassify (4) " + this.format(aTermAppl) + " BOTTOM");
            }
            this.addToldEquivalent(aTermAppl, ATermUtils.BOTTOM);
        } else if (aTermAppl2.getAFun().equals(ATermUtils.NOTFUN) && ATermUtils.isPrimitive(aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(0))) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Preclassify (5) " + this.format(aTermAppl) + " not " + this.format(aTermAppl3));
            }
            this.addToldDisjoint(aTermAppl, aTermAppl3);
            this.addToldDisjoint(aTermAppl3, aTermAppl);
        }
    }

    private void addToldEquivalent(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (aTermAppl.equals(aTermAppl2)) {
            return;
        }
        TaxonomyNode<ATermAppl> taxonomyNode = this.toldTaxonomy.getNode(aTermAppl);
        TaxonomyNode<ATermAppl> taxonomyNode2 = this.toldTaxonomy.getNode(aTermAppl2);
        this.toldTaxonomy.merge(taxonomyNode, taxonomyNode2);
        TaxonomyUtils.clearSuperExplanation(this.toldTaxonomy, aTermAppl);
    }

    private void addToldSubsumer(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.addToldSubsumer(aTermAppl, aTermAppl2, null);
    }

    private void addToldSubsumer(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        TaxonomyNode<ATermAppl> taxonomyNode = this.toldTaxonomy.getNode(aTermAppl);
        TaxonomyNode<ATermAppl> taxonomyNode2 = this.toldTaxonomy.getNode(aTermAppl2);
        if (taxonomyNode == null) {
            throw new InternalReasonerException(aTermAppl + " is not in the definition order");
        }
        if (taxonomyNode2 == null) {
            throw new InternalReasonerException(aTermAppl2 + " is not in the definition order");
        }
        if (taxonomyNode.equals(taxonomyNode2)) {
            return;
        }
        if (taxonomyNode.equals(this.toldTaxonomy.getTop())) {
            this.toldTaxonomy.merge(taxonomyNode, taxonomyNode2);
            TaxonomyUtils.clearSuperExplanation(this.toldTaxonomy, aTermAppl);
        } else {
            this.toldTaxonomy.addSuper(aTermAppl, aTermAppl2);
            this.toldTaxonomy.removeCycles(taxonomyNode);
            if (taxonomyNode.getEquivalents().size() > 1) {
                TaxonomyUtils.clearSuperExplanation(this.toldTaxonomy, aTermAppl);
            } else if (set != null && !set.isEmpty()) {
                TaxonomyUtils.addSuperExplanation(this.toldTaxonomy, aTermAppl, aTermAppl2, set);
            }
        }
    }

    private void addToldDisjoint(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Set<ATermAppl> set = this.toldDisjoints.get(aTermAppl);
        if (set == null) {
            set = new HashSet<ATermAppl>();
            this.toldDisjoints.put(aTermAppl, set);
        }
        set.add(aTermAppl2);
    }

    private void markToldSubsumers(ATermAppl aTermAppl) {
        TaxonomyNode<ATermAppl> taxonomyNode = this.taxonomy.getNode(aTermAppl);
        if (taxonomyNode != null) {
            boolean bl = this.mark(taxonomyNode, Boolean.TRUE, Propogate.UP);
            if (!bl) {
                return;
            }
        } else if (log.isLoggable(Level.FINE) && this.markedNodes.size() > 2) {
            log.warning("Told subsumer " + aTermAppl + " is not classified yet");
        }
        if (this.toldTaxonomy.contains(aTermAppl)) {
            for (ATermAppl aTermAppl2 : this.toldTaxonomy.getFlattenedSupers(aTermAppl, true)) {
                this.markToldSubsumers(aTermAppl2);
            }
        }
    }

    private void markToldSubsumeds(ATermAppl aTermAppl, Boolean bl) {
        boolean bl2;
        TaxonomyNode<ATermAppl> taxonomyNode = this.taxonomy.getNode(aTermAppl);
        if (taxonomyNode != null && !(bl2 = this.mark(taxonomyNode, bl, Propogate.DOWN))) {
            return;
        }
        if (this.toldTaxonomy.contains(aTermAppl)) {
            for (ATermAppl aTermAppl2 : this.toldTaxonomy.getFlattenedSubs(aTermAppl, true)) {
                this.markToldSubsumeds(aTermAppl2, bl);
            }
        }
    }

    private void markToldDisjoints(Collection<ATermAppl> collection, boolean bl) {
        Object object;
        ATermAppl aTermAppl2;
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        hashSet.addAll(collection);
        for (ATermAppl object22 : collection) {
            if (this.taxonomy.contains(object22)) {
                hashSet.addAll(this.taxonomy.getFlattenedSupers(object22, false));
            }
            if (!this.toldTaxonomy.contains(object22)) continue;
            hashSet.addAll(this.toldTaxonomy.getFlattenedSupers(object22, false));
        }
        HashSet hashSet2 = new HashSet();
        for (ATermAppl aTermAppl2 : hashSet) {
            object = this.toldDisjoints.get(aTermAppl2);
            if (object == null) continue;
            hashSet2.addAll(object);
        }
        if (bl) {
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                aTermAppl2 = (ATermAppl)iterator.next();
                object = this.taxonomy.getNode(aTermAppl2);
                if (object == null) continue;
                this.mark((TaxonomyNode<ATermAppl>)object, Boolean.FALSE, Propogate.NONE);
            }
        } else {
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                aTermAppl2 = (ATermAppl)iterator.next();
                this.markToldSubsumeds(aTermAppl2, Boolean.FALSE);
            }
        }
    }

    private TaxonomyNode<ATermAppl> checkSatisfiability(ATermAppl aTermAppl) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Satisfiable ");
        }
        Timer timer = this.kb.timers.startTimer("classifySat");
        boolean bl = this.kb.getABox().isSatisfiable(aTermAppl, true);
        timer.stop();
        if (log.isLoggable(Level.FINER)) {
            log.finer((bl ? "true" : "*****FALSE*****") + " (" + timer.getLast() + "ms)");
        }
        if (!bl) {
            this.taxonomy.addEquivalentNode(aTermAppl, this.taxonomy.getBottom());
        }
        if (PelletOptions.USE_CACHING) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("...negation ");
            }
            timer = this.kb.timers.startTimer("classifySatNot");
            ATermAppl aTermAppl2 = ATermUtils.makeNot((ATerm)aTermAppl);
            bl = this.kb.getABox().isSatisfiable(aTermAppl2, true);
            timer.stop();
            if (!bl) {
                this.taxonomy.addEquivalentNode(aTermAppl, this.taxonomy.getTop());
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(bl + " (" + timer.getLast() + "ms)");
            }
        }
        return this.taxonomy.getNode(aTermAppl);
    }

    @Override
    public void classify(ATermAppl aTermAppl) {
        this.classify(aTermAppl, true);
    }

    private TaxonomyNode<ATermAppl> classify(ATermAppl aTermAppl, boolean bl) {
        Object object;
        List<ATermAppl> list;
        boolean bl2;
        List<TaxonomyNode<ATermAppl>> list2;
        boolean bl3;
        TaxonomyNode<ATermAppl> taxonomyNode = this.taxonomy.getNode(aTermAppl);
        if (taxonomyNode != null) {
            return taxonomyNode;
        }
        taxonomyNode = this.checkSatisfiability(aTermAppl);
        if (taxonomyNode != null) {
            return taxonomyNode;
        }
        this.clearMarks();
        ConceptFlag conceptFlag = this.conceptFlags.get(aTermAppl);
        if (conceptFlag == null) {
            conceptFlag = ConceptFlag.OTHER;
        }
        boolean bl4 = bl3 = !bl && this.useCD && conceptFlag == ConceptFlag.COMPLETELY_DEFINED;
        if (bl3) {
            list2 = this.getCDSupers(aTermAppl);
            bl2 = true;
        } else {
            list2 = this.doTopSearch(aTermAppl);
            bl2 = this.useCD && (conceptFlag == ConceptFlag.PRIMITIVE || conceptFlag == ConceptFlag.COMPLETELY_DEFINED);
        }
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        for (TaxonomyNode<ATermAppl> object22 : list2) {
            arrayList.add(object22.getName());
        }
        if (bl2) {
            list = Collections.singletonList(ATermUtils.BOTTOM);
        } else {
            if (list2.size() == 1) {
                object = list2.iterator().next();
                ATermAppl aTermAppl2 = (ATermAppl)((TaxonomyNode)object).getName();
                Iterator<TaxonomyNode<ATermAppl>> iterator = this.kb.timers.startTimer("eqCheck");
                boolean bl5 = this.subsumes(aTermAppl, aTermAppl2);
                ((Timer)((Object)iterator)).stop();
                if (bl5) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(this.format(aTermAppl) + " = " + this.format(aTermAppl2));
                    }
                    this.taxonomy.addEquivalentNode(aTermAppl, (TaxonomyNode<ATermAppl>)object);
                    return object;
                }
            }
            List<TaxonomyNode<ATermAppl>> list3 = this.doBottomSearch(aTermAppl, list2);
            list = new ArrayList<ATermAppl>();
            for (TaxonomyNode<ATermAppl> taxonomyNode2 : list3) {
                list.add(taxonomyNode2.getName());
            }
        }
        taxonomyNode = this.taxonomy.addNode(Collections.singleton(aTermAppl), arrayList, list, !ATermUtils.isPrimitive(aTermAppl));
        object = this.toldTaxonomy.getNode(aTermAppl);
        if (object != null) {
            TaxonomyNode<ATermAppl> taxonomyNode3 = this.toldTaxonomy.getNode(aTermAppl);
            for (ATermAppl aTermAppl3 : taxonomyNode3.getEquivalents()) {
                this.taxonomy.addEquivalentNode(aTermAppl3, taxonomyNode);
            }
            for (TaxonomyNode<ATermAppl> taxonomyNode4 : list2) {
                Set<Set<ATermAppl>> set = TaxonomyUtils.getSuperExplanations(this.toldTaxonomy, aTermAppl, taxonomyNode4.getName());
                if (set == null) continue;
                for (Set<ATermAppl> set2 : set) {
                    if (set2.isEmpty()) continue;
                    TaxonomyUtils.addSuperExplanation(this.taxonomy, aTermAppl, taxonomyNode4.getName(), set2);
                }
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Subsumption Count: " + this.kb.getABox().stats.satisfiabilityCount);
        }
        return taxonomyNode;
    }

    private List<TaxonomyNode<ATermAppl>> doBottomSearch(ATermAppl aTermAppl, List<TaxonomyNode<ATermAppl>> list) {
        HashSet<TaxonomyNode<ATermAppl>> hashSet = new HashSet<TaxonomyNode<ATermAppl>>();
        for (TaxonomyNode<ATermAppl> object2 : list) {
            this.collectLeafs(object2, hashSet);
        }
        if (hashSet.isEmpty()) {
            return Collections.singletonList(this.taxonomy.getBottom());
        }
        this.clearMarks();
        this.mark(this.taxonomy.getTop(), Boolean.FALSE, Propogate.NONE);
        this.taxonomy.getBottom().mark = Boolean.TRUE;
        this.markToldSubsumeds(aTermAppl, Boolean.TRUE);
        for (TaxonomyNode<ATermAppl> taxonomyNode : list) {
            this.mark(taxonomyNode, Boolean.FALSE, Propogate.NONE);
        }
        log.finer("Bottom search...");
        ArrayList arrayList = new ArrayList();
        HashSet<TaxonomyNode<ATermAppl>> hashSet2 = new HashSet<TaxonomyNode<ATermAppl>>();
        for (TaxonomyNode taxonomyNode : hashSet) {
            if (!this.subsumed(taxonomyNode, aTermAppl)) continue;
            this.search(false, aTermAppl, taxonomyNode, hashSet2, arrayList);
        }
        if (arrayList.isEmpty()) {
            return Collections.singletonList(this.taxonomy.getBottom());
        }
        return arrayList;
    }

    private void collectLeafs(TaxonomyNode<ATermAppl> taxonomyNode, Collection<TaxonomyNode<ATermAppl>> collection) {
        for (TaxonomyNode<ATermAppl> taxonomyNode2 : taxonomyNode.getSubs()) {
            if (taxonomyNode2.isLeaf()) {
                collection.add(taxonomyNode2);
                continue;
            }
            this.collectLeafs(taxonomyNode2, collection);
        }
    }

    private List<TaxonomyNode<ATermAppl>> doTopSearch(ATermAppl aTermAppl) {
        ArrayList<TaxonomyNode<ATermAppl>> arrayList = new ArrayList<TaxonomyNode<ATermAppl>>();
        this.mark(this.taxonomy.getTop(), Boolean.TRUE, Propogate.NONE);
        this.taxonomy.getBottom().mark = Boolean.FALSE;
        this.markToldSubsumers(aTermAppl);
        this.markToldDisjoints(Collections.singleton(aTermAppl), true);
        log.finer("Top search...");
        this.search(true, aTermAppl, this.taxonomy.getTop(), new HashSet<TaxonomyNode<ATermAppl>>(), arrayList);
        return arrayList;
    }

    private List<TaxonomyNode<ATermAppl>> getCDSupers(ATermAppl aTermAppl) {
        ArrayList<TaxonomyNode<ATermAppl>> arrayList = new ArrayList<TaxonomyNode<ATermAppl>>();
        TaxonomyNode<ATermAppl> taxonomyNode = this.toldTaxonomy.getNode(aTermAppl);
        assert (taxonomyNode != null);
        Collection<TaxonomyNode<ATermAppl>> collection = taxonomyNode.getSupers();
        int n = collection.size();
        if (n == 1) {
            for (TaxonomyNode<ATermAppl> taxonomyNode2 : collection) {
                if (taxonomyNode2 == this.toldTaxonomy.getTop()) continue;
                TaxonomyNode<ATermAppl> taxonomyNode3 = this.taxonomy.getNode(taxonomyNode2.getName());
                if (taxonomyNode3 == null) {
                    log.warning("Possible tautological definition, assuming " + this.format(taxonomyNode2.getName()) + " is equivalent to " + this.format(ATermUtils.TOP));
                    if (!log.isLoggable(Level.FINE)) break;
                    log.fine("Told subsumer of " + this.format(aTermAppl) + "  is not classified: " + this.format(taxonomyNode2.getName()));
                    break;
                }
                arrayList.add(taxonomyNode3);
                break;
            }
        } else {
            TaxonomyNode<ATermAppl> taxonomyNode4;
            for (TaxonomyNode<ATermAppl> taxonomyNode5 : collection) {
                if (taxonomyNode5 == this.toldTaxonomy.getTop()) continue;
                taxonomyNode4 = this.taxonomy.getNode(taxonomyNode5.getName());
                if (taxonomyNode4 == null) {
                    log.warning("Possible tautological definition, assuming " + this.format(taxonomyNode5.getName()) + " is equivalent to " + this.format(ATermUtils.TOP));
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Told subsumer of " + this.format(aTermAppl) + "  is not classified: " + this.format(taxonomyNode5.getName()));
                    continue;
                }
                for (TaxonomyNode<ATermAppl> taxonomyNode6 : taxonomyNode4.getSupers()) {
                    this.mark(taxonomyNode6, Boolean.TRUE, Propogate.UP);
                }
            }
            for (TaxonomyNode<ATermAppl> taxonomyNode5 : collection) {
                if (taxonomyNode5 == this.toldTaxonomy.getTop()) continue;
                taxonomyNode4 = this.taxonomy.getNode(taxonomyNode5.getName());
                if (taxonomyNode4.mark != null) continue;
                arrayList.add(taxonomyNode4);
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("...completely defined by " + taxonomyNode4.getName().getName());
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(this.taxonomy.getTop());
        }
        return arrayList;
    }

    private Collection<TaxonomyNode<ATermAppl>> search(boolean bl, ATermAppl aTermAppl, TaxonomyNode<ATermAppl> taxonomyNode, Set<TaxonomyNode<ATermAppl>> set, List<TaxonomyNode<ATermAppl>> list) {
        Timer timer = this.kb.timers.startTimer("search" + (bl ? "Top" : "Bottom"));
        ArrayList<TaxonomyNode<ATermAppl>> arrayList = new ArrayList<TaxonomyNode<ATermAppl>>();
        set.add(taxonomyNode);
        Collection<TaxonomyNode<ATermAppl>> collection = bl ? taxonomyNode.getSubs() : taxonomyNode.getSupers();
        for (TaxonomyNode<Object> taxonomyNode2 : collection) {
            if (bl) {
                if (!this.subsumes(taxonomyNode2, aTermAppl)) continue;
                arrayList.add(taxonomyNode2);
                continue;
            }
            if (!this.subsumed(taxonomyNode2, aTermAppl)) continue;
            arrayList.add(taxonomyNode2);
        }
        if (arrayList.isEmpty()) {
            list.add(taxonomyNode);
        } else {
            for (TaxonomyNode<Object> taxonomyNode2 : arrayList) {
                if (set.contains(taxonomyNode2)) continue;
                this.search(bl, aTermAppl, taxonomyNode2, set, list);
            }
        }
        timer.stop();
        return list;
    }

    private boolean subCheckWithCache(TaxonomyNode<ATermAppl> taxonomyNode, ATermAppl aTermAppl, boolean bl) {
        Collection<TaxonomyNode<ATermAppl>> collection;
        Boolean bl2 = taxonomyNode.mark;
        if (bl2 != null) {
            return bl2;
        }
        Collection<TaxonomyNode<ATermAppl>> collection2 = collection = bl ? taxonomyNode.getSupers() : taxonomyNode.getSubs();
        if (collection.size() > 1) {
            LinkedHashMap<Object, TaxonomyNode> linkedHashMap = new LinkedHashMap<Object, TaxonomyNode>();
            linkedHashMap.put(taxonomyNode, null);
            LinkedHashMap<TaxonomyNode, Object> linkedHashMap2 = new LinkedHashMap<TaxonomyNode, Object>();
            for (TaxonomyNode<ATermAppl> taxonomyNode2 : collection) {
                linkedHashMap2.put(taxonomyNode2, taxonomyNode);
            }
            while (!linkedHashMap2.isEmpty()) {
                Object object;
                TaxonomyNode taxonomyNode3 = (TaxonomyNode)linkedHashMap2.keySet().iterator().next();
                TaxonomyNode taxonomyNode2 = (TaxonomyNode)linkedHashMap2.get(taxonomyNode3);
                Boolean bl3 = taxonomyNode3.mark;
                if (Boolean.FALSE.equals(bl3)) {
                    object = taxonomyNode2;
                    while (object != null) {
                        this.mark((TaxonomyNode<ATermAppl>)object, Boolean.FALSE, Propogate.NONE);
                        object = (TaxonomyNode)linkedHashMap.get(object);
                    }
                    return false;
                }
                if (bl3 == null) {
                    object = bl ? taxonomyNode3.getSupers() : taxonomyNode3.getSubs();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        TaxonomyNode taxonomyNode4 = (TaxonomyNode)iterator.next();
                        if (linkedHashMap.keySet().contains(taxonomyNode4) || linkedHashMap2.keySet().contains(taxonomyNode4)) continue;
                        linkedHashMap2.put(taxonomyNode4, taxonomyNode3);
                    }
                }
                linkedHashMap2.remove(taxonomyNode3);
                linkedHashMap.put(taxonomyNode3, taxonomyNode2);
            }
        }
        boolean bl4 = bl ? this.subsumes(taxonomyNode.getName(), aTermAppl) : this.subsumes(aTermAppl, taxonomyNode.getName());
        this.mark(taxonomyNode, bl4, Propogate.NONE);
        return bl4;
    }

    private boolean subsumes(TaxonomyNode<ATermAppl> taxonomyNode, ATermAppl aTermAppl) {
        return this.subCheckWithCache(taxonomyNode, aTermAppl, true);
    }

    private boolean subsumed(TaxonomyNode<ATermAppl> taxonomyNode, ATermAppl aTermAppl) {
        return this.subCheckWithCache(taxonomyNode, aTermAppl, false);
    }

    private boolean mark(TaxonomyNode<ATermAppl> taxonomyNode, Boolean bl, Propogate propogate) {
        if (taxonomyNode.getEquivalents().contains(ATermUtils.BOTTOM)) {
            return true;
        }
        if (taxonomyNode.mark != null) {
            if (!taxonomyNode.mark.equals(bl)) {
                throw new RuntimeException("Inconsistent classification result " + taxonomyNode.getName() + " " + taxonomyNode.mark + " " + bl);
            }
            return false;
        }
        taxonomyNode.mark = bl;
        this.markedNodes.add(taxonomyNode);
        if (propogate != Propogate.NONE) {
            Collection<TaxonomyNode<ATermAppl>> collection = propogate == Propogate.UP ? taxonomyNode.getSupers() : taxonomyNode.getSubs();
            for (TaxonomyNode<ATermAppl> taxonomyNode2 : collection) {
                this.mark(taxonomyNode2, bl, propogate);
            }
        }
        return true;
    }

    private boolean subsumes(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        long l = 0L;
        long l2 = 0L;
        if (log.isLoggable(Level.FINER)) {
            l = System.currentTimeMillis();
            l2 = this.kb.getABox().stats.satisfiabilityCount;
            log.finer("Subsumption testing for [" + this.format(aTermAppl2) + "," + this.format(aTermAppl) + "]...");
        }
        boolean bl = this.kb.getABox().isSubClassOf(aTermAppl2, aTermAppl);
        if (log.isLoggable(Level.FINER)) {
            String string = this.kb.getABox().stats.satisfiabilityCount > l2 ? "+" : "-";
            l = System.currentTimeMillis() - l;
            log.finer(" done (" + (bl ? "+" : "-") + ") (" + string + l + "ms)");
        }
        return bl;
    }

    private void mark(Set<ATermAppl> set, Map<ATermAppl, Boolean> map, Boolean bl) {
        for (ATermAppl aTermAppl : set) {
            map.put(aTermAppl, bl);
        }
    }

    @Override
    public boolean realize() {
        this.monitor.setProgressTitle("Realizing");
        return PelletOptions.REALIZE_INDIVIDUAL_AT_A_TIME ? this.realizeByIndividuals() : this.realizeByConcepts();
    }

    private boolean realizeByIndividuals() {
        this.monitor.setProgressLength(this.kb.getIndividuals().size());
        this.monitor.taskStarted();
        IndividualIterator individualIterator = this.kb.getABox().getIndIterator();
        int n = 0;
        while (individualIterator.hasNext()) {
            Individual individual = (Individual)individualIterator.next();
            this.monitor.incrementProgress();
            this.kb.timers.getTimer("realize").check();
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(n + ") Realizing " + this.format(individual.getName()) + " ");
            }
            HashMap<ATermAppl, Boolean> hashMap = new HashMap<ATermAppl, Boolean>();
            ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
            ArrayList<ATermAppl> arrayList2 = new ArrayList<ATermAppl>();
            this.kb.getABox().getObviousTypes(individual.getName(), arrayList, arrayList2);
            for (ATermAppl aTermAppl : arrayList) {
                if (!this.taxonomy.contains(aTermAppl)) continue;
                this.mark(this.taxonomy.getAllEquivalents(aTermAppl), hashMap, Boolean.TRUE);
                this.mark(this.taxonomy.getFlattenedSupers(aTermAppl, true), hashMap, Boolean.TRUE);
            }
            for (ATermAppl aTermAppl : arrayList2) {
                this.mark(this.taxonomy.getAllEquivalents(aTermAppl), hashMap, Boolean.FALSE);
                this.mark(this.taxonomy.getFlattenedSubs(aTermAppl, true), hashMap, Boolean.FALSE);
            }
            this.realizeByIndividual(individual.getName(), ATermUtils.TOP, hashMap);
            ++n;
        }
        this.monitor.taskFinished();
        return true;
    }

    private boolean realizeByIndividual(ATermAppl aTermAppl, ATermAppl aTermAppl2, Map<ATermAppl, Boolean> map) {
        boolean bl;
        boolean bl2 = false;
        if (aTermAppl2.equals(ATermUtils.BOTTOM)) {
            return false;
        }
        if (map.containsKey(aTermAppl2)) {
            bl = map.get(aTermAppl2);
        } else {
            long l = 0L;
            long l2 = 0L;
            if (log.isLoggable(Level.FINER)) {
                l = System.currentTimeMillis();
                l2 = this.kb.getABox().stats.consistencyCount;
                log.finer("Type checking for [" + this.format(aTermAppl) + ", " + this.format(aTermAppl2) + "]...");
            }
            Timer timer = this.kb.timers.startTimer("classifyType");
            bl = this.kb.isType(aTermAppl, aTermAppl2);
            timer.stop();
            map.put(aTermAppl2, bl ? Boolean.TRUE : Boolean.FALSE);
            if (log.isLoggable(Level.FINER)) {
                String string = this.kb.getABox().stats.consistencyCount > l2 ? "+" : "-";
                l = System.currentTimeMillis() - l;
                log.finer("done (" + (bl ? "+" : "-") + ") (" + string + l + "ms)");
            }
        }
        if (bl) {
            TaxonomyNode<ATermAppl> taxonomyNode = this.taxonomy.getNode(aTermAppl2);
            for (TaxonomyNode<ATermAppl> taxonomyNode2 : taxonomyNode.getSubs()) {
                ATermAppl aTermAppl3 = taxonomyNode2.getName();
                bl2 = this.realizeByIndividual(aTermAppl, aTermAppl3, map) || bl2;
            }
            if (!bl2) {
                Set<Object> set = (Set)taxonomyNode.getDatum(TaxonomyUtils.INSTANCES_KEY);
                if (set == null) {
                    set = new HashSet<ATermAppl>();
                    taxonomyNode.putDatum(TaxonomyUtils.INSTANCES_KEY, set);
                }
                set.add(aTermAppl);
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean realizeByConcepts() {
        this.monitor.setProgressLength(this.classes.size() + 2);
        this.monitor.taskStarted();
        if (this.markedNodes == null) {
            this.markedNodes = CollectionUtils.makeList();
        } else {
            this.clearMarks();
        }
        Set<ATermAppl> set = this.kb.getIndividuals();
        if (!set.isEmpty()) {
            this.realizeByConcept(ATermUtils.TOP, set);
        }
        this.kb.timers.getTimer("realize").check();
        if (this.monitor.isCanceled()) {
            return false;
        }
        this.monitor.taskFinished();
        return true;
    }

    private Set<ATermAppl> realizeByConcept(ATermAppl aTermAppl, Collection<ATermAppl> collection) {
        if (aTermAppl.equals(ATermUtils.BOTTOM)) {
            return SetUtils.emptySet();
        }
        this.kb.timers.getTimer("realize").check();
        if (this.monitor.isCanceled()) {
            return null;
        }
        TaxonomyNode<ATermAppl> taxonomyNode = this.taxonomy.getNode(aTermAppl);
        if (taxonomyNode.mark == Boolean.TRUE) {
            return TaxonomyUtils.getAllInstances(this.taxonomy, aTermAppl);
        }
        this.monitor.incrementProgress();
        this.mark(taxonomyNode, Boolean.TRUE, Propogate.NONE);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Realizing concept " + aTermAppl);
        }
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(this.kb.retrieve(aTermAppl, collection));
        HashSet<ATermAppl> hashSet2 = new HashSet<ATermAppl>(hashSet);
        if (!hashSet.isEmpty()) {
            for (TaxonomyNode<ATermAppl> taxonomyNode2 : taxonomyNode.getSubs()) {
                ATermAppl aTermAppl2 = taxonomyNode2.getName();
                Set<ATermAppl> set = this.realizeByConcept(aTermAppl2, hashSet);
                if (set == null) {
                    return null;
                }
                hashSet2.removeAll(set);
            }
            if (!hashSet2.isEmpty()) {
                taxonomyNode.putDatum(TaxonomyUtils.INSTANCES_KEY, hashSet2);
            }
        }
        return hashSet;
    }

    public void printStats() {
        Timer timer = this.kb.timers.getTimer("satisfiability");
        Timer timer2 = this.kb.timers.getTimer("subClassSat");
        StringBuilder stringBuilder = new StringBuilder(this.kb.getABox().getCache().toString());
        stringBuilder.append("sat: ");
        if (timer != null) {
            stringBuilder.append(timer.getCount()).append(" ").append(timer.getTotal());
        } else {
            stringBuilder.append("0");
        }
        stringBuilder.append(" sub: ");
        if (timer2 != null) {
            stringBuilder.append(timer2.getCount()).append(" ").append(timer2.getTotal());
        } else {
            stringBuilder.append("0");
        }
        int n = 0;
        int n2 = 0;
        Iterator<Object> iterator = this.taxonomy.depthFirstDatumOnly(ATermUtils.TOP, TaxonomyUtils.SUPER_EXPLANATION_KEY);
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            if (map == null) continue;
            ++n;
            for (Set set : map.values()) {
                for (Set set2 : set) {
                    n2 += set2.size();
                }
            }
        }
        System.out.println(stringBuilder);
    }

    public void printMemory() {
        try {
            MemUtils.printMemory("Total: ", MemUtils.totalMemory());
            MemUtils.printMemory("Free : ", MemUtils.freeMemory());
            MemUtils.printMemory("Used*: ", MemUtils.totalMemory() - MemUtils.freeMemory());
            MemUtils.runGC();
            MemUtils.printMemory("Used : ", MemUtils.usedMemory());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String format(ATermAppl aTermAppl) {
        return ATermUtils.toString(aTermAppl);
    }

    private static enum ConceptFlag {
        COMPLETELY_DEFINED,
        PRIMITIVE,
        NONPRIMITIVE,
        NONPRIMITIVE_TA,
        OTHER;

    }

    private static enum Propogate {
        UP,
        DOWN,
        NONE;

    }
}

