/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationObjectVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLAnnotationImpl
extends OWLObjectImpl
implements OWLAnnotation {
    private static final long serialVersionUID = 30402L;
    private final OWLAnnotationProperty property;
    private final OWLAnnotationValue value;
    private final Set<OWLAnnotation> annotations;

    public OWLAnnotationImpl(OWLAnnotationProperty property, OWLAnnotationValue value, Set<? extends OWLAnnotation> annotations) {
        this.property = property;
        this.value = value;
        this.annotations = CollectionFactory.getCopyOnRequestSetFromMutableCollection(new TreeSet<OWLAnnotation>(annotations));
    }

    @Override
    public Set<OWLAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public OWLAnnotationProperty getProperty() {
        return this.property;
    }

    @Override
    public OWLAnnotationValue getValue() {
        return this.value;
    }

    @Override
    public OWLAnnotation getAnnotatedAnnotation(Set<OWLAnnotation> annotationsToAdd) {
        if (annotationsToAdd.isEmpty()) {
            return this;
        }
        HashSet<OWLAnnotation> merged = new HashSet<OWLAnnotation>(this.annotations);
        merged.addAll(annotationsToAdd);
        return new OWLAnnotationImpl(this.property, this.value, merged);
    }

    @Deprecated
    public boolean isComment() {
        return this.property.isComment();
    }

    @Deprecated
    public boolean isLabel() {
        return this.property.isLabel();
    }

    @Override
    public boolean isDeprecatedIRIAnnotation() {
        return this.property.isDeprecated() && this.value instanceof OWLLiteral && ((OWLLiteral)this.value).isBoolean() && ((OWLLiteral)this.value).parseBoolean();
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof OWLAnnotation) {
            OWLAnnotation other = (OWLAnnotation)obj;
            return other.getProperty().equals(this.property) && other.getValue().equals(this.value) && other.getAnnotations().equals(this.annotations);
        }
        return false;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLAnnotation other = (OWLAnnotation)object;
        int diff = this.getProperty().compareTo(other.getProperty());
        if (diff != 0) {
            return diff;
        }
        return this.getValue().compareTo(other.getValue());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }
}

