/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;

public class PelletCmdOptions {
    private Map<String, PelletCmdOption> options = new LinkedHashMap<String, PelletCmdOption>();
    private Map<String, PelletCmdOption> shortOptions = new HashMap<String, PelletCmdOption>();
    private Set<PelletCmdOption> mandatory = new HashSet<PelletCmdOption>();

    public void add(PelletCmdOption pelletCmdOption) {
        String string = pelletCmdOption.getShortOption();
        String string2 = pelletCmdOption.getLongOption();
        if (this.options.containsKey(string2)) {
            throw new PelletCmdException("Duplicate long option for command: " + string2);
        }
        if (string != null && this.shortOptions.containsKey(string)) {
            throw new PelletCmdException("Duplicate short option for command: " + string);
        }
        this.shortOptions.put(string, pelletCmdOption);
        this.options.put(string2, pelletCmdOption);
        if (pelletCmdOption.isMandatory()) {
            this.mandatory.add(pelletCmdOption);
        }
    }

    public PelletCmdOption getOption(String string) {
        PelletCmdOption pelletCmdOption = this.shortOptions.get(string);
        if (pelletCmdOption == null) {
            pelletCmdOption = this.options.get(string);
        }
        return pelletCmdOption;
    }

    public Set<PelletCmdOption> getMandatoryOptions() {
        return this.mandatory;
    }

    public Collection<PelletCmdOption> getOptions() {
        return this.options.values();
    }
}

