/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.AFun;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;

public class TermDefinition {
    private List<ATermAppl> subClassAxioms = new ArrayList<ATermAppl>();
    private List<ATermAppl> eqClassAxioms = new ArrayList<ATermAppl>();
    private Set<ATermAppl> dependencies;

    public TermDefinition() {
        this.updateDependencies();
    }

    public Set<ATermAppl> getDependencies() {
        if (this.dependencies == null) {
            this.updateDependencies();
        }
        return this.dependencies;
    }

    public void clearDependencies() {
        this.dependencies = null;
    }

    public ATermAppl getName() {
        if (!this.subClassAxioms.isEmpty()) {
            return (ATermAppl)this.subClassAxioms.get(0).getArgument(0);
        }
        if (!this.eqClassAxioms.isEmpty()) {
            return (ATermAppl)this.eqClassAxioms.get(0).getArgument(0);
        }
        return null;
    }

    public boolean addDef(ATermAppl aTermAppl) {
        boolean bl = false;
        AFun aFun = aTermAppl.getAFun();
        if (aFun.equals(ATermUtils.SUBFUN)) {
            bl = this.subClassAxioms.contains(aTermAppl) ? false : this.subClassAxioms.add(aTermAppl);
        } else if (aFun.equals(ATermUtils.EQCLASSFUN)) {
            bl = this.eqClassAxioms.contains(aTermAppl) ? false : this.eqClassAxioms.add(aTermAppl);
        } else {
            throw new RuntimeException("Cannot add non-definition!");
        }
        if (bl) {
            this.updateDependencies();
        }
        return bl;
    }

    public boolean removeDef(ATermAppl aTermAppl) {
        boolean bl;
        AFun aFun = aTermAppl.getAFun();
        if (aFun.equals(ATermUtils.SUBFUN)) {
            bl = this.subClassAxioms.remove(aTermAppl);
        } else if (aFun.equals(ATermUtils.EQCLASSFUN)) {
            bl = this.eqClassAxioms.remove(aTermAppl);
        } else {
            throw new RuntimeException("Cannot remove non-definition!");
        }
        this.updateDependencies();
        return bl;
    }

    public boolean isPrimitive() {
        return this.eqClassAxioms.isEmpty();
    }

    public boolean isUnique() {
        return this.eqClassAxioms.isEmpty() || this.subClassAxioms.isEmpty() && this.eqClassAxioms.size() == 1;
    }

    public boolean isUnique(ATermAppl aTermAppl) {
        return this.eqClassAxioms.isEmpty() && (this.subClassAxioms.isEmpty() || aTermAppl.getAFun().equals(ATermUtils.SUBFUN));
    }

    public List<ATermAppl> getSubClassAxioms() {
        return this.subClassAxioms;
    }

    public List<ATermAppl> getEqClassAxioms() {
        return this.eqClassAxioms;
    }

    public String toString() {
        return this.subClassAxioms + "; " + this.eqClassAxioms;
    }

    protected void updateDependencies() {
        this.dependencies = CollectionUtils.makeIdentitySet();
        for (ATermAppl aTermAppl : this.getSubClassAxioms()) {
            ATermUtils.findPrimitives((ATermAppl)aTermAppl.getArgument(1), this.dependencies);
        }
        for (ATermAppl aTermAppl : this.getEqClassAxioms()) {
            ATermUtils.findPrimitives((ATermAppl)aTermAppl.getArgument(1), this.dependencies);
        }
    }
}

