/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.List;
import java.util.logging.Level;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class NominalRule
extends AbstractTableauRule {
    public NominalRule(CompletionStrategy completionStrategy) {
        super(completionStrategy, NodeSelector.NOMINAL, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public void apply(Individual individual) {
        List<ATermAppl> list = individual.getTypes(6);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ATermAppl aTermAppl = list.get(i);
            DependencySet dependencySet = individual.getDepends((ATerm)aTermAppl);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && dependencySet == null) continue;
            this.applyNominalRule(individual, aTermAppl, dependencySet);
            if (this.strategy.getABox().isClosed()) {
                return;
            }
            if (!individual.isMerged()) continue;
            this.apply(individual.getSame());
            return;
        }
    }

    void applyNominalRule(Individual individual, ATermAppl aTermAppl, DependencySet dependencySet) {
        this.strategy.getABox().copyOnWrite();
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        Individual individual2 = this.strategy.getABox().getIndividual((ATerm)aTermAppl2);
        if (individual2 == null) {
            if (ATermUtils.isAnonNominal(aTermAppl2)) {
                individual2 = this.strategy.getABox().addIndividual(aTermAppl2, dependencySet);
            } else {
                throw new InternalReasonerException("Nominal " + aTermAppl2 + " not found in KB!");
            }
        }
        if (individual2.isMerged()) {
            dependencySet = dependencySet.union(individual2.getMergeDependency(true), this.strategy.getABox().doExplanation());
            individual2 = individual2.getSame();
        }
        if (individual.isSame(individual2)) {
            return;
        }
        if (individual.isDifferent(individual2)) {
            dependencySet = dependencySet.union(individual.getDifferenceDependency(individual2), this.strategy.getABox().doExplanation());
            if (this.strategy.getABox().doExplanation()) {
                this.strategy.getABox().setClash(Clash.nominal(individual, dependencySet, individual2.getName()));
            } else {
                this.strategy.getABox().setClash(Clash.nominal(individual, dependencySet));
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("NOM:  " + individual + " -> " + individual2);
        }
        this.strategy.mergeTo(individual, individual2, dependencySet);
    }
}

