/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.blocking;

import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;

public class BlockingContext {
    Individual blocked;
    Individual blocker;
    Set<Role> rolesToBlocked;

    public BlockingContext(Individual individual) {
        this.blocked = individual;
        this.blocker = individual;
    }

    public boolean moveBlockerUp() {
        this.blocker = this.blocker.getParent();
        this.rolesToBlocked = null;
        return !this.blocker.isRoot();
    }

    public boolean moveBlockerDown(Node node) {
        if (node.isLiteral() || node.isRoot() || node.isPruned() || node.isMerged() || ((Individual)node).isBlocked() || node.equals(this.blocker)) {
            return false;
        }
        this.blocker = (Individual)node;
        this.rolesToBlocked = null;
        return true;
    }

    public boolean isRSuccessor(Role role) {
        return this.getIncomingRoles().contains(role);
    }

    public boolean isInvSuccessor() {
        for (Role role : this.getIncomingRoles()) {
            if (!role.isAnon()) continue;
            return true;
        }
        return false;
    }

    protected Set<Role> getIncomingRoles() {
        if (this.rolesToBlocked == null) {
            this.rolesToBlocked = BlockingContext.getIncomingRoles(this.blocked);
            assert (this.rolesToBlocked != null);
        }
        return this.rolesToBlocked;
    }

    protected static Set<Role> getIncomingRoles(Individual individual) {
        Set<Role> set = null;
        for (Edge edge : individual.getInEdges()) {
            if (!edge.getFrom().equals(individual.getParent())) continue;
            if (set == null) {
                set = edge.getRole().getSuperRoles();
                continue;
            }
            if (set.contains(edge.getRole())) continue;
            set = new HashSet<Role>(set);
            set.addAll(edge.getRole().getSuperRoles());
        }
        return set;
    }

    public String toString() {
        return this.blocked + " blocked by " + this.blocker;
    }
}

