/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;

public class LiteralIterator
implements Iterator<Literal> {
    protected ABox abox;
    protected List<ATermAppl> nodeList;
    protected int index;
    protected int start;
    protected int stop;

    public LiteralIterator(ABox aBox) {
        this(aBox, true);
    }

    protected LiteralIterator(ABox aBox, boolean bl) {
        this.abox = aBox;
        this.nodeList = aBox.getNodeNames();
        this.start = 0;
        this.stop = this.nodeList.size();
        this.index = this.start;
        if (bl) {
            this.findNext();
        }
    }

    public LiteralIterator(ABox aBox, int n, int n2) {
        this.abox = aBox;
        this.nodeList = aBox.getNodeNames();
        this.start = n;
        this.stop = Math.max(n2, this.nodeList.size());
        this.index = n;
        this.findNext();
    }

    public int getIndex() {
        return this.index;
    }

    protected void findNext() {
        Node node;
        while (this.index < this.stop && ((node = this.abox.getNode((ATerm)this.nodeList.get(this.index))).isPruned() || !node.isLiteral())) {
            ++this.index;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.index < this.stop;
    }

    public void reset() {
        this.index = this.start;
        this.findNext();
    }

    public void jump(int n) {
        this.index = n;
    }

    @Override
    public Literal next() {
        this.findNext();
        Literal literal = this.abox.getLiteral((ATerm)this.nodeList.get(this.index++));
        return literal;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }
}

