/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.model;

import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.lintpattern.LintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OntologyLints {
    private OWLOntology m_Ontology;
    private OWLOntology m_RootOntology;
    private Map<LintPattern, List<Lint>> m_Lints;

    public OntologyLints(OWLOntology oWLOntology) {
        this.m_Ontology = oWLOntology;
        this.m_Lints = new TreeMap<LintPattern, List<Lint>>(new Comparator<LintPattern>(){

            @Override
            public int compare(LintPattern lintPattern, LintPattern lintPattern2) {
                return lintPattern.getName().compareTo(lintPattern2.getName());
            }
        });
    }

    public OWLOntology getOntology() {
        return this.m_Ontology;
    }

    public void setRootOntology(OWLOntology oWLOntology) {
        this.m_RootOntology = oWLOntology;
    }

    public OWLOntology getRootOntology() {
        return this.m_RootOntology;
    }

    public void addLint(LintPattern lintPattern, Lint lint) {
        List<Lint> list = this.m_Lints.get(lintPattern);
        if (list == null) {
            list = CollectionUtil.makeList();
            this.m_Lints.put(lintPattern, list);
        }
        list.add(lint);
    }

    public void addLints(LintPattern lintPattern, List<Lint> list) {
        List<Lint> list2 = this.m_Lints.get(lintPattern);
        if (list2 == null) {
            list2 = CollectionUtil.makeList();
            this.m_Lints.put(lintPattern, list2);
        }
        list2.addAll(list);
    }

    public void sort(Comparator<? super Lint> comparator) {
        for (List<Lint> list : this.m_Lints.values()) {
            Collections.sort(list, comparator);
        }
    }

    public boolean isEmpty() {
        return this.m_Lints.isEmpty();
    }

    public int size() {
        int n = 0;
        for (List<Lint> list : this.m_Lints.values()) {
            n += list.size();
        }
        return n;
    }

    public Set<Lint> applyFix(OWLOntologyManager oWLOntologyManager) throws OWLOntologyChangeException {
        HashSet<Lint> hashSet = new HashSet<Lint>();
        for (Map.Entry<LintPattern, List<Lint>> entry : this.m_Lints.entrySet()) {
            if (entry.getKey().isFixable()) {
                for (Lint lint : entry.getValue()) {
                    if (lint.applyFix(oWLOntologyManager)) continue;
                    hashSet.add(lint);
                }
                continue;
            }
            hashSet.addAll((Collection<Lint>)entry.getValue());
        }
        return hashSet;
    }

    public String toString() {
        String string = this.m_RootOntology == null ? this.m_Ontology.getOntologyID().toString() : this.m_RootOntology.getOntologyID().toString() + " and its import closure";
        if (this.m_Lints.isEmpty()) {
            return "\nNo OWL lints found for ontology " + string + ".";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n==================================================================\n");
        stringBuilder.append("OWL Lints found for ontology ").append(string).append(":");
        for (LintPattern lintPattern : this.m_Lints.keySet()) {
            stringBuilder.append("\n[").append(lintPattern.getName()).append(": ").append(lintPattern.getDescription()).append("]\n");
            LintFormat lintFormat = lintPattern.getDefaultLintFormat();
            for (Lint lint : this.m_Lints.get(lintPattern)) {
                stringBuilder.append(lintFormat.format(lint));
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

