/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecution;
import com.clarkparsia.pellet.sparqldl.jena.SparqlDLStageGenerator;
import com.clarkparsia.pellet.sparqldl.parser.ARQParser;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.Model;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.PelletInfGraph;

public class SparqlDLExecutionFactory {
    public static QueryExecution create(Query query, Dataset dataset, QuerySolution querySolution) {
        QueryEngineType queryEngineType = QueryEngineType.ARQ;
        Graph graph = dataset.getDefaultModel().getGraph();
        if (graph instanceof PelletInfGraph) {
            if (dataset.listNames().hasNext() || query.isDescribeType()) {
                queryEngineType = QueryEngineType.MIXED;
            } else {
                PelletInfGraph pelletInfGraph = (PelletInfGraph)graph;
                KnowledgeBase knowledgeBase = pelletInfGraph.getKB();
                pelletInfGraph.prepare();
                ARQParser aRQParser = new ARQParser();
                aRQParser.setInitialBinding(querySolution);
                try {
                    aRQParser.parse(query, knowledgeBase);
                    queryEngineType = QueryEngineType.PELLET;
                }
                catch (UnsupportedQueryException unsupportedQueryException) {
                    queryEngineType = QueryEngineType.MIXED;
                }
            }
        }
        return SparqlDLExecutionFactory.create(query, dataset, querySolution, queryEngineType);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution querySolution, QueryEngineType queryEngineType) {
        return SparqlDLExecutionFactory.create(query, dataset, querySolution, queryEngineType, true);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution querySolution, QueryEngineType queryEngineType, boolean bl) throws QueryException {
        QueryExecution queryExecution = null;
        switch (queryEngineType) {
            case PELLET: {
                queryExecution = new SparqlDLExecution(query, dataset, bl);
                ((SparqlDLExecution)queryExecution).setPurePelletQueryExec(true);
                break;
            }
            case ARQ: {
                queryExecution = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
                break;
            }
            case MIXED: {
                queryExecution = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
                queryExecution.getContext().set(ARQ.stageGenerator, (Object)new SparqlDLStageGenerator(bl));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (querySolution != null) {
            queryExecution.setInitialBinding(querySolution);
        }
        return queryExecution;
    }

    public static QueryExecution create(Query query, Model model) {
        return SparqlDLExecutionFactory.create(query, model, null);
    }

    public static QueryExecution create(Query query, Dataset dataset) {
        return SparqlDLExecutionFactory.create(query, dataset, null);
    }

    public static QueryExecution create(Query query, Model model, QuerySolution querySolution) {
        return SparqlDLExecutionFactory.create(query, DatasetFactory.create((Model)model), querySolution);
    }

    public static QueryExecution createPelletExecution(Query query, Model model) {
        return SparqlDLExecutionFactory.create(query, DatasetFactory.create((Model)model), null, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query, Model model, QuerySolution querySolution) {
        return SparqlDLExecutionFactory.create(query, DatasetFactory.create((Model)model), querySolution, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query, Dataset dataset) {
        return SparqlDLExecutionFactory.create(query, dataset, null, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query, Dataset dataset, QuerySolution querySolution) {
        return SparqlDLExecutionFactory.create(query, dataset, querySolution, QueryEngineType.PELLET);
    }

    public static QueryExecution createBasicExecution(Query query, Model model) {
        return SparqlDLExecutionFactory.createPelletExecution(query, model);
    }

    public static QueryExecution createBasicExecution(Query query, Dataset dataset) {
        return SparqlDLExecutionFactory.createPelletExecution(query, dataset);
    }

    public static enum QueryEngineType {
        ARQ,
        MIXED,
        PELLET;

    }
}

