/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.duration;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.datetime.RestrictedTimelineDatatype;
import com.clarkparsia.pellet.datatypes.types.duration.RestrictedDurationDatatype;
import javax.xml.datatype.Duration;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDDuration
extends AbstractBaseDatatype<Duration> {
    private static final XSDDuration instance;
    static final ATermAppl NAME;
    private final RestrictedDatatype<Duration> dataRange = new RestrictedDurationDatatype(this);

    public static XSDDuration getInstance() {
        return instance;
    }

    private XSDDuration() {
        super(NAME);
    }

    @Override
    public RestrictedDatatype<Duration> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        return ATermUtils.makeTypedLiteral(this.getValue(aTermAppl).toString(), NAME);
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Duration getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        try {
            Duration duration = RestrictedTimelineDatatype.getDatatypeFactory().newDuration(string);
            return duration;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
        catch (IllegalStateException illegalStateException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        NAME = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#duration");
        instance = new XSDDuration();
    }
}

