/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.profiles.LastPropertyInChainNotInImposedRange;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.UseOfAnonymousIndividual;
import org.semanticweb.owlapi.profiles.UseOfDataOneOfWithMultipleLiterals;
import org.semanticweb.owlapi.profiles.UseOfIllegalAxiom;
import org.semanticweb.owlapi.profiles.UseOfIllegalClassExpression;
import org.semanticweb.owlapi.profiles.UseOfIllegalDataRange;
import org.semanticweb.owlapi.profiles.UseOfObjectOneOfWithMultipleIndividuals;
import org.semanticweb.owlapi.profiles.UseOfObjectPropertyInverse;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWL2ELProfile
implements OWLProfile {
    protected final Set<IRI> allowedDatatypes = new HashSet<IRI>();

    public OWL2ELProfile() {
        this.allowedDatatypes.add(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI());
        this.allowedDatatypes.add(OWLRDFVocabulary.RDF_XML_LITERAL.getIRI());
        this.allowedDatatypes.add(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.OWL_RATIONAL.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.OWL_REAL.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_DECIMAL.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_DECIMAL.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_INTEGER.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_NON_NEGATIVE_INTEGER.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_STRING.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_NORMALIZED_STRING.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_TOKEN.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_NAME.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_NCNAME.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_NMTOKEN.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_HEX_BINARY.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_BASE_64_BINARY.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_ANY_URI.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_DATE_TIME.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_DATE_TIME_STAMP.getIRI());
    }

    @Override
    public String getName() {
        return "OWL 2 EL";
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2DLProfile profile = new OWL2DLProfile();
        OWLProfileReport report = profile.checkOntology(ontology);
        HashSet<OWLProfileViolation> violations = new HashSet<OWLProfileViolation>();
        violations.addAll(report.getViolations());
        OWLOntologyWalker ontologyWalker = new OWLOntologyWalker(ontology.getImportsClosure());
        OWL2ELProfileObjectVisitor visitor = new OWL2ELProfileObjectVisitor(ontologyWalker, ontology.getOWLOntologyManager());
        ontologyWalker.walkStructure(visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    protected class OWL2ELProfileObjectVisitor
    extends OWLOntologyWalkerVisitor<Object> {
        private final OWLOntologyManager man;
        private OWLObjectPropertyManager propertyManager;
        private final Set<OWLProfileViolation> profileViolations;

        public OWL2ELProfileObjectVisitor(OWLOntologyWalker walker, OWLOntologyManager man) {
            super(walker);
            this.profileViolations = new HashSet<OWLProfileViolation>();
            this.man = man;
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.profileViolations);
        }

        private OWLObjectPropertyManager getPropertyManager() {
            if (this.propertyManager == null) {
                this.propertyManager = new OWLObjectPropertyManager(this.man, this.getCurrentOntology());
            }
            return this.propertyManager;
        }

        @Override
        public Object visit(OWLDatatype node) {
            if (!OWL2ELProfile.this.allowedDatatypes.contains(node.getIRI())) {
                this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
            return null;
        }

        @Override
        public Object visit(OWLAnonymousIndividual individual) {
            this.profileViolations.add(new UseOfAnonymousIndividual(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
            return null;
        }

        @Override
        public Object visit(OWLObjectInverseOf property) {
            this.profileViolations.add(new UseOfObjectPropertyInverse(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            return null;
        }

        @Override
        public Object visit(OWLDataAllValuesFrom desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            return null;
        }

        @Override
        public Object visit(OWLDataExactCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            return null;
        }

        @Override
        public Object visit(OWLDataMaxCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            return null;
        }

        @Override
        public Object visit(OWLDataMinCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            return null;
        }

        @Override
        public Object visit(OWLObjectAllValuesFrom desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            return null;
        }

        @Override
        public Object visit(OWLObjectComplementOf desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            return null;
        }

        @Override
        public Object visit(OWLObjectExactCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            return null;
        }

        @Override
        public Object visit(OWLObjectMaxCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            return null;
        }

        @Override
        public Object visit(OWLObjectMinCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            return null;
        }

        @Override
        public Object visit(OWLObjectOneOf desc) {
            if (desc.getIndividuals().size() != 1) {
                this.profileViolations.add(new UseOfObjectOneOfWithMultipleIndividuals(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            }
            return null;
        }

        @Override
        public Object visit(OWLObjectUnionOf desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            return null;
        }

        @Override
        public Object visit(OWLDataComplementOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            return null;
        }

        @Override
        public Object visit(OWLDataOneOf node) {
            if (node.getValues().size() != 1) {
                this.profileViolations.add(new UseOfDataOneOfWithMultipleLiterals(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
            return null;
        }

        @Override
        public Object visit(OWLDatatypeRestriction node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            return null;
        }

        @Override
        public Object visit(OWLDataUnionOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            return null;
        }

        @Override
        public Object visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLDisjointObjectPropertiesAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLDisjointUnionAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLHasKeyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(SWRLRule rule) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), rule));
            return super.visit(rule);
        }

        @Override
        public Object visit(OWLSubPropertyChainOfAxiom axiom) {
            Set<OWLObjectPropertyRangeAxiom> rangeAxioms = this.getCurrentOntology().getAxioms(AxiomType.OBJECT_PROPERTY_RANGE, true);
            if (rangeAxioms.isEmpty()) {
                return Boolean.FALSE;
            }
            for (OWLObjectPropertyRangeAxiom rngAx : rangeAxioms) {
                if (!this.getPropertyManager().isSubPropertyOf(axiom.getSuperProperty(), (OWLObjectPropertyExpression)rngAx.getProperty())) continue;
                OWLClassExpression imposedRange = (OWLClassExpression)rngAx.getRange();
                List<OWLObjectPropertyExpression> chain = axiom.getPropertyChain();
                if (chain.isEmpty()) continue;
                OWLObjectPropertyExpression lastProperty = chain.get(chain.size() - 1);
                boolean rngPresent = false;
                block1: for (OWLOntology ont : this.getCurrentOntology().getImportsClosure()) {
                    for (OWLObjectPropertyRangeAxiom lastPropRngAx : ont.getObjectPropertyRangeAxioms(lastProperty)) {
                        if (!((OWLClassExpression)lastPropRngAx.getRange()).equals(imposedRange)) continue;
                        rngPresent = true;
                        continue block1;
                    }
                }
                if (rngPresent) continue;
                this.profileViolations.add(new LastPropertyInChainNotInImposedRange(this.getCurrentOntology(), axiom, rngAx));
            }
            return null;
        }

        @Override
        public Object visit(OWLOntology ontology) {
            this.propertyManager = null;
            return null;
        }
    }
}

