/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.taxonomy.AbstractDefinitionOrder;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;

public class TaxonomyBasedDefinitionOrder
extends AbstractDefinitionOrder {
    private Taxonomy<ATermAppl> definitionOrderTaxonomy;

    public TaxonomyBasedDefinitionOrder(KnowledgeBase knowledgeBase, Comparator<ATerm> comparator) {
        super(knowledgeBase, comparator);
    }

    @Override
    protected void initialize() {
        this.definitionOrderTaxonomy = new Taxonomy<ATermAppl>(this.kb.getClasses(), ATermUtils.TOP, ATermUtils.BOTTOM);
    }

    @Override
    protected void addUses(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (this.definitionOrderTaxonomy.isEquivalent(aTermAppl, aTermAppl2).isTrue()) {
            return;
        }
        TaxonomyNode<ATermAppl> taxonomyNode = this.definitionOrderTaxonomy.getNode(aTermAppl);
        TaxonomyNode<ATermAppl> taxonomyNode2 = this.definitionOrderTaxonomy.getNode(aTermAppl2);
        if (taxonomyNode == null) {
            throw new InternalReasonerException(aTermAppl + " is not in the definition order");
        }
        if (taxonomyNode.equals(this.definitionOrderTaxonomy.getTop())) {
            this.definitionOrderTaxonomy.merge(taxonomyNode, taxonomyNode2);
        } else {
            this.definitionOrderTaxonomy.addSuper(aTermAppl, aTermAppl2);
            this.definitionOrderTaxonomy.removeCycles(taxonomyNode);
        }
    }

    @Override
    protected Set<ATermAppl> computeCycles() {
        Set<ATermAppl> set = CollectionUtils.makeIdentitySet();
        for (TaxonomyNode<ATermAppl> taxonomyNode : this.definitionOrderTaxonomy.getNodes()) {
            Set<ATermAppl> set2 = taxonomyNode.getEquivalents();
            if (set2.size() <= 1) continue;
            set.addAll(set2);
        }
        return set;
    }

    @Override
    protected List<ATermAppl> computeDefinitionOrder() {
        this.definitionOrderTaxonomy.assertValid();
        return this.definitionOrderTaxonomy.topologocialSort(true, this.comparator);
    }
}

