/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern;

import com.clarkparsia.pellint.lintpattern.LintPattern;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToAllValuePattern;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToComplementPattern;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToMaxCardinalityPattern;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToTopPattern;
import com.clarkparsia.pellint.lintpattern.axiom.GCIPattern;
import com.clarkparsia.pellint.lintpattern.axiom.LargeCardinalityPattern;
import com.clarkparsia.pellint.lintpattern.axiom.LargeDisjunctionPattern;
import com.clarkparsia.pellint.lintpattern.ontology.EquivalentAndSubclassAxiomPattern;
import com.clarkparsia.pellint.lintpattern.ontology.ExistentialExplosionPattern;
import com.clarkparsia.pellint.lintpattern.ontology.OntologyLintPattern;
import com.clarkparsia.pellint.lintpattern.ontology.TooManyDifferentIndividualsPattern;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LintPatternLoader {
    private static final Logger LOGGER = Logger.getLogger(LintPatternLoader.class.getName());
    public static final List<AxiomLintPattern> DEFAULT_AXIOM_LINT_PATTERNS = Arrays.asList(new EquivalentToAllValuePattern(), new EquivalentToMaxCardinalityPattern(), new EquivalentToComplementPattern(), new EquivalentToTopPattern(), new GCIPattern(), new LargeCardinalityPattern(), new LargeDisjunctionPattern());
    public static final List<OntologyLintPattern> DEFAULT_ONTOLOGY_LINT_PATTERNS = Arrays.asList(new EquivalentAndSubclassAxiomPattern(), new ExistentialExplosionPattern(), new TooManyDifferentIndividualsPattern());
    private List<AxiomLintPattern> m_AxiomLintPatterns;
    private List<OntologyLintPattern> m_OntologyLintPatterns;

    public LintPatternLoader() {
        this.m_AxiomLintPatterns = DEFAULT_AXIOM_LINT_PATTERNS;
        this.m_OntologyLintPatterns = DEFAULT_ONTOLOGY_LINT_PATTERNS;
    }

    public LintPatternLoader(Properties properties) {
        Collection<LintPattern> collection = LintPatternLoader.loadPatterns(LintPatternLoader.formatProperties(properties));
        if (collection.isEmpty()) {
            this.m_AxiomLintPatterns = DEFAULT_AXIOM_LINT_PATTERNS;
            this.m_OntologyLintPatterns = DEFAULT_ONTOLOGY_LINT_PATTERNS;
        } else {
            this.m_AxiomLintPatterns = CollectionUtil.makeList();
            this.m_OntologyLintPatterns = CollectionUtil.makeList();
            for (LintPattern lintPattern : collection) {
                if (lintPattern instanceof AxiomLintPattern) {
                    this.m_AxiomLintPatterns.add((AxiomLintPattern)lintPattern);
                    continue;
                }
                if (!(lintPattern instanceof OntologyLintPattern)) continue;
                this.m_OntologyLintPatterns.add((OntologyLintPattern)lintPattern);
            }
        }
    }

    public List<AxiomLintPattern> getAxiomLintPatterns() {
        return this.m_AxiomLintPatterns;
    }

    public List<OntologyLintPattern> getOntologyLintPatterns() {
        return this.m_OntologyLintPatterns;
    }

    private static Map<String, String> formatProperties(Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            String string = object == null ? "" : object.toString().trim();
            String string2 = object2 == null ? "" : object2.toString().trim();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private static Collection<LintPattern> loadPatterns(Map<String, String> map) {
        String string;
        String string2;
        HashMap<String, LintPattern> hashMap = new HashMap<String, LintPattern>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string2 = entry.getKey();
            string = entry.getValue();
            LintPattern lintPattern = LintPatternLoader.parseLintPattern(string2);
            if (lintPattern != null) {
                hashSet.add(string2);
                if (!"on".equalsIgnoreCase(string)) continue;
                hashMap.put(string2, lintPattern);
                continue;
            }
            if (!"on".equalsIgnoreCase(string) && !"off".equalsIgnoreCase(string)) continue;
            hashSet.add(string2);
            LOGGER.severe("Cannot find and construct pattern " + string2);
        }
        for (String string3 : hashSet) {
            map.remove(string3);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string2 = entry.getKey();
            string = entry.getValue();
            int n = string2.lastIndexOf(46);
            if (n < 0 || n > string2.length()) {
                LOGGER.severe("Cannot find field name " + string2);
                continue;
            }
            String string4 = string2.substring(0, n);
            String string5 = string2.substring(n + 1);
            if (!hashSet.contains(string4)) {
                LOGGER.severe("Cannot find pattern " + string4 + " to set its parameter " + string5);
                continue;
            }
            LintPattern lintPattern = (LintPattern)hashMap.get(string4);
            if (lintPattern == null) continue;
            LintPatternLoader.setParameter(lintPattern, string4, string5, string);
        }
        return hashMap.values();
    }

    private static LintPattern parseLintPattern(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Class<LintPattern> clazz2 = clazz.asSubclass(LintPattern.class);
            Constructor<LintPattern> constructor = clazz2.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void setParameter(LintPattern lintPattern, String string, String string2, String string3) {
        Method method;
        String string4 = "set" + string2;
        Class<?> clazz = lintPattern.getClass();
        try {
            method = clazz.getMethod(string4, Integer.TYPE);
            try {
                int n = Integer.parseInt(string3);
                method.invoke((Object)lintPattern, n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.log(Level.FINE, string3 + " is not an integer", numberFormatException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + string3, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + string3, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + string3, invocationTargetException);
            }
        }
        catch (SecurityException securityException) {
            LOGGER.log(Level.FINE, "Error accessing method " + string4 + "(int) on lint pattern " + string, securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.log(Level.FINE, "Method " + string4 + "(int) not found on lint pattern " + string, noSuchMethodException);
        }
        try {
            method = clazz.getMethod(string4, String.class);
            try {
                method.invoke((Object)lintPattern, string3);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + string3, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + string3, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + string3, invocationTargetException);
            }
        }
        catch (SecurityException securityException) {
            LOGGER.log(Level.FINE, "Error accessing method " + string4 + "(String) on lint pattern " + string, securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.log(Level.FINE, "Method " + string4 + "(String) not found on lint pattern " + string, noSuchMethodException);
        }
        LOGGER.severe("Cannot set paramater " + string2 + "=" + string3 + " for lint pattern " + string);
    }
}

