/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.GeneralFunction;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.SetUtils;

public class GeneralFunctionBuiltIn
implements BuiltIn {
    private GeneralFunction function;

    public GeneralFunctionBuiltIn(GeneralFunction generalFunction) {
        this.function = generalFunction;
    }

    @Override
    public BindingHelper createHelper(BuiltInAtom builtInAtom) {
        return new GeneralFunctionHelper(builtInAtom);
    }

    private class GeneralFunctionHelper
    implements BindingHelper {
        private BuiltInAtom atom;
        private VariableBinding partial;
        private boolean used;

        public GeneralFunctionHelper(BuiltInAtom builtInAtom) {
            this.atom = builtInAtom;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> collection) {
            if (!this.isApplicable(collection)) {
                return Collections.emptySet();
            }
            return SetUtils.difference(VariableUtils.getVars(this.atom), collection);
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> collection) {
            Collection<AtomVariable> collection2 = VariableUtils.getVars(this.atom);
            collection2.removeAll(this.getBindableVars(collection));
            return collection2;
        }

        private boolean isApplicable(Collection<AtomVariable> collection) {
            boolean[] blArray = new boolean[this.atom.getAllArguments().size()];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = collection.contains(this.atom.getAllArguments().get(i));
            }
            return GeneralFunctionBuiltIn.this.function.isApplicable(blArray);
        }

        @Override
        public void rebind(VariableBinding variableBinding) {
            Object[] objectArray = new Literal[this.atom.getAllArguments().size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = variableBinding.get((AtomDObject)this.atom.getAllArguments().get(i));
            }
            if (GeneralFunctionBuiltIn.this.function.apply(variableBinding.getABox(), (Literal[])objectArray)) {
                VariableBinding variableBinding2 = new VariableBinding(variableBinding.getABox());
                for (int i = 0; i < objectArray.length; ++i) {
                    AtomDObject atomDObject = (AtomDObject)this.atom.getAllArguments().get(i);
                    Object object = objectArray[i];
                    Literal literal = variableBinding.get(atomDObject);
                    if (literal != null && !literal.equals(object)) {
                        if (variableBinding.get(atomDObject) != null) {
                            throw new InternalReasonerException("General Function implementation overwrote one of its arguments!");
                        }
                        ABox.log.info("Function results in multiple simultaneous values for variable");
                        return;
                    }
                    if (literal != null) continue;
                    variableBinding.set(atomDObject, (Literal)object);
                }
                this.used = false;
                this.partial = variableBinding2;
            } else {
                System.out.println("Function failure: " + this.atom);
                System.out.println("Arguments: " + Arrays.toString(objectArray));
            }
        }

        @Override
        public boolean selectNextBinding() {
            if (this.partial != null && !this.used) {
                this.used = true;
                return true;
            }
            return false;
        }

        @Override
        public void setCurrentBinding(VariableBinding variableBinding) {
            for (Map.Entry<AtomDVariable, Literal> entry : this.partial.dataEntrySet()) {
                variableBinding.set((AtomDObject)entry.getKey(), entry.getValue());
            }
        }
    }
}

