/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.graph.impl.TransactionHandlerBase;
import com.hp.hpl.jena.shared.JenaException;
import java.io.File;

public class FileGraphTransactionHandler
extends TransactionHandlerBase
implements TransactionHandler {
    protected boolean inTransaction;
    protected FileGraph fileGraph;
    protected File checkPointFile;

    public FileGraphTransactionHandler(FileGraph fileGraph) {
        this.fileGraph = fileGraph;
    }

    @Override
    public boolean transactionsSupported() {
        return true;
    }

    @Override
    public void begin() {
        if (this.inTransaction) {
            throw new JenaException("nested transactions not supported");
        }
        this.checkPointFile = new File(this.checkPointName(this.fileGraph.name));
        this.checkPointFile.deleteOnExit();
        this.fileGraph.saveContents(this.checkPointFile);
        this.inTransaction = true;
    }

    protected String checkPointName(File name) {
        String path = name.getPath();
        int pos = path.lastIndexOf(File.separatorChar);
        String start = path.substring(0, pos + 1);
        String finish = path.substring(pos + 1);
        return start + "checkPoint-" + finish;
    }

    @Override
    public void abort() {
        this.fileGraph.clear();
        this.fileGraph.readModelFrom(this.fileGraph.model, true, this.checkPointFile);
        this.checkPointFile.delete();
        this.inTransaction = false;
    }

    @Override
    public void commit() {
        this.fileGraph.saveContents(this.fileGraph.name);
        this.checkPointFile.delete();
        this.inTransaction = false;
    }
}

