/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.pure.PureFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.ATermManchesterSyntaxRenderer;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.URIUtils;
import org.mindswap.pellet.utils.iterator.MultiListIterator;
import org.mindswap.pellet.utils.iterator.PairIterator;

public class ATermUtils {
    private static final ATermFactory factory = new PureFactory();
    public static final AFun LITFUN = factory.makeAFun("literal", 3, false);
    public static final int LIT_VAL_INDEX = 0;
    public static final int LIT_LANG_INDEX = 1;
    public static final int LIT_URI_INDEX = 2;
    public static final AFun ANDFUN = factory.makeAFun("and", 1, false);
    public static final AFun ORFUN = factory.makeAFun("or", 1, false);
    public static final AFun SOMEFUN = factory.makeAFun("some", 2, false);
    public static final AFun ALLFUN = factory.makeAFun("all", 2, false);
    public static final AFun NOTFUN = factory.makeAFun("not", 1, false);
    public static final AFun MAXFUN = factory.makeAFun("max", 3, false);
    public static final AFun MINFUN = factory.makeAFun("min", 3, false);
    public static final AFun VALUEFUN = factory.makeAFun("value", 1, false);
    public static final AFun SELFFUN = factory.makeAFun("self", 1, false);
    public static final AFun CARDFUN = factory.makeAFun("card", 3, false);
    public static Set<AFun> CLASS_FUN = SetUtils.create(ALLFUN, SOMEFUN, MAXFUN, MINFUN, CARDFUN, ANDFUN, ORFUN, NOTFUN, VALUEFUN, SELFFUN);
    public static final AFun INVFUN = factory.makeAFun("inv", 1, false);
    public static final AFun SUBFUN = factory.makeAFun("subClassOf", 2, false);
    public static final AFun EQCLASSFUN = factory.makeAFun("equivalentClasses", 2, false);
    public static final AFun SAMEASFUN = factory.makeAFun("sameAs", 2, false);
    public static final AFun DISJOINTFUN = factory.makeAFun("disjointWith", 2, false);
    public static final AFun DISJOINTSFUN = factory.makeAFun("disjointClasses", 1, false);
    public static final AFun DISJOINTPROPFUN = factory.makeAFun("disjointPropertyWith", 2, false);
    public static final AFun DISJOINTPROPSFUN = factory.makeAFun("disjointProperties", 1, false);
    public static final AFun COMPLEMENTFUN = factory.makeAFun("complementOf", 2, false);
    public static final AFun VARFUN = factory.makeAFun("var", 1, false);
    public static final AFun TYPEFUN = factory.makeAFun("type", 2, false);
    public static final AFun PROPFUN = factory.makeAFun("prop", 3, false);
    public static final AFun DIFFERENTFUN = factory.makeAFun("different", 2, false);
    public static final AFun ALLDIFFERENTFUN = factory.makeAFun("allDifferent", 1, false);
    public static final AFun ASYMMETRICFUN;
    @Deprecated
    public static final AFun ANTISYMMETRICFUN;
    public static final AFun FUNCTIONALFUN;
    public static final AFun INVFUNCTIONALFUN;
    public static final AFun IRREFLEXIVEFUN;
    public static final AFun REFLEXIVEFUN;
    public static final AFun SYMMETRICFUN;
    public static final AFun TRANSITIVEFUN;
    public static final AFun SUBPROPFUN;
    public static final AFun EQPROPFUN;
    public static final AFun INVPROPFUN;
    public static final AFun DOMAINFUN;
    public static final AFun RANGEFUN;
    public static final AFun RULEFUN;
    public static final AFun BUILTINFUN;
    public static final AFun DATATYPEDEFFUN;
    public static final AFun RESTRDATATYPEFUN;
    public static final AFun FACET;
    public static final ATermAppl EMPTY;
    public static final ATermList EMPTY_LIST;
    public static Set<AFun> AXIOM_FUN;
    public static final ATermAppl TOP;
    public static final ATermAppl BOTTOM;
    public static final ATermAppl TOP_OBJECT_PROPERTY;
    public static final ATermAppl TOP_DATA_PROPERTY;
    public static final ATermAppl BOTTOM_OBJECT_PROPERTY;
    public static final ATermAppl BOTTOM_DATA_PROPERTY;
    public static final ATermAppl TOP_LIT;
    public static final ATermAppl BOTTOM_LIT;
    public static final ATermAppl CONCEPT_SAT_IND;
    public static final ATermInt ONE;
    public static final ATermAppl PLAIN_LITERAL_DATATYPE;
    public static QNameProvider qnames;
    public static ATermAppl NO_DATATYPE;
    public static final AFun BNODE_FUN;
    public static final AFun ANON_FUN;
    public static final AFun ANON_NOMINAL_FUN;
    private static final ATermAppl[] anonCache;

    public static ATermFactory getFactory() {
        return factory;
    }

    public static final ATermAppl makeTypeAtom(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return factory.makeAppl(TYPEFUN, (ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public static final ATermAppl makePropAtom(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        return factory.makeAppl(PROPFUN, (ATerm)aTermAppl, (ATerm)aTermAppl2, (ATerm)aTermAppl3);
    }

    public static ATermAppl makePlainLiteral(String string) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(string), (ATerm)EMPTY, (ATerm)PLAIN_LITERAL_DATATYPE);
    }

    public static ATermAppl makePlainLiteral(String string, String string2) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(string), (ATerm)ATermUtils.makeTermAppl(string2), (ATerm)PLAIN_LITERAL_DATATYPE);
    }

    public static ATermAppl makeTypedLiteral(String string, ATermAppl aTermAppl) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(string), (ATerm)EMPTY, (ATerm)aTermAppl);
    }

    public static ATermAppl makeTypedLiteral(String string, String string2) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(string), (ATerm)EMPTY, (ATerm)ATermUtils.makeTermAppl(string2));
    }

    public static ATermAppl makeLiteral(ATermAppl aTermAppl) {
        return factory.makeAppl(LITFUN, (ATerm)aTermAppl, (ATerm)EMPTY, (ATerm)NO_DATATYPE);
    }

    public static String getLiteralValue(ATermAppl aTermAppl) {
        return ((ATermAppl)aTermAppl.getArgument(0)).getName();
    }

    public static String getLiteralLang(ATermAppl aTermAppl) {
        return ((ATermAppl)aTermAppl.getArgument(1)).getName();
    }

    public static String getLiteralDatatype(ATermAppl aTermAppl) {
        return ((ATermAppl)aTermAppl.getArgument(2)).getName();
    }

    public static ATermAppl makeTermAppl(String string) {
        return factory.makeAppl(factory.makeAFun(string, 0, false));
    }

    public static ATermAppl makeTermAppl(AFun aFun, ATerm[] aTermArray) {
        return factory.makeAppl(aFun, aTermArray);
    }

    public static ATermAppl makeNot(ATerm aTerm) {
        return factory.makeAppl(NOTFUN, aTerm);
    }

    public static ATerm term(String string) {
        return factory.parse(string);
    }

    public static ATermList negate(ATermList aTermList) {
        if (aTermList.isEmpty()) {
            return aTermList;
        }
        ATermAppl aTermAppl = (ATermAppl)aTermList.getFirst();
        aTermAppl = ATermUtils.isNot(aTermAppl) ? (ATermAppl)aTermAppl.getArgument(0) : ATermUtils.makeNot((ATerm)aTermAppl);
        ATermList aTermList2 = ATermUtils.makeList((ATerm)aTermAppl, ATermUtils.negate(aTermList.getNext()));
        return aTermList2;
    }

    public static final ATermAppl negate(ATermAppl aTermAppl) {
        return ATermUtils.isNot(aTermAppl) ? (ATermAppl)aTermAppl.getArgument(0) : ATermUtils.makeNot((ATerm)aTermAppl);
    }

    public static final boolean isAnonNominal(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(ANON_NOMINAL_FUN);
    }

    public static final ATermAppl makeAnonNominal(int n) {
        return factory.makeAppl(ANON_NOMINAL_FUN, (ATerm)factory.makeInt(n));
    }

    public static final ATermAppl makeAnon(int n) {
        if (n < anonCache.length) {
            return anonCache[n];
        }
        return factory.makeAppl(ANON_FUN, (ATerm)factory.makeInt(n));
    }

    public static final ATermAppl makeBnode(String string) {
        return factory.makeAppl(BNODE_FUN, (ATerm)ATermUtils.makeTermAppl(string));
    }

    public static final ATermAppl makeVar(String string) {
        return factory.makeAppl(VARFUN, (ATerm)ATermUtils.makeTermAppl(string));
    }

    public static final ATermAppl makeVar(ATermAppl aTermAppl) {
        return factory.makeAppl(VARFUN, (ATerm)aTermAppl);
    }

    public static final ATermAppl makeValue(ATerm aTerm) {
        return factory.makeAppl(VALUEFUN, aTerm);
    }

    public static final ATermAppl makeInv(ATermAppl aTermAppl) {
        if (ATermUtils.isInv(aTermAppl)) {
            return (ATermAppl)aTermAppl.getArgument(0);
        }
        return factory.makeAppl(INVFUN, (ATerm)aTermAppl);
    }

    public static final ATermAppl makeInvProp(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(INVPROPFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeSub(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(SUBFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeEqClasses(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(EQCLASSFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeSameAs(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(SAMEASFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeSubProp(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(SUBPROPFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeEqProp(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(EQPROPFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeDomain(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(DOMAINFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeRange(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(RANGEFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeComplement(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(COMPLEMENTFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeDisjoint(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(DISJOINTFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeDisjoints(ATermList aTermList) {
        return factory.makeAppl(DISJOINTSFUN, (ATerm)aTermList);
    }

    public static final ATermAppl makeDisjointProperty(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(DISJOINTPROPFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeDisjointProperties(ATermList aTermList) {
        return factory.makeAppl(DISJOINTPROPSFUN, (ATerm)aTermList);
    }

    public static final ATermAppl makeDifferent(ATerm aTerm, ATerm aTerm2) {
        return factory.makeAppl(DIFFERENTFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeAllDifferent(ATermList aTermList) {
        return factory.makeAppl(ALLDIFFERENTFUN, (ATerm)aTermList);
    }

    public static final ATermAppl makeAsymmetric(ATerm aTerm) {
        return factory.makeAppl(ASYMMETRICFUN, aTerm);
    }

    @Deprecated
    public static final ATermAppl makeAntisymmetric(ATerm aTerm) {
        return ATermUtils.makeAsymmetric(aTerm);
    }

    public static final ATermAppl makeFunctional(ATerm aTerm) {
        return factory.makeAppl(FUNCTIONALFUN, aTerm);
    }

    public static final ATermAppl makeInverseFunctional(ATerm aTerm) {
        return factory.makeAppl(INVFUNCTIONALFUN, aTerm);
    }

    public static final ATermAppl makeIrreflexive(ATerm aTerm) {
        return factory.makeAppl(IRREFLEXIVEFUN, aTerm);
    }

    public static final ATermAppl makeReflexive(ATerm aTerm) {
        return factory.makeAppl(REFLEXIVEFUN, aTerm);
    }

    public static final ATermAppl makeSymmetric(ATerm aTerm) {
        return factory.makeAppl(SYMMETRICFUN, aTerm);
    }

    public static final ATermAppl makeTransitive(ATerm aTerm) {
        return factory.makeAppl(TRANSITIVEFUN, aTerm);
    }

    public static final ATermAppl makeAnd(ATerm aTerm, ATerm aTerm2) {
        return ATermUtils.makeAnd(ATermUtils.makeList(aTerm2).insert(aTerm));
    }

    public static ATermAppl makeAnd(ATermList aTermList) {
        if (aTermList == null) {
            throw new NullPointerException();
        }
        if (aTermList.isEmpty()) {
            return TOP;
        }
        if (aTermList.getNext().isEmpty()) {
            return (ATermAppl)aTermList.getFirst();
        }
        return factory.makeAppl(ANDFUN, (ATerm)aTermList);
    }

    public static final ATermAppl makeOr(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return ATermUtils.makeOr(ATermUtils.makeList((ATerm)aTermAppl2).insert((ATerm)aTermAppl));
    }

    public static ATermAppl makeOr(ATermList aTermList) {
        if (aTermList == null) {
            throw new NullPointerException();
        }
        if (aTermList.isEmpty()) {
            return BOTTOM;
        }
        if (aTermList.getNext().isEmpty()) {
            return (ATermAppl)aTermList.getFirst();
        }
        return factory.makeAppl(ORFUN, (ATerm)aTermList);
    }

    public static final ATermAppl makeAllValues(ATerm aTerm, ATerm aTerm2) {
        ATermList aTermList;
        if (aTerm.getType() == 4 && (aTermList = (ATermList)aTerm).getLength() == 1) {
            aTerm = aTermList.getFirst();
        }
        return factory.makeAppl(ALLFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeSomeValues(ATerm aTerm, ATerm aTerm2) {
        ATermUtils.assertTrue(aTerm2 instanceof ATermAppl);
        return factory.makeAppl(SOMEFUN, aTerm, aTerm2);
    }

    public static final ATermAppl makeSelf(ATermAppl aTermAppl) {
        return factory.makeAppl(SELFFUN, (ATerm)aTermAppl);
    }

    public static final ATermAppl makeHasValue(ATerm aTerm, ATerm aTerm2) {
        ATermAppl aTermAppl = ATermUtils.makeValue(aTerm2);
        return factory.makeAppl(SOMEFUN, aTerm, (ATerm)aTermAppl);
    }

    public static final ATermAppl makeNormalizedMax(ATermAppl aTermAppl, int n, ATermAppl aTermAppl2) {
        ATermUtils.assertTrue(n >= 0);
        return ATermUtils.makeNot((ATerm)ATermUtils.makeMin((ATerm)aTermAppl, n + 1, (ATerm)aTermAppl2));
    }

    public static final ATermAppl makeMax(ATerm aTerm, int n, ATerm aTerm2) {
        return ATermUtils.makeMax(aTerm, factory.makeInt(n), aTerm2);
    }

    public static final ATermAppl makeMax(ATerm aTerm, ATermInt aTermInt, ATerm aTerm2) {
        ATermUtils.assertTrue(aTermInt.getInt() >= 0);
        return factory.makeAppl(MAXFUN, aTerm, (ATerm)aTermInt, aTerm2);
    }

    public static final ATermAppl makeMin(ATerm aTerm, int n, ATerm aTerm2) {
        return ATermUtils.makeMin(aTerm, factory.makeInt(n), aTerm2);
    }

    public static final ATermAppl makeMin(ATerm aTerm, ATermInt aTermInt, ATerm aTerm2) {
        ATermUtils.assertTrue(aTermInt.getInt() >= 0);
        return factory.makeAppl(MINFUN, aTerm, (ATerm)aTermInt, aTerm2);
    }

    public static final ATermAppl makeDisplayCard(ATerm aTerm, int n, ATerm aTerm2) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(CARDFUN, aTerm, (ATerm)factory.makeInt(n), aTerm2);
    }

    public static final ATermAppl makeDisplayMax(ATerm aTerm, int n, ATerm aTerm2) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(MAXFUN, aTerm, (ATerm)factory.makeInt(n), aTerm2);
    }

    public static final ATermAppl makeDisplayMin(ATerm aTerm, int n, ATerm aTerm2) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(MINFUN, aTerm, (ATerm)factory.makeInt(n), aTerm2);
    }

    public static final ATermAppl makeCard(ATerm aTerm, int n, ATerm aTerm2) {
        return ATermUtils.makeDisplayCard(aTerm, n, aTerm2);
    }

    public static final ATermAppl makeExactCard(ATerm aTerm, int n, ATerm aTerm2) {
        return ATermUtils.makeExactCard(aTerm, factory.makeInt(n), aTerm2);
    }

    public static final ATermAppl makeExactCard(ATerm aTerm, ATermInt aTermInt, ATerm aTerm2) {
        ATermAppl aTermAppl = ATermUtils.makeMax(aTerm, aTermInt, aTerm2);
        if (aTermInt.getInt() == 0) {
            return aTermAppl;
        }
        ATermAppl aTermAppl2 = ATermUtils.makeMin(aTerm, aTermInt, aTerm2);
        return ATermUtils.makeAnd((ATerm)aTermAppl2, (ATerm)aTermAppl);
    }

    public static final ATermAppl makeFacetRestriction(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return factory.makeAppl(FACET, (ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public static final ATermAppl makeRestrictedDatatype(ATermAppl aTermAppl, ATermAppl[] aTermApplArray) {
        return factory.makeAppl(RESTRDATATYPEFUN, (ATerm)aTermAppl, (ATerm)ATermUtils.makeList((ATerm[])aTermApplArray));
    }

    public static final ATermAppl makeDatatypeDefinition(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return factory.makeAppl(DATATYPEDEFFUN, (ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public static final boolean isRestrictedDatatype(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(RESTRDATATYPEFUN);
    }

    public static final ATermList makeList(ATerm aTerm) {
        return factory.makeList(aTerm, EMPTY_LIST);
    }

    public static final ATermList makeList(ATerm aTerm, ATermList aTermList) {
        return factory.makeList(aTerm, aTermList);
    }

    public static ATermList makeList(Collection<ATermAppl> collection) {
        ATermList aTermList = EMPTY_LIST;
        for (ATerm aTerm : collection) {
            aTermList = aTermList.insert(aTerm);
        }
        return aTermList;
    }

    public static final ATermList makeList(ATerm[] aTermArray) {
        return ATermUtils.makeList(aTermArray, 0);
    }

    private static ATermList makeList(ATerm[] aTermArray, int n) {
        if (n >= aTermArray.length) {
            return EMPTY_LIST;
        }
        if (n == aTermArray.length - 1) {
            return ATermUtils.makeList(aTermArray[n]);
        }
        return ATermUtils.makeList(aTermArray[n], ATermUtils.makeList(aTermArray, n + 1));
    }

    public static final boolean member(ATerm aTerm, ATermList aTermList) {
        return aTermList.indexOf(aTerm, 0) != -1;
    }

    public static boolean isSet(ATermList aTermList) {
        if (aTermList.isEmpty()) {
            return true;
        }
        ATerm aTerm = aTermList.getFirst();
        aTermList = aTermList.getNext();
        while (!aTermList.isEmpty()) {
            ATerm aTerm2 = aTermList.getFirst();
            if (Comparators.termComparator.compare(aTerm, aTerm2) >= 0) {
                return false;
            }
            aTerm = aTerm2;
            aTermList = aTermList.getNext();
        }
        return true;
    }

    public static ATermList toSet(ATermList aTermList) {
        if (ATermUtils.isSet(aTermList)) {
            return aTermList;
        }
        int n = aTermList.getLength();
        ATermAppl[] aTermApplArray = ATermUtils.toArray(aTermList);
        if (aTermApplArray == null || aTermApplArray.length < n) {
            aTermApplArray = new ATerm[Math.max(100, n)];
        }
        Arrays.sort(aTermApplArray, 0, n, Comparators.termComparator);
        ATermList aTermList2 = ATermUtils.makeList((ATerm)aTermApplArray[n - 1]);
        for (int i = n - 2; i >= 0; --i) {
            ATerm aTerm = aTermList2.getFirst();
            if (aTerm.equals((Object)aTermApplArray[i])) continue;
            aTermList2 = aTermList2.insert((ATerm)aTermApplArray[i]);
        }
        return aTermList2;
    }

    public static ATermList toSet(ATerm[] aTermArray, int n) {
        Arrays.sort(aTermArray, 0, n, Comparators.termComparator);
        ATermList aTermList = ATermUtils.makeList(aTermArray[n - 1]);
        for (int i = n - 2; i >= 0; --i) {
            ATerm aTerm = aTermList.getFirst();
            if (aTerm.equals((Object)aTermArray[i])) continue;
            aTermList = aTermList.insert(aTermArray[i]);
        }
        return aTermList;
    }

    public static ATermList toSet(Collection<ATermAppl> collection) {
        int n = collection.size();
        ATermAppl[] aTermApplArray = new ATermAppl[n];
        collection.toArray(aTermApplArray);
        return ATermUtils.toSet((ATerm[])aTermApplArray, n);
    }

    public static String toString(Collection<ATermAppl> collection) {
        if (collection.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ATermAppl> iterator = collection.iterator();
        stringBuilder.append(ATermUtils.toString(iterator.next()));
        while (iterator.hasNext()) {
            stringBuilder.append(", ");
            stringBuilder.append(ATermUtils.toString(iterator.next()));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(ATermAppl aTermAppl) {
        return ATermUtils.toString(aTermAppl, true, true);
    }

    public static String toString(ATermAppl aTermAppl, boolean bl, boolean bl2) {
        if (aTermAppl == null) {
            return "<null>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ATermUtils.toString(aTermAppl, stringBuilder, bl2 ? Bool.FALSE : Bool.UNKNOWN, bl);
        return stringBuilder.toString();
    }

    private static void toString(ATermAppl aTermAppl, StringBuilder stringBuilder, Bool bool, boolean bl) {
        if (aTermAppl.equals(TOP)) {
            stringBuilder.append(bool.isTrue() ? "owl:Nothing" : "owl:Thing");
        } else if (aTermAppl.equals(BOTTOM)) {
            stringBuilder.append(bool.isTrue() ? "owl:Thing" : "owl:Nothing");
        } else if (ATermUtils.isVar(aTermAppl)) {
            String string = ((ATermAppl)aTermAppl.getArgument(0)).getName();
            if (bl) {
                string = URIUtils.getLocalName(string);
            }
            stringBuilder.append("?").append(string);
        } else if (ATermUtils.isLiteral(aTermAppl)) {
            String string = ((ATermAppl)aTermAppl.getArgument(0)).toString();
            String string2 = ((ATermAppl)aTermAppl.getArgument(1)).getName();
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2);
            stringBuilder.append('\"').append(string).append('\"');
            if (!string2.equals("")) {
                stringBuilder.append('@').append(string2);
            } else if (!aTermAppl2.equals(NO_DATATYPE) && !aTermAppl2.equals(PLAIN_LITERAL_DATATYPE)) {
                stringBuilder.append("^^");
                ATermUtils.toString(aTermAppl2, stringBuilder, Bool.FALSE, bl);
            }
        } else if (ATermUtils.isPrimitive(aTermAppl)) {
            if (bool.isTrue()) {
                stringBuilder.append("not(");
            }
            String string = aTermAppl.getName();
            stringBuilder.append(URIUtils.getLocalName(string));
            if (bool.isTrue()) {
                stringBuilder.append(")");
            }
        } else if (ATermUtils.isRestrictedDatatype(aTermAppl)) {
            if (bool.isTrue()) {
                stringBuilder.append("not(");
            }
            ATermUtils.toString((ATermAppl)aTermAppl.getArgument(0), stringBuilder, Bool.FALSE, bl);
            stringBuilder.append("[");
            ATermList aTermList = (ATermList)aTermAppl.getArgument(1);
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl3 = (ATermAppl)aTermList.getFirst();
                stringBuilder.append(ATermManchesterSyntaxRenderer.FACETS.get(aTermAppl3.getArgument(0)));
                stringBuilder.append(" ");
                ATermUtils.toString((ATermAppl)aTermAppl3.getArgument(1), stringBuilder, Bool.FALSE, bl);
                if ((aTermList = aTermList.getNext()).isEmpty()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            if (bool.isTrue()) {
                stringBuilder.append(")");
            }
        } else if (bool.isKnown() && ATermUtils.isNot(aTermAppl)) {
            ATermUtils.toString((ATermAppl)aTermAppl.getArgument(0), stringBuilder, bool.not(), bl);
        } else {
            AFun aFun = aTermAppl.getAFun();
            if (bool.isTrue()) {
                if (aFun.equals(ANDFUN)) {
                    stringBuilder.append(ORFUN.getName());
                } else if (aFun.equals(ORFUN)) {
                    stringBuilder.append(ANDFUN.getName());
                } else if (aFun.equals(SOMEFUN)) {
                    stringBuilder.append(ALLFUN.getName());
                } else if (aFun.equals(ALLFUN)) {
                    stringBuilder.append(SOMEFUN.getName());
                } else if (aFun.equals(MINFUN)) {
                    stringBuilder.append(MAXFUN.getName());
                } else if (aFun.equals(MAXFUN)) {
                    stringBuilder.append(MINFUN.getName());
                } else if (!aFun.equals(NOTFUN)) {
                    if (aFun.equals(VALUEFUN) || aFun.equals(RESTRDATATYPEFUN)) {
                        stringBuilder.append("not(");
                    }
                    stringBuilder.append(aFun.getName());
                }
            } else {
                stringBuilder.append(aFun.getName());
            }
            Bool bool2 = bool;
            if (bool.isKnown() && aFun.equals(MINFUN) || aFun.equals(MAXFUN)) {
                bool2 = Bool.FALSE;
            } else if (aFun.equals(NOTFUN)) {
                bool2 = bool.not();
            }
            stringBuilder.append("(");
            int n = aTermAppl.getArity();
            for (int i = 0; i < n; ++i) {
                ATerm aTerm;
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if ((aTerm = aTermAppl.getArgument(i)) instanceof ATermAppl) {
                    ATermUtils.toString((ATermAppl)aTerm, stringBuilder, i > 0 ? bool2 : Bool.FALSE, bl);
                    continue;
                }
                if (aTerm instanceof ATermList) {
                    stringBuilder.append("[");
                    ATermList aTermList = (ATermList)aTerm;
                    while (!aTermList.isEmpty()) {
                        ATermUtils.toString((ATermAppl)aTermList.getFirst(), stringBuilder, bool2, bl);
                        if ((aTermList = aTermList.getNext()).isEmpty()) continue;
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("]");
                    continue;
                }
                int n2 = ((ATermInt)aTerm).getInt();
                if (bool.isTrue()) {
                    if (aFun.equals(MINFUN)) {
                        --n2;
                    } else if (aFun.equals(MAXFUN)) {
                        ++n2;
                    }
                }
                stringBuilder.append(n2);
            }
            stringBuilder.append(")");
            if ((aFun.equals(VALUEFUN) || aFun.equals(RESTRDATATYPEFUN)) && bool.isTrue()) {
                stringBuilder.append(")");
            }
        }
    }

    public static ATermAppl[] toArray(ATermList aTermList) {
        ATermAppl[] aTermApplArray = new ATermAppl[aTermList.getLength()];
        int n = 0;
        while (!aTermList.isEmpty()) {
            aTermApplArray[n++] = (ATermAppl)aTermList.getFirst();
            aTermList = aTermList.getNext();
        }
        return aTermApplArray;
    }

    public static final void assertTrue(boolean bl) {
        if (!bl) {
            throw new RuntimeException("assertion failed.");
        }
    }

    public static final boolean isPrimitive(ATermAppl aTermAppl) {
        return aTermAppl.getArity() == 0;
    }

    public static final boolean isNegatedPrimitive(ATermAppl aTermAppl) {
        return ATermUtils.isNot(aTermAppl) && ATermUtils.isPrimitive((ATermAppl)aTermAppl.getArgument(0));
    }

    public static final boolean isPrimitiveOrNegated(ATermAppl aTermAppl) {
        return ATermUtils.isPrimitive(aTermAppl) || ATermUtils.isNegatedPrimitive(aTermAppl);
    }

    public static final boolean isBnode(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(BNODE_FUN);
    }

    public static final boolean isAnon(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(ANON_FUN);
    }

    public static final boolean isBuiltinProperty(ATermAppl aTermAppl) {
        return TOP_OBJECT_PROPERTY.equals(aTermAppl) || BOTTOM_OBJECT_PROPERTY.equals(aTermAppl) || ATermUtils.makeInv(TOP_OBJECT_PROPERTY).equals(aTermAppl) || ATermUtils.makeInv(BOTTOM_OBJECT_PROPERTY).equals(aTermAppl) || TOP_DATA_PROPERTY.equals(aTermAppl) || BOTTOM_DATA_PROPERTY.equals(aTermAppl);
    }

    public static Set<ATermAppl> listToSet(ATermList aTermList) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        while (!aTermList.isEmpty()) {
            hashSet.add((ATermAppl)aTermList.getFirst());
            aTermList = aTermList.getNext();
        }
        return hashSet;
    }

    public static Set<ATermAppl> getPrimitives(ATermList aTermList) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        while (!aTermList.isEmpty()) {
            ATermAppl aTermAppl = (ATermAppl)aTermList.getFirst();
            if (ATermUtils.isPrimitive(aTermAppl)) {
                hashSet.add(aTermAppl);
            }
            aTermList = aTermList.getNext();
        }
        return hashSet;
    }

    public static final ATermAppl getTop(Role role) {
        return role.isDatatypeRole() ? TOP_LIT : TOP;
    }

    public static final boolean isTop(ATermAppl aTermAppl) {
        return aTermAppl.equals(TOP) || aTermAppl.equals(TOP_LIT);
    }

    public static final boolean isBottom(ATermAppl aTermAppl) {
        return aTermAppl.equals(BOTTOM) || aTermAppl.equals(BOTTOM_LIT);
    }

    public static final boolean isInv(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(INVFUN);
    }

    public static final boolean isAnd(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(ANDFUN);
    }

    public static final boolean isOr(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(ORFUN);
    }

    public static final boolean isAllValues(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(ALLFUN);
    }

    public static final boolean isSomeValues(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(SOMEFUN);
    }

    public static final boolean isSelf(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(SELFFUN);
    }

    public static final boolean isHasValue(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(SOMEFUN) && ((ATermAppl)aTermAppl.getArgument(1)).getAFun().equals(VALUEFUN);
    }

    public static final boolean isNominal(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(VALUEFUN);
    }

    public static final boolean isOneOf(ATermAppl aTermAppl) {
        if (!aTermAppl.getAFun().equals(ORFUN)) {
            return false;
        }
        ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
        while (!aTermList.isEmpty()) {
            if (!ATermUtils.isNominal((ATermAppl)aTermList.getFirst())) {
                return false;
            }
            aTermList = aTermList.getNext();
        }
        return true;
    }

    public static final boolean isDataRange(ATermAppl aTermAppl) {
        if (!aTermAppl.getAFun().equals(ORFUN)) {
            return false;
        }
        ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
        while (!aTermList.isEmpty()) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
            if (!ATermUtils.isNominal(aTermAppl2) || !ATermUtils.isLiteral((ATermAppl)aTermAppl2.getArgument(0))) {
                return false;
            }
            aTermList = aTermList.getNext();
        }
        return true;
    }

    public static final boolean isNot(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(NOTFUN);
    }

    public static final boolean isMax(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(MAXFUN);
    }

    public static final boolean isMin(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(MINFUN);
    }

    public static final boolean isCard(ATermAppl aTermAppl) {
        if (ATermUtils.isMin(aTermAppl) || ATermUtils.isMax(aTermAppl)) {
            return true;
        }
        if (ATermUtils.isAnd(aTermAppl)) {
            return ATermUtils.isMin(aTermAppl = (ATermAppl)aTermAppl.getArgument(0)) || ATermUtils.isMax(aTermAppl);
        }
        return false;
    }

    public static final boolean isLiteral(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(LITFUN);
    }

    public static final boolean isVar(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(VARFUN);
    }

    public static final boolean isTransitiveChain(ATermList aTermList, ATerm aTerm) {
        return aTermList.getLength() == 2 && aTermList.getFirst().equals((Object)aTerm) && aTermList.getLast().equals((Object)aTerm);
    }

    public static boolean isComplexClass(ATerm aTerm) {
        if (aTerm instanceof ATermAppl) {
            ATermAppl aTermAppl = (ATermAppl)aTerm;
            AFun aFun = aTermAppl.getAFun();
            return CLASS_FUN.contains(aFun);
        }
        return false;
    }

    public static final boolean isPropertyAssertion(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(PROPFUN);
    }

    public static final boolean isTypeAssertion(ATermAppl aTermAppl) {
        return aTermAppl.getAFun().equals(TYPEFUN);
    }

    public static ATerm nnf(ATerm aTerm) {
        if (aTerm instanceof ATermList) {
            return ATermUtils.nnf((ATermList)aTerm);
        }
        if (aTerm instanceof ATermAppl) {
            return ATermUtils.nnf((ATermAppl)aTerm);
        }
        return null;
    }

    public static ATermList nnf(ATermList aTermList) {
        ATermList aTermList2 = factory.makeList();
        while (!aTermList.isEmpty()) {
            aTermList2 = aTermList2.append((ATerm)ATermUtils.nnf((ATermAppl)aTermList.getFirst()));
            aTermList = aTermList.getNext();
        }
        return aTermList2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ATermAppl nnf(ATermAppl aTermAppl) {
        ATermAppl aTermAppl2 = null;
        AFun aFun = aTermAppl.getAFun();
        if (aFun.equals(NOTFUN)) {
            ATermUtils.assertTrue(aFun.getArity() == 1);
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(0);
            aFun = aTermAppl3.getAFun();
            if (aTermAppl3.getArity() == 0) {
                aTermAppl2 = aTermAppl;
            } else if (aFun.equals(NOTFUN)) {
                aTermAppl2 = ATermUtils.nnf((ATermAppl)aTermAppl3.getArgument(0));
            } else if (aFun.equals(VALUEFUN) || aFun.equals(SELFFUN) || aFun.equals(RESTRDATATYPEFUN)) {
                aTermAppl2 = aTermAppl;
            } else if (aFun.equals(MAXFUN)) {
                ATermInt aTermInt = (ATermInt)aTermAppl3.getArgument(1);
                aTermAppl2 = ATermUtils.makeMin(aTermAppl3.getArgument(0), aTermInt.getInt() + 1, ATermUtils.nnf(aTermAppl3.getArgument(2)));
            } else if (aFun.equals(MINFUN)) {
                ATermInt aTermInt = (ATermInt)aTermAppl3.getArgument(1);
                aTermAppl2 = aTermInt.getInt() == 0 ? BOTTOM : ATermUtils.makeMax(aTermAppl3.getArgument(0), aTermInt.getInt() - 1, ATermUtils.nnf(aTermAppl3.getArgument(2)));
            } else if (aFun.equals(CARDFUN)) {
                aTermAppl2 = ATermUtils.nnf(ATermUtils.makeNot((ATerm)ATermUtils.makeExactCard(aTermAppl3.getArgument(0), (ATermInt)aTermAppl3.getArgument(1), aTermAppl3.getArgument(2))));
            } else if (aFun.equals(ANDFUN)) {
                aTermAppl2 = ATermUtils.makeOr(ATermUtils.nnf(ATermUtils.negate((ATermList)aTermAppl3.getArgument(0))));
            } else if (aFun.equals(ORFUN)) {
                aTermAppl2 = ATermUtils.makeAnd(ATermUtils.nnf(ATermUtils.negate((ATermList)aTermAppl3.getArgument(0))));
            } else if (aFun.equals(SOMEFUN)) {
                ATerm aTerm = aTermAppl3.getArgument(0);
                ATerm aTerm2 = aTermAppl3.getArgument(1);
                aTermAppl2 = ATermUtils.makeAllValues(aTerm, (ATerm)ATermUtils.nnf(ATermUtils.makeNot(aTerm2)));
            } else {
                if (!aFun.equals(ALLFUN)) throw new InternalReasonerException("Unknown term type: " + aTermAppl);
                ATerm aTerm = aTermAppl3.getArgument(0);
                ATerm aTerm3 = aTermAppl3.getArgument(1);
                aTermAppl2 = ATermUtils.makeSomeValues(aTerm, (ATerm)ATermUtils.nnf(ATermUtils.makeNot(aTerm3)));
            }
        } else if (aFun.equals(MINFUN) || aFun.equals(MAXFUN) || aFun.equals(SELFFUN)) {
            aTermAppl2 = aTermAppl;
        } else if (aFun.equals(CARDFUN)) {
            aTermAppl2 = ATermUtils.nnf(ATermUtils.makeExactCard(aTermAppl.getArgument(0), (ATermInt)aTermAppl.getArgument(1), aTermAppl.getArgument(2)));
        } else {
            ATerm[] aTermArray = new ATerm[aTermAppl.getArity()];
            for (int i = 0; i < aTermAppl.getArity(); ++i) {
                aTermArray[i] = ATermUtils.nnf(aTermAppl.getArgument(i));
            }
            aTermAppl2 = factory.makeAppl(aFun, aTermArray);
        }
        ATermUtils.assertTrue(aTermAppl2 != null);
        return aTermAppl2;
    }

    public static Collection<ATermAppl> normalize(Collection<ATermAppl> collection) {
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        for (ATermAppl aTermAppl : collection) {
            arrayList.add(ATermUtils.normalize(aTermAppl));
        }
        return arrayList;
    }

    public static ATermList normalize(ATermList aTermList) {
        int n = aTermList.getLength();
        ATerm[] aTermArray = new ATerm[n];
        for (int i = 0; i < n; ++i) {
            aTermArray[i] = ATermUtils.normalize((ATermAppl)aTermList.getFirst());
            aTermList = aTermList.getNext();
        }
        ATermList aTermList2 = ATermUtils.toSet(aTermArray, n);
        return aTermList2;
    }

    public static ATermAppl normalize(ATermAppl aTermAppl) {
        ATerm aTerm;
        ATermAppl aTermAppl2 = aTermAppl;
        AFun aFun = aTermAppl.getAFun();
        ATerm aTerm2 = aTermAppl.getArity() > 0 ? aTermAppl.getArgument(0) : null;
        ATerm aTerm3 = aTermAppl.getArity() > 1 ? aTermAppl.getArgument(1) : null;
        ATerm aTerm4 = aTerm = aTermAppl.getArity() > 2 ? aTermAppl.getArgument(2) : null;
        if (!(aTerm2 == null || aFun.equals(SELFFUN) || aFun.equals(VALUEFUN) || aFun.equals(INVFUN) || aFun.equals(RESTRDATATYPEFUN))) {
            if (aFun.equals(NOTFUN)) {
                if (!ATermUtils.isPrimitive((ATermAppl)aTerm2)) {
                    aTermAppl2 = ATermUtils.simplify(ATermUtils.makeNot((ATerm)ATermUtils.normalize((ATermAppl)aTerm2)));
                }
            } else if (aFun.equals(ANDFUN)) {
                aTermAppl2 = ATermUtils.simplify(ATermUtils.makeAnd(ATermUtils.normalize((ATermList)aTerm2)));
            } else if (aFun.equals(ORFUN)) {
                ATermList aTermList = ATermUtils.negate((ATermList)aTerm2);
                ATermAppl aTermAppl3 = ATermUtils.makeAnd(aTermList);
                ATermAppl aTermAppl4 = ATermUtils.makeNot((ATerm)aTermAppl3);
                aTermAppl2 = ATermUtils.normalize(aTermAppl4);
            } else if (aFun.equals(ALLFUN)) {
                aTermAppl2 = ATermUtils.simplify(ATermUtils.makeAllValues(aTerm2, (ATerm)ATermUtils.normalize((ATermAppl)aTerm3)));
            } else if (aFun.equals(SOMEFUN)) {
                aTermAppl2 = ATermUtils.normalize(ATermUtils.makeNot((ATerm)ATermUtils.makeAllValues(aTerm2, (ATerm)ATermUtils.makeNot(aTerm3))));
            } else if (aFun.equals(MAXFUN)) {
                aTermAppl2 = ATermUtils.normalize(ATermUtils.makeNot((ATerm)ATermUtils.makeMin(aTerm2, ((ATermInt)aTerm3).getInt() + 1, aTerm)));
            } else if (aFun.equals(MINFUN)) {
                aTermAppl2 = ATermUtils.simplify(ATermUtils.makeMin(aTerm2, (ATermInt)aTerm3, (ATerm)ATermUtils.normalize((ATermAppl)aTerm)));
            } else if (aFun.equals(CARDFUN)) {
                ATermAppl aTermAppl5 = ATermUtils.simplify(ATermUtils.makeMin(aTerm2, ((ATermInt)aTerm3).getInt(), (ATerm)ATermUtils.normalize((ATermAppl)aTerm)));
                ATermAppl aTermAppl6 = ATermUtils.normalize(ATermUtils.makeMax(aTerm2, ((ATermInt)aTerm3).getInt(), aTerm));
                aTermAppl2 = ATermUtils.simplify(ATermUtils.makeAnd((ATerm)aTermAppl5, (ATerm)aTermAppl6));
            } else {
                throw new InternalReasonerException("Unknown concept type: " + aTermAppl);
            }
        }
        return aTermAppl2;
    }

    public static ATermAppl simplify(ATermAppl aTermAppl) {
        ATerm aTerm;
        ATermAppl aTermAppl2 = aTermAppl;
        AFun aFun = aTermAppl.getAFun();
        ATerm aTerm2 = aTermAppl.getArity() > 0 ? aTermAppl.getArgument(0) : null;
        ATerm aTerm3 = aTermAppl.getArity() > 1 ? aTermAppl.getArgument(1) : null;
        ATerm aTerm4 = aTerm = aTermAppl.getArity() > 2 ? aTermAppl.getArgument(2) : null;
        if (!(aTerm2 == null || aFun.equals(SELFFUN) || aFun.equals(VALUEFUN) || aFun.equals(RESTRDATATYPEFUN))) {
            if (aFun.equals(NOTFUN)) {
                ATermInt aTermInt;
                ATermAppl aTermAppl3 = (ATermAppl)aTerm2;
                if (ATermUtils.isNot(aTermAppl3)) {
                    aTermAppl2 = ATermUtils.simplify((ATermAppl)aTermAppl3.getArgument(0));
                } else if (ATermUtils.isMin(aTermAppl3) && (aTermInt = (ATermInt)aTermAppl3.getArgument(1)).getInt() == 0) {
                    aTermAppl2 = BOTTOM;
                }
            } else if (aFun.equals(ANDFUN)) {
                ATermList aTermList = (ATermList)aTerm2;
                if (aTermList.isEmpty()) {
                    aTermAppl2 = TOP;
                } else {
                    HashSet<Object> hashSet = new HashSet<Object>();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    MultiListIterator multiListIterator = new MultiListIterator(aTermList);
                    while (multiListIterator.hasNext()) {
                        ATermAppl aTermAppl4 = multiListIterator.next();
                        if (aTermAppl4.equals(TOP)) continue;
                        if (aTermAppl4.equals(BOTTOM)) {
                            return BOTTOM;
                        }
                        if (ATermUtils.isAnd(aTermAppl4)) {
                            multiListIterator.append((ATermList)aTermAppl4.getArgument(0));
                            continue;
                        }
                        if (ATermUtils.isNot(aTermAppl4)) {
                            arrayList.add(aTermAppl4);
                            continue;
                        }
                        hashSet.add(aTermAppl4);
                    }
                    for (ATermAppl aTermApplArray2 : arrayList) {
                        ATermAppl aTermAppl3 = (ATermAppl)aTermApplArray2.getArgument(0);
                        if (!hashSet.contains(aTermAppl3)) continue;
                        return BOTTOM;
                    }
                    if (hashSet.isEmpty()) {
                        if (arrayList.isEmpty()) {
                            return TOP;
                        }
                        if (arrayList.size() == 1) {
                            return (ATermAppl)arrayList.get(0);
                        }
                    } else if (hashSet.size() == 1 && arrayList.isEmpty()) {
                        return (ATermAppl)hashSet.iterator().next();
                    }
                    arrayList.addAll(hashSet);
                    int n = arrayList.size();
                    ATermAppl[] aTermApplArray = new ATermAppl[n];
                    arrayList.toArray(aTermApplArray);
                    aTermAppl2 = ATermUtils.makeAnd(ATermUtils.toSet((ATerm[])aTermApplArray, n));
                }
            } else if (aFun.equals(ALLFUN)) {
                if (aTerm3.equals((Object)TOP)) {
                    aTermAppl2 = TOP;
                }
            } else if (aFun.equals(MINFUN)) {
                ATermInt aTermInt = (ATermInt)aTerm3;
                if (aTermInt.getInt() == 0) {
                    aTermAppl2 = TOP;
                }
                if (aTerm.equals((Object)BOTTOM)) {
                    aTermAppl2 = BOTTOM;
                }
            } else if (aFun.equals(MAXFUN)) {
                ATermInt aTermInt = (ATermInt)aTerm3;
                if (aTermInt.getInt() > 0 && aTerm.equals((Object)BOTTOM)) {
                    aTermAppl2 = TOP;
                }
            } else {
                throw new InternalReasonerException("Unknown term type: " + aTermAppl);
            }
        }
        return aTermAppl2;
    }

    public static ATermAppl makeSimplifiedAnd(Collection<ATermAppl> collection) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        MultiListIterator multiListIterator = new MultiListIterator(EMPTY_LIST);
        PairIterator<ATermAppl> pairIterator = new PairIterator<ATermAppl>(collection.iterator(), multiListIterator);
        while (pairIterator.hasNext()) {
            ATermAppl aTermAppl = (ATermAppl)pairIterator.next();
            if (aTermAppl.equals(TOP)) continue;
            if (aTermAppl.equals(BOTTOM)) {
                return BOTTOM;
            }
            if (ATermUtils.isAnd(aTermAppl)) {
                multiListIterator.append((ATermList)aTermAppl.getArgument(0));
                continue;
            }
            if (ATermUtils.isNot(aTermAppl)) {
                arrayList.add(aTermAppl);
                continue;
            }
            hashSet.add(aTermAppl);
        }
        for (ATermAppl aTermApplArray2 : arrayList) {
            ATermAppl aTermAppl = (ATermAppl)aTermApplArray2.getArgument(0);
            if (!hashSet.contains(aTermAppl)) continue;
            return BOTTOM;
        }
        if (hashSet.isEmpty()) {
            if (arrayList.isEmpty()) {
                return TOP;
            }
            if (arrayList.size() == 1) {
                return (ATermAppl)arrayList.get(0);
            }
        } else if (hashSet.size() == 1 && arrayList.isEmpty()) {
            return (ATermAppl)hashSet.iterator().next();
        }
        arrayList.addAll(hashSet);
        int n = arrayList.size();
        ATermAppl[] aTermApplArray = new ATermAppl[n];
        arrayList.toArray(aTermApplArray);
        return ATermUtils.makeAnd(ATermUtils.toSet((ATerm[])aTermApplArray, n));
    }

    public static Set<ATermAppl> findPrimitives(ATermAppl aTermAppl) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        ATermUtils.findPrimitives(aTermAppl, hashSet, false, false);
        return hashSet;
    }

    public static Set<ATermAppl> findPrimitives(ATermAppl aTermAppl, boolean bl, boolean bl2) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        ATermUtils.findPrimitives(aTermAppl, hashSet, bl, bl2);
        return hashSet;
    }

    public static void findPrimitives(ATermAppl aTermAppl, Set<ATermAppl> set) {
        ATermUtils.findPrimitives(aTermAppl, set, false, false);
    }

    public static void findPrimitives(ATermAppl aTermAppl, Set<ATermAppl> set, boolean bl, boolean bl2) {
        AFun aFun = aTermAppl.getAFun();
        if (ATermUtils.isPrimitive(aTermAppl)) {
            set.add(aTermAppl);
        } else if (!(aFun.equals(SELFFUN) || aFun.equals(VALUEFUN) || aFun.equals(RESTRDATATYPEFUN))) {
            if (aFun.equals(NOTFUN)) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
                if (!ATermUtils.isPrimitive(aTermAppl2) || !bl2) {
                    ATermUtils.findPrimitives(aTermAppl2, set, bl, false);
                }
            } else if (aFun.equals(ANDFUN) || aFun.equals(ORFUN)) {
                ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
                while (!aTermList.isEmpty()) {
                    ATermAppl aTermAppl3 = (ATermAppl)aTermList.getFirst();
                    if (!ATermUtils.isNegatedPrimitive(aTermAppl3) || !bl2) {
                        ATermUtils.findPrimitives(aTermAppl3, set, bl, false);
                    }
                    aTermList = aTermList.getNext();
                }
            } else if (!bl) {
                if (aFun.equals(ALLFUN) || aFun.equals(SOMEFUN)) {
                    ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(1);
                    ATermUtils.findPrimitives(aTermAppl4, set, bl, false);
                } else if (aFun.equals(MAXFUN) || aFun.equals(MINFUN) || aFun.equals(CARDFUN)) {
                    ATermAppl aTermAppl5 = (ATermAppl)aTermAppl.getArgument(2);
                    ATermUtils.findPrimitives(aTermAppl5, set, bl, false);
                } else {
                    throw new InternalReasonerException("Unknown concept type: " + aTermAppl);
                }
            }
        }
    }

    public static Collection<ATermAppl> primitiveOrBottom(Collection<ATermAppl> collection) {
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        for (ATermAppl aTermAppl : collection) {
            if (!ATermUtils.isPrimitive(aTermAppl) && aTermAppl != BOTTOM) continue;
            arrayList.add(aTermAppl);
        }
        return arrayList;
    }

    public static Set<ATermAppl> primitiveOrBottom(Set<ATermAppl> set) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (ATermAppl aTermAppl : set) {
            if (!ATermUtils.isPrimitive(aTermAppl) && aTermAppl != BOTTOM) continue;
            hashSet.add(aTermAppl);
        }
        return hashSet;
    }

    public static ATermAppl makeRule(ATermAppl[] aTermApplArray, ATermAppl[] aTermApplArray2) {
        return ATermUtils.makeRule(null, aTermApplArray, aTermApplArray2);
    }

    public static ATermAppl makeRule(ATermAppl aTermAppl, ATermAppl[] aTermApplArray, ATermAppl[] aTermApplArray2) {
        return factory.makeAppl(RULEFUN, (ATerm)(aTermAppl == null ? EMPTY : aTermAppl), (ATerm)ATermUtils.makeList((ATerm[])aTermApplArray), (ATerm)ATermUtils.makeList((ATerm[])aTermApplArray2));
    }

    public static ATermAppl makeBuiltinAtom(ATermAppl[] aTermApplArray) {
        return factory.makeAppl(BUILTINFUN, (ATerm)ATermUtils.makeList((ATerm[])aTermApplArray));
    }

    static {
        ANTISYMMETRICFUN = ASYMMETRICFUN = factory.makeAFun("asymmetric", 1, false);
        FUNCTIONALFUN = factory.makeAFun("functional", 1, false);
        INVFUNCTIONALFUN = factory.makeAFun("inverseFunctional", 1, false);
        IRREFLEXIVEFUN = factory.makeAFun("irreflexive", 1, false);
        REFLEXIVEFUN = factory.makeAFun("reflexive", 1, false);
        SYMMETRICFUN = factory.makeAFun("symmetric", 1, false);
        TRANSITIVEFUN = factory.makeAFun("transitive", 1, false);
        SUBPROPFUN = factory.makeAFun("subProperty", 2, false);
        EQPROPFUN = factory.makeAFun("equivalentProperty", 2, false);
        INVPROPFUN = factory.makeAFun("inverseProperty", 2, false);
        DOMAINFUN = factory.makeAFun("domain", 2, false);
        RANGEFUN = factory.makeAFun("range", 2, false);
        RULEFUN = factory.makeAFun("rule", 3, false);
        BUILTINFUN = factory.makeAFun("builtin", 1, false);
        DATATYPEDEFFUN = factory.makeAFun("datatypeDefinition", 2, false);
        RESTRDATATYPEFUN = factory.makeAFun("restrictedDatatype", 2, false);
        FACET = factory.makeAFun("facet", 2, false);
        EMPTY = ATermUtils.makeTermAppl("");
        EMPTY_LIST = factory.makeList();
        AXIOM_FUN = SetUtils.create(TYPEFUN, PROPFUN, SAMEASFUN, DIFFERENTFUN, ALLDIFFERENTFUN, SUBFUN, EQCLASSFUN, DISJOINTFUN, DISJOINTSFUN, COMPLEMENTFUN, SUBPROPFUN, EQPROPFUN, INVPROPFUN, DOMAINFUN, RANGEFUN, FUNCTIONALFUN, INVFUNCTIONALFUN, TRANSITIVEFUN, SYMMETRICFUN, REFLEXIVEFUN, IRREFLEXIVEFUN, ANTISYMMETRICFUN);
        TOP = ATermUtils.makeTermAppl("_TOP_");
        BOTTOM = ATermUtils.makeNot((ATerm)TOP);
        TOP_OBJECT_PROPERTY = ATermUtils.makeTermAppl("_TOP_OBJECT_PROPERTY_");
        TOP_DATA_PROPERTY = ATermUtils.makeTermAppl("_TOP_DATA_PROPERTY_");
        BOTTOM_OBJECT_PROPERTY = ATermUtils.makeTermAppl("_BOTTOM_OBJECT_PROPERTY_");
        BOTTOM_DATA_PROPERTY = ATermUtils.makeTermAppl("_BOTTOM_DATA_PROPERTY_");
        TOP_LIT = ATermUtils.makeTermAppl("http://www.w3.org/2000/01/rdf-schema#Literal");
        BOTTOM_LIT = ATermUtils.makeNot((ATerm)TOP_LIT);
        CONCEPT_SAT_IND = ATermUtils.makeTermAppl("_C_");
        ONE = factory.makeInt(1);
        PLAIN_LITERAL_DATATYPE = ATermUtils.makeTermAppl("http://www.w3.org/1999/02/22-rdf-syntax-ns#PlainLiteral");
        qnames = new QNameProvider();
        NO_DATATYPE = ATermUtils.makeTermAppl("NO_DATATYPE");
        BNODE_FUN = factory.makeAFun("bnode", 1, false);
        ANON_FUN = factory.makeAFun("anon", 1, false);
        ANON_NOMINAL_FUN = factory.makeAFun("anon_nominal", 1, false);
        anonCache = new ATermAppl[1000];
        for (int i = 0; i < anonCache.length; ++i) {
            ATermUtils.anonCache[i] = factory.makeAppl(ANON_FUN, (ATerm)factory.makeInt(i));
        }
    }
}

